/**************** (c) 2005 STMicroelectronics **********************

PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  ST7MC_hr.c
LIBRARY VERSION  :  2.0

CREATION DATE : 07.2003 
AUTHOR : PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :  harwdare register definitions

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/

#include "lib.h"


#ifdef __HIWARE__				/* only for HIWARE Compiler*/
volatile u8 PADR @0x00;	/* port A data register             */          
volatile u8 PADDR @0x01;	/* port A data direction register   */
volatile u8 PAOR @0x02;	/* port A option register           */  

volatile u8 PBDR @0x03;	/* port B data register             */          
volatile u8 PBDDR @0x04;	/* port B data direction register   */
volatile u8 PBOR @0x05;	/* port B option register           */

volatile u8 PCDR @0x06;	/* port C data register             */          
volatile u8 PCDDR @0x07;	/* port C data direction register   */
volatile u8 PCOR @0x08;	/* port C option register           */

volatile u8 PDDR @0x09;	/* port D data register             */          
volatile u8 PDDDR @0x0A;	/* port D data direction register   */
volatile u8 PDOR @0x0B;	/* port D option register           */  

volatile u8 PEDR @0x0C;	/* port E data register             */          
volatile u8 PEDDR @0x0D;	/* port E data direction register   */
volatile u8 PEOR @0x0E;	/* port E option register           */

volatile u8 PFDR @0x0F;	/* port F data register             */          
volatile u8 PFDDR @0x10;	/* port F data direction register   */
volatile u8 PFOR @0x11;	/* port F option register           */

volatile u8 PGDR @0x12;	/* port G data register             */          
volatile u8 PGDDR @0x13;	/* port G data direction register   */
volatile u8 PGOR @0x14;	/* port G option register           */

volatile u8 PHDR @0x15;	/* port H data register             */          
volatile u8 PHDDR @0x16;	/* port H data direction register   */
volatile u8 PHOR @0x17;	/* port H option register           */  

volatile u8 SCISR @0x18;		/* SCI status register					*/
volatile u8 SCIDR @0x19;		/* SCI data register					*/
volatile u8 SCIBRR @0x1A;		/* SCI baud rate register				*/
volatile u8 SCICR1 @0x1B;		/* SCI control register 1				*/
volatile u8 SCICR2 @0x1C;		/* SCI control register 2				*/
volatile u8 SCICR3 @0x1D;		/* SCI control register 3				*/
volatile u8 SCIERPR @0x1E;		/* SCI extended receive prescaler register		*/
volatile u8 SCIETPR @0x1F;		/* SCI extended transmit prescaler register		*/

volatile u8 SPIDR @0x21;               /* SPI Data Register                 */
volatile u8 SPICR @0x22;               /* SPI Control Register              */
volatile u8 SPICSR @0x23;              /* SPI Status Register               */

volatile u8 ITSPR0 @0x24;          /* interrupt software priority reg0*/
volatile u8 ITSPR1 @0x25;          /* interrupt software priority reg1*/
volatile u8 ITSPR2 @0x26;          /* interrupt software priority reg2*/
volatile u8 ITSPR3 @0x27;          /* interrupt software priority reg3*/
volatile u8 EICR @0x28;            /* external interrupt control register */   

volatile u8 FSCR @0x29;        		/* Flash Control Status Register */

volatile u8 WWDGCR @0x2A;	    	/* Window Watchdog Control Register */
volatile u8 WWDGWR @0x2B;		    /* Window Watchdog Status Register */

volatile u8 MCCSR @0x2C;	/* Main Clock Control/Status Register */
volatile u8 MCCBCR @0x2D;	/* Main Clock Controller: Beep Control Register */

volatile u8 ADCCSR @0x2E;	/* ADC Control Status Register */
volatile u8 ADCDRH @0x2F;	/* ADC Data Register High */
volatile u8 ADCDRL @0x30;	/* ADC Data Register Low */

volatile u8 TACR2 @0x31;               /* timer A control register 2                 */
volatile u8 TACR1 @0x32;               /* timer A control register 1                 */
volatile u8 TASR @0x33;                /* timer A status register                    */
volatile u8 TAIC1HR @0x34;             /* timer A input capture 1 high register      */
volatile u8 TAIC1LR @0x35;             /* timer A input capture 1 low register       */
volatile u8 TAOC1HR @0x36;             /* timer A output compare 1 high register     */
volatile u8 TAOC1LR @0x37;             /* timer A output compare 1 low register      */
volatile u8 TACHR @0x38;               /* timer A counter high register              */
volatile u8 TACLR @0x39;               /* timer A counter low register               */
volatile u8 TAACHR @0x3A;              /* timer A alternate counter high register    */
volatile u8 TAACLR @0x3B;              /* timer A alternate counter low register     */
volatile u8 TAIC2HR @0x3C;             /* timer A input capture 2 high register      */
volatile u8 TAIC2LR @0x3D;             /* timer A input capture 2 low register       */
volatile u8 TAOC2HR @0x3E;             /* timer A output compare 2 high register     */
volatile u8 TAOC2LR @0x3F;             /* timer A output compare 2 low register      */

volatile u8 SICSR @0x40;               /* System Integrity Control Status Register   */

volatile u8 TBCR2 @0x41;               /* timer B control register 2                 */
volatile u8 TBCR1 @0x42;               /* timer B control register 1                 */
volatile u8 TBSR @0x43;                /* timer B status register                    */
volatile u8 TBIC1HR @0x44;             /* timer B input capture 1 high register      */
volatile u8 TBIC1LR @0x45;             /* timer B input capture 1 low register       */
volatile u8 TBOC1HR @0x46;             /* timer B output compare 1 high register     */
volatile u8 TBOC1LR @0x47;             /* timer B output compare 1 low register      */
volatile u8 TBCHR @0x48;               /* timer B counter high register              */
volatile u8 TBCLR @0x49;               /* timer B counter low register               */
volatile u8 TBACHR @0x4A;              /* timer B alternate counter high register    */
volatile u8 TBACLR @0x4B;              /* timer B alternate counter low register     */
volatile u8 TBIC2HR @0x4C;             /* timer B input capture 2 high register      */
volatile u8 TBIC2LR @0x4D;             /* timer B input capture 2 low register       */
volatile u8 TBOC2HR @0x4E;             /* timer B output compare 2 high register     */
volatile u8 TBOC2LR @0x4F;             /* timer B output compare 2 low register      */

volatile u8 DMCR @0x6B;              /* Debug Control Register                 */
volatile u8 DMSR @0x6C;              /* Debug Status Register                  */
volatile u8 DMBK1H @0x6D;            /* Debug Breakpoint 1 MSB MSB Register    */
volatile u8 DMBK1L @0x6E;            /* Debug Breakpoint 1 MSB MSB Register    */
volatile u8 DMBK2H @0x6F;            /* Debug Breakpoint 1 MSB MSB Register    */
volatile u8 DMBK2L @0x70;            /* Debug Breakpoint 1 MSB MSB Register    */

volatile u8 PWMDCR3 @0x74;             /* PWM AR Timer Duty Cycle Register 3         */
volatile u8 PWMDCR2 @0x75;             /* PWM AR Timer Duty Cycle Register 2         */
volatile u8 PWMDCR1 @0x76;             /* PWM AR Timer Duty Cycle Register 1         */
volatile u8 PWMDCR0 @0x77;             /* PWM AR Timer Duty Cycle Register 0         */
volatile u8 PWMCR @0x78;               /* Auto-Reload Timer Control/Status Register  */
volatile u8 ARTCSR @0x79;              /* Auto-Reload Timer Control/Status Register  */
volatile u8 ARTCAR @0x7A;              /* Auto-Reload Timer Counter Access Register  */
volatile u8 ARTARR @0x7B;              /* Auto-Reload Timer Auto-Reload Register     */
volatile u8 ARTICCSR @0x7C;            /* AR Timer Input Capture Control/Status Reg. */
volatile u8 ARTICR1 @0x7D;             /* AR Timer Input Capture Register 1          */
volatile u8 ARTICR2 @0x7E;             /* AR Timer Input Capture Register 2          */

volatile u8 OACSR @0x7F;	/* Operational Amplifier Control/Status register */

#else

#ifdef __CSMC__							/* only for Cosmic Compiler*/  

@tiny volatile u8 PADR @0x00;	/* port A data register             */          
@tiny volatile u8 PADDR @0x01;	/* port A data direction register   */
@tiny volatile u8 PAOR @0x02;	/* port A option register           */  

@tiny volatile u8 PBDR @0x03;	/* port B data register             */          
@tiny volatile u8 PBDDR @0x04;	/* port B data direction register   */
@tiny volatile u8 PBOR @0x05;	/* port B option register           */

@tiny volatile u8 PCDR @0x06;	/* port C data register             */          
@tiny volatile u8 PCDDR @0x07;	/* port C data direction register   */
@tiny volatile u8 PCOR @0x08;	/* port C option register           */

@tiny volatile u8 PDDR @0x09;	/* port D data register             */          
@tiny volatile u8 PDDDR @0x0A;	/* port D data direction register   */
@tiny volatile u8 PDOR @0x0B;	/* port D option register           */  

@tiny volatile u8 PEDR @0x0C;	/* port E data register             */          
@tiny volatile u8 PEDDR @0x0D;	/* port E data direction register   */
@tiny volatile u8 PEOR @0x0E;	/* port E option register           */

@tiny volatile u8 PFDR @0x0F;	/* port F data register             */          
@tiny volatile u8 PFDDR @0x10;	/* port F data direction register   */
@tiny volatile u8 PFOR @0x11;	/* port F option register           */

@tiny volatile u8 PGDR @0x12;	/* port G data register             */          
@tiny volatile u8 PGDDR @0x13;	/* port G data direction register   */
@tiny volatile u8 PGOR @0x14;	/* port G option register           */

@tiny volatile u8 PHDR @0x15;	/* port H data register             */          
@tiny volatile u8 PHDDR @0x16;	/* port H data direction register   */
@tiny volatile u8 PHOR @0x17;	/* port H option register           */  

@tiny volatile u8 SCISR @0x18;		/* SCI status register					*/
@tiny volatile u8 SCIDR @0x19;		/* SCI data register					*/
@tiny volatile u8 SCIBRR @0x1A;		/* SCI baud rate register				*/
@tiny volatile u8 SCICR1 @0x1B;		/* SCI control register 1				*/
@tiny volatile u8 SCICR2 @0x1C;		/* SCI control register 2				*/
@tiny volatile u8 SCICR3 @0x1D;		/* SCI control register 3				*/
@tiny volatile u8 SCIERPR @0x1E;		/* SCI extended receive prescaler register		*/
@tiny volatile u8 SCIETPR @0x1F;		/* SCI extended transmit prescaler register		*/

@tiny volatile u8 SPIDR @0x21;               /* SPI Data Register                 */
@tiny volatile u8 SPICR @0x22;               /* SPI Control Register              */
@tiny volatile u8 SPICSR @0x23;              /* SPI Status Register               */

@tiny volatile u8 ITSPR0 @0x24;          /* interrupt software priority reg0*/
@tiny volatile u8 ITSPR1 @0x25;          /* interrupt software priority reg1*/
@tiny volatile u8 ITSPR2 @0x26;          /* interrupt software priority reg2*/
@tiny volatile u8 ITSPR3 @0x27;          /* interrupt software priority reg3*/
@tiny volatile u8 EICR @0x28;            /* external interrupt control register */   

@tiny volatile u8 FSCR @0x29;        		/* Flash Control Status Register */

@tiny volatile u8 WWDGCR @0x2A;	    	/* Window Watchdog Control Register */
@tiny volatile u8 WWDGWR @0x2B;		    /* Window Watchdog Status Register */

@tiny volatile u8 MCCSR @0x2C;	/* Main Clock Control/Status Register */
@tiny volatile u8 MCCBCR @0x2D;	/* Main Clock Controller: Beep Control Register */

@tiny volatile u8 ADCCSR @0x2E;	/* ADC Control Status Register */
@tiny volatile u8 ADCDRH @0x2F;	/* ADC Data Register High */
@tiny volatile u8 ADCDRL @0x30;	/* ADC Data Register Low */

@tiny volatile u8 TACR2 @0x31;               /* timer A control register 2                 */
@tiny volatile u8 TACR1 @0x32;               /* timer A control register 1                 */
@tiny volatile u8 TASR @0x33;                /* timer A status register                    */
@tiny volatile u8 TAIC1HR @0x34;             /* timer A input capture 1 high register      */
@tiny volatile u8 TAIC1LR @0x35;             /* timer A input capture 1 low register       */
@tiny volatile u8 TAOC1HR @0x36;             /* timer A output compare 1 high register     */
@tiny volatile u8 TAOC1LR @0x37;             /* timer A output compare 1 low register      */
@tiny volatile u8 TACHR @0x38;               /* timer A counter high register              */
@tiny volatile u8 TACLR @0x39;               /* timer A counter low register               */
@tiny volatile u8 TAACHR @0x3A;              /* timer A alternate counter high register    */
@tiny volatile u8 TAACLR @0x3B;              /* timer A alternate counter low register     */
@tiny volatile u8 TAIC2HR @0x3C;             /* timer A input capture 2 high register      */
@tiny volatile u8 TAIC2LR @0x3D;             /* timer A input capture 2 low register       */
@tiny volatile u8 TAOC2HR @0x3E;             /* timer A output compare 2 high register     */
@tiny volatile u8 TAOC2LR @0x3F;             /* timer A output compare 2 low register      */

@tiny volatile u8 SICSR @0x40;               /* System Integrity Control Status Register   */

@tiny volatile u8 TBCR2 @0x41;               /* timer B control register 2                 */
@tiny volatile u8 TBCR1 @0x42;               /* timer B control register 1                 */
@tiny volatile u8 TBSR @0x43;                /* timer B status register                    */
@tiny volatile u8 TBIC1HR @0x44;             /* timer B input capture 1 high register      */
@tiny volatile u8 TBIC1LR @0x45;             /* timer B input capture 1 low register       */
@tiny volatile u8 TBOC1HR @0x46;             /* timer B output compare 1 high register     */
@tiny volatile u8 TBOC1LR @0x47;             /* timer B output compare 1 low register      */
@tiny volatile u8 TBCHR @0x48;               /* timer B counter high register              */
@tiny volatile u8 TBCLR @0x49;               /* timer B counter low register               */
@tiny volatile u8 TBACHR @0x4A;              /* timer B alternate counter high register    */
@tiny volatile u8 TBACLR @0x4B;              /* timer B alternate counter low register     */
@tiny volatile u8 TBIC2HR @0x4C;             /* timer B input capture 2 high register      */
@tiny volatile u8 TBIC2LR @0x4D;             /* timer B input capture 2 low register       */
@tiny volatile u8 TBOC2HR @0x4E;             /* timer B output compare 2 high register     */
@tiny volatile u8 TBOC2LR @0x4F;             /* timer B output compare 2 low register      */

@tiny volatile u8 DMCR @0x6B;              /* Debug Control Register                 */
@tiny volatile u8 DMSR @0x6C;              /* Debug Status Register                  */
@tiny volatile u8 DMBK1H @0x6D;            /* Debug Breakpoint 1 MSB MSB Register    */
@tiny volatile u8 DMBK1L @0x6E;            /* Debug Breakpoint 1 MSB MSB Register    */
@tiny volatile u8 DMBK2H @0x6F;            /* Debug Breakpoint 1 MSB MSB Register    */
@tiny volatile u8 DMBK2L @0x70;            /* Debug Breakpoint 1 MSB MSB Register    */

@tiny volatile u8 PWMDCR3 @0x74;             /* PWM AR Timer Duty Cycle Register 3         */
@tiny volatile u8 PWMDCR2 @0x75;             /* PWM AR Timer Duty Cycle Register 2         */
@tiny volatile u8 PWMDCR1 @0x76;             /* PWM AR Timer Duty Cycle Register 1         */
@tiny volatile u8 PWMDCR0 @0x77;             /* PWM AR Timer Duty Cycle Register 0         */
@tiny volatile u8 PWMCR @0x78;               /* Auto-Reload Timer Control/Status Register  */
@tiny volatile u8 ARTCSR @0x79;              /* Auto-Reload Timer Control/Status Register  */
@tiny volatile u8 ARTCAR @0x7A;              /* Auto-Reload Timer Counter Access Register  */
@tiny volatile u8 ARTARR @0x7B;              /* Auto-Reload Timer Auto-Reload Register     */
@tiny volatile u8 ARTICCSR @0x7C;            /* AR Timer Input Capture Control/Status Reg. */
@tiny volatile u8 ARTICR1 @0x7D;             /* AR Timer Input Capture Register 1          */
@tiny volatile u8 ARTICR2 @0x7E;             /* AR Timer Input Capture Register 2          */

@tiny volatile u8 OACSR @0x7F;	/* Operational Amplifier Control/Status register */

#else
  #error"Unsupported Compiler!"	// Compiler Defines not found! 
#endif
#endif

/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/

