/**************** (c) 2005 STMicroelectronics **********************

PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  lib.h
VERSION : 

CREATION DATE : 01.2001

AUTHOR : PPG 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 *****************************************************************************/

/* PUBLIC DECLARATIONS *******************************************************/

#ifndef LIB_H
#define LIB_H
            
/*--------------------------STANDARD TYPE DEFINITION-------------------------*/
typedef unsigned char u8;  		/* unsigned 8 bit type definition */
typedef signed char	  s8;  		/* signed 8 bit type definition */
typedef unsigned int  u16; 		/* unsigned 16 bit type definition */
typedef signed int	  s16; 		/* signed 16 bit type definition */
typedef unsigned long u32; 		/* unsigned 32 bit type definition */
typedef signed long	  s32; 		/* signed 32 bit type definition */

#define U8_MAX		((u8)255)
#define S8_MAX		((s8)127)
#define S8_MIN		((s8)-128)
#define U16_MAX		((u16)65535)
#define S16_MAX     ((s16)32767)
#define S16_MIN		((s16)-32768)
#define U32_MAX		((u32)4294967295)
#define S32_MAX		((s32)2147483647)
#define S32_MIN		((s32)-2147483648)
                                       
typedef union {				/* unsigned 16 bit type for 8 & 16 */
          u16 w_form;			/* bit accesses: 16> var.w_form    */
          struct {			/* 8> var.b_form.high/low          */
                  u8 high, low;
          } b_form;
  } TwoBytes;

typedef u8 BOOL;

/*--------------------------STANDARD CONSTANT DEFINITION---------------------*/
#define  FALSE               ((u8)0x00)
#define  TRUE                (!(FALSE))


/*--------------------------STANDARD MACRO DEFINITION------------------------*/
#define Dim(x) (sizeof(x) / sizeof(x[0])) /*Nbr of elements in array x[]*/
#define ABS(x) (x) > 0 ? (x) : -(x)			/* Absolute value of expression */

/*--------------------------------BIT ACCESSES-------------------------------*/
#define SetBit(VAR,Place)         ( VAR |= (1<<Place) )

#define ClrBit(VAR,Place)         ( VAR &= ((1<<Place)^255) )
#define AffBit(VAR,Place,Value)   ((Value) ? \
                                   (VAR |= (1<<Place)) : \
                                   (VAR &= ((1<<Place)^255)))
#define MskBit(Dest,Msk,Src)      ( Dest = (Msk & Src) | ((~Msk) & Dest) )

#define ValBit(VAR,Place)         (VAR & (1<<Place))   

#define AREA 0x00     /* The area of bits begins at address 0x00. */                   

#define BitClr(BIT)  ( *((unsigned char *) (u8)(AREA+BIT/8)) &= (u8)(~(1<<(7-BIT%8))) )
#define BitSet(BIT)  ( *((unsigned char *) (u8)(AREA+BIT/8)) |=   (u8)(1<<(7-BIT%8))  )
#define BitVal(BIT)  ( *((unsigned char *) (u8)(AREA+BIT/8)) & (u8)(1<<(7-BIT%8)) ) 


/*------------------------------- ST7 SPECIFICS -----------------------------*/
#ifdef __HIWARE__
 #define EnableInterrupts()		{__asm RIM;}
 #define DisableInterrupts()	{__asm SIM;}
 #define Nop()					{__asm NOP;}
 #define Trap()					{__asm TRAP;}
 #define	 Wfi()					{__asm WFI;}
#else
 #ifdef __CSMC__
  #define EnableInterrupts()	{_asm ("RIM");}
  #define DisableInterrupts()	{_asm ("SIM");}
  #define Nop()					{_asm ("NOP");}
  #define Trap()				{_asm ("TRAP");}
  #define Wfi()					{_asm ("WFI");}
 #else
  #error"Unsupported Compiler!"	// Compiler Defines not found! 
 #endif
#endif   

#endif
/*** (c) 2005 STMicroelectronics ****************** END OF FILE ***/
