/**************** (c) 2005 STMicroelectronics **********************

PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  ports.h
LIBRARY VERSION  :  2.0

CREATION DATE : 07.2003 
AUTHOR :      Florent COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :  I/O line control routine prototypes

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/

#ifndef PORTS7_H
#define PORTS7_H

/*----------------------------- Exported functions --------------------------*/

void PORTS_Init(void);

void PORTS_RedLedOn(void);
void PORTS_RedLedOff(void);
void PORTS_RedLedToggle(void);

void PORTS_GreenLedOn(void);
void PORTS_GreenLedOff(void);
void PORTS_GreenLedToggle(void);

void PORTS_RedGreenLedToggle(void);

void PORTS_BothLedOff(void);

BOOL key_scan(void);
void Flash_Red_Led(void);
void Flash_Green_Led(void);
void Flash_Both_Led(void); 
void toggle_PA1(void);


/*----------------------------- Exported constants --------------------------*/

#define  _1CYCLE	((u8)1) /* Useful for Button reading function */
#define  _3CYCLES	((u8)3)
#define  _5CYCLES	((u8)5)
#define  _10CYCLES	((u8)10)
#define  _255CYCLES	((u8)255)

/*----------------------------- Exported variable --------------------------*/

extern u8 Flag_port;
#define RedLedFlash		0x01
#define GreenLedFlash		0x02 
#define BothLedFlash		0x03


#endif
/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/

