/**************** (c) 2005  STMicroelectronics ********************************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  wwdg.c
LIBRARY VERSION  :  2.0

CREATION DATE :    08.2003

AUTHOR :	V. Onde / Microcontroller Division Applications
			Consumer & Micro Group

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Window Watchdog control routines
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/

#include "lib.h"		/* General purpose typedefs and macros */
#include "ST7MC_hr.h"
#include "wwdg.h"		/* Public Window watchdog function prototypes */


#define WDG_TIMEOUT		80		// 80 ms timeout


volatile u8 Timer_WDG;


BOOL WWD_Init(void)
{
	//	if LVD or WWD reset, wait for user's reset (to be discussed)
	// if (SICSR & (LVDRF+WDRF) return(FALSE);
	WWDGCR = WDGA + 0x7F;	// Starts the Window watchdog and load it to its max value
	WWDGWR	= 0x5B;				// Refresh window is between 72 and 128ms (100ms+/-28ms)
	Timer_WDG = WDG_TIMEOUT;
	return(TRUE);
}


void WWD_Refresh(void)
{
	WWDGCR = WDGA + 0x7F;	// Reload Window watchdog with max value
	Timer_WDG = WDG_TIMEOUT;
}

  
BOOL Chk_Timer_WDG_Elapsed(void)
{
if (Timer_WDG == 0) return(TRUE);
else return(FALSE);
}


/*** (c) 2005  STMicroelectronics **************************** END OF FILE ***/