/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : BLAC-DC Software Sensor Library
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  MTC_Settings_Sensor.h

CREATION DATE :    7/5/2005  15:32

AUTHOR :  File generated by the AK-ST7FMC Rev 2 Control Panel

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Software settings for PM_BLAC-DC motor control
                
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/


#include "lib.h" 


#define MTC_CLOCK		((u32)16000000) 	// Resolution: 1Hz     

#define mem_MPCR	 	((u8)0)  // Selection of PWM Mode(standard), type(Edge-aligned) and prescaler setting for 12 Bits timer

#define mem_MCPOL	 	((u8)64) // Setting of PWM frequency on 12Bits Timer Low Register
#define mem_MCPOH	 	((u8)6) // Setting of PWM frequency on 12Bits Timer High Register

#define mem_MCPVL      		((u8)136) // Setting of PWM duty cycle use for current limitation in voltage mode Low Register
#define mem_MCPVH      		((u8)8) // Setting of PWM duty cycle use for current limitation in voltage mode High Register

#define mem_MCRA    		((u8)40) // Setting of MCRA register for polarization type, detection mode, filter,... 
#define mem_MCRC		((u8)64) // Setting of MCRC register for sampling and voltage reference

#define mem_MPRSR       	((u8)80) // Setting of PWM frequency used in current mode
#define mem_MDTG        	((u8)31) // Selection of Dead time
#define mem_MCONF       	((u8)2) // Selection of delay before sampling and Peripheral frequency (4MHz with 16Mhz input frequency)
#define mem_MCFR        	((u8)1) // Set filter of current feedback 
#define mem_MZFR        	((u8)0) // Set filter of Z event detection
#define mem_MSCR        	((u8)0) // Set sampling frequency to count D & Z events
#define Freq_Min	 	((u16)0) // Setting of min frequency in closed loop mode
#define Freq_Max	 	((u16)0) // Setting of max frequency in closed loop mode
#define Pole_Pair_Num	 	((u8)2) // number of pair poles

#define Brake_Duty	 	((u16)0) // Duty cycle in Break mode
#define Brake_Time	 	((u16)0) // Time, Break mode

#define Max_Duty	 	((u16)496)   // Max duty cycle allowed (Voltage mode, closed loop)


// Value of MCRB for each of the six steps in Clock Wise(CW) Direction
// Defines the expected Bemf edge, Demag type and PWM behaviour between events
#define mem_MCRB1         ((u8)64)
#define mem_MCRB2         ((u8)64)
#define mem_MCRB3         ((u8)64)
#define mem_MCRB4         ((u8)0)
#define mem_MCRB5         ((u8)0)
#define mem_MCRB6         ((u8)0)

// Value of MCRB for each of the six steps in Counter Clock Wise(CCW)Direction
// Defines the expected Bemf edge, Demag type and PWM behaviour between events
#define mem_CCW_MCRB1         ((u8)0)
#define mem_CCW_MCRB2         ((u8)0)
#define mem_CCW_MCRB3         ((u8)64)
#define mem_CCW_MCRB4         ((u8)64)
#define mem_CCW_MCRB5         ((u8)64)
#define mem_CCW_MCRB6         ((u8)0) 

#define Rotor_Direction     ((u8)128) 

//Setting of MPOL register depending of IGBT-MOSFET Drivers used
#define L6386_POLARITY	((u8)0x3F)		/* Positive logic for L6386D drivers: PWM low state = Switch OFF */
#define NEGATIVE_POLARITY	((u8)0x00)	/* Negative logic level: PWM low state = Switch ON */
	
#define DRIVERS_POLARITY ((u8)63)



/*** (c) 2004 STMicroelectronics ****************** END OF FILE **************/



