/*****************************************************
      start07.c - ST7 startup code
 ----------------------------------------------------
   Copyright (c) HIWARE AG, Basel, Switzerland
               All rights reserved               
 *****************************************************/
 
#include <hidef.h>
#include <start07.h>

#ifndef __cplusplus
#if defined(__SMALL__) || defined(__LARGE__)
#define USE_HLI
#endif
#endif

#pragma MESSAGE DISABLE C17302

#pragma DATA_SEG SHORT _ZEROPAGE

extern int _SEX;

#pragma DATA_SEG __FAR_SEG _STARTUP

_startupDesc _startupData;

#pragma DATA_SEG DEFAULT

#ifndef USE_HLI
static void Init (void)
  /**** Zero out global variables */
{
  _RangePtr p                 = _startupData.pZeroOut;
  unsigned int n, nofZeroOuts = _startupData.nofZeroOuts;
  char *q;
  
  while (nofZeroOuts) {
    n = p->size;
    q = p->beg;
    do {
      *q = '\0';
      q++;
      n--;
    } while (n != 0);
    p++;
    nofZeroOuts--;
  } /* end while */;
} /* end Init */

static void Copy (void)
  /**** Copy global initialization data */
{
  _CopyPtr  p = _startupData.toCopyDownBeg;
  int       n = p->size;
  char *q;

  while (n) {
    q = p->dest;
    p++;
    do {
      *q = *((char *far)p);
      q++; 
      p = (_CopyPtr)((char *far)p + 1);
    } while (--n);
    n = p->size;
  } /* end while */;
} /* end Copy */
#endif

#ifdef __cplusplus
  extern "C"
#endif

#pragma CODE_SEG __NEAR_SEG NON_BANKED


void _Startup (void)
  /**** Entry point of application */
{

#ifdef __ELF_OBJECT_FILE_FORMAT__
  DisableInterrupts;  /* in HIWARE format, this is done in the prestart code */
#endif
  {
#ifdef USE_HLI

#ifdef __SMALL__
  char *far p;
   
  asm {  
  _start_0:
                  ; reset stack pointer
                  RSP
                  ; zero out global variables
                  
                  LD    A,_startupData.pZeroOut:1
                  LD    p:1,A
                  LD    A,_startupData.pZeroOut:0
                  LD    p,A
                  LD    Y,_startupData.nofZeroOuts:1
                  JRT    Zero_out_5
  Zero_out_0:
                              ; n = p->size;
                  LD    X,#3
                  LD    A,([p.w],X)
                  DEC   X
                              ; q = p->beg;
                  DEC   X
                  LD    X,([p.w],X)
  Zero_out_1:                 
                              ; *q = '\0';
                  CLR   (0,X)
                              ; q++;
                  INC   X
                              ; n--
                  DEC   A
                              ; while(n != 0)
                  JRNE  Zero_out_1
                              ; p++;
                  LD    A,p:1
                  ADD   A,#4
                  LD    p:1,A
                  JRUGE Zero_out_3
                  INC   p
  Zero_out_3:                     
                              ; nofZeroOuts--;       
                  DEC   Y
  Zero_out_5:          
                              ; while(nofZeroOuts != 0)
                  TNZ   Y
                  JRNE  Zero_out_0



                  ; copy down
                  LD    A,_startupData.toCopyDownBeg:1
                  LD    p:1,A
                  LD    A,_startupData.toCopyDownBeg:0
                  LD    p,A
                  JRT   Copy_3
  Copy_0:                 
                              ; q = p->dest;
                  LD    X,#3
                  LD    X,([p.w],X)
                              ; p++;
                  LD    A,p:1
                  ADD   A,#4
                  LD    p:1,A
                  JRUGE Copy_1
                  INC   p                  
  Copy_1:                
                              ; *q = *((char *far)p);
                  LD    A,[p.w]
                  LD    (0,X),A
                              ; q++; 
                  INC   X
                              ; p = (_CopyPtr)((char *far)p + 1);
                  INC   p:1
                  JRNE  Copy_2
                  INC   p
  Copy_2:                
                              ; while (--n);
                  DEC   Y
                  JRNE  Copy_1
  Copy_3:                
                              ; n = p->size;
                  LD    Y,#1
                  LD    Y,([p.w],Y)
                  JRNE  Copy_0
  }       
#else  /* large */
  char *p, *q;
  int n, nofZeroOuts;
  
  asm {  
  _start_0:
                  ; reset stack pointer
                  RSP
                  ; zero out global variables                  
                  LD    A,_startupData.pZeroOut:1
                  LD    p:1,A
                  LD    A,_startupData.pZeroOut:0
                  LD    p,A
                  LD    A,_startupData.nofZeroOuts:0
                  LD    nofZeroOuts,A
                  LD    A,_startupData.nofZeroOuts:1
                  JRT   Zero_out_6
  Zero_out_0:
                               ; n = p->size;
                  LD    X,#3
                  LD    A,([p.w],X)
                  LD    n:1,A
                  DEC   X
                  LD    A,([p.w],X)
                  LD    n,A
                               ; q = p->beg;
                  DEC   X
                  LD    A,([p.w],X)
                  LD    q:1,A
                  LD    A,[p.w]
                  LD    q,A
  Zero_out_1:                  
                               ; *q = '\0';
                  CLR   A
                  LD    [q.w],A
                               ; q++;
                  INC   q:1
                  JRNE  Zero_out_2
                  INC   q
  Zero_out_2:     
                               ; while(n--)             
                  LD    A,n:1
                  JRNE  Zero_out_3
                  DEC   n
  Zero_out_3:                
                  DEC   A
                  LD    n:1,A
                  OR    A,n
                  JRNE  Zero_out_1
                               ; p++;
                  LD    A,p:1
                  ADD   A,#4
                  LD    p:1,A
                  JRUGE Zero_out_4
                  INC   p
  Zero_out_4:                
                               ; nofZeroOuts--;
                  LD    A,nofZeroOuts:1
                  JRNE  Zero_out_5
                  DEC   nofZeroOuts
  Zero_out_5:                
                  DEC   A
  Zero_out_6:                
                  LD    nofZeroOuts:1,A
                  OR    A,nofZeroOuts
                  JRNE  Zero_out_0

                  ; Copy down
                  LD    A,_startupData.toCopyDownBeg:1
                  LD    p:1,A
                  LD    A,_startupData.toCopyDownBeg:0
                  LD    p,A
                  JRT   Copy_5
  Copy_0:                
                               ; q = p->dest;
                  LD    X,#3
                  LD    A,([p.w],X)
                  LD    q:1,A
                  DEC   X
                  LD    A,([p.w],X)
                  LD    q,A
                               ; p++;
                  LD    A,p:1
                  ADD   A,#4
                  LD    p:1,A
                  JRUGE Copy_1
                  INC   p
  Copy_1:                  
                               ; *q = *((char *far)p);
                  LD    A,[p.w]
                  LD    [q.w],A
                               ; q++; 
                  INC   q:1
                  JRNE  Copy_2
                  INC   q
  Copy_2:                  
                               ; p = (_CopyPtr)((char *far)p + 1);
                  INC   p:1
                  JRNE  Copy_3
                  INC   p
  Copy_3:                  
                               ; while (--n);
                  TNZ   n:1
                  JRNE  Copy_4
                  DEC   n
  Copy_4:                
                  DEC   n:1
                  LD    A,n:1
                  OR    A,n
                  JRNE  Copy_1
  Copy_5:                  
                               ; n = p->size;
                  LD    X,#1
                  LD    A,([p.w],X)
                  LD    n:1,A
                  LD    A,[p.w]
                  LD    n,A
                  OR    A,n:1
                  JRNE  Copy_0                  
  }
#endif                  
  _startupData.main();
  asm JRA _start_0;

#else  /* C */

#ifdef __cplusplus
  PROC *far funp;
#endif

  for (;;) {
    asm {
                  ; Initialize stack?
                  /* we must always initialize SP
                  LD    A, _startupData.flags:1
                  JREQ  InitStuff
                  */
                  RSP
      InitStuff:
    } /* end asm */;

    Init ();
    Copy ();
#ifdef __cplusplus  // call global constructors
#ifdef __ELF_OBJECT_FILE_FORMAT__
    {
      int i = _startupData.nofInitBodies - 1;
      while ( i >= 0) {
        (&_startupData.initBodies->initFunc)[i]();  /* call C++ constructors */
        i--;
      }
    }
#else
    for(funp = _startupData.mInits; *funp != NULL; funp++) {
      (*funp)();
    }
#endif
#endif    
    _startupData.main();
  } /* end for */;
#endif  
  }
} /* end _Startup */

