/**************** (c) 2005  STMicroelectronics **********************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  main.c
LIBRARY VERSION :  2.0

CREATION DATE :    08.2003
AUTHOR :      F.COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main Routine
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  

#include "version.h"
#include "lib.h"
#include "mtc.h"
#include "ST7MC_hr.h"
#include "ports.h"
#include "opamp.h"
#include "timer.h"
#include "it_ST7MC.h"  
#include "regul.h"
#include "adc.h"
#include "LinSCI.h"
#include "misc.h"   
#include "wwdg.h"
#include "spi.h"
#include "MTC_Settings_Sensor.h"

 
#define CRC	0x54	// just declare a data byte to be written in EEPROM  

 
typedef enum 
{
IDLE, RUN, STOP, BRAKE, FAULT
} SystStatus_t;

static SystStatus_t State;



void main(void)
{   
//	while ( !WWD_Init() );

	/*** !! Check carrefully whether it is needed to change the interrupt priorities. For high electrical       !! ***/
	/*** !! frequency applications (eg 1.5Khz or more for example), it is mandatory to set the Commutation IT   !! ***/
	/*** !! event at the highest level to avoid synchronization loss (done by default in the following routine) !! ***/
	//ST7_IntPrioritySetUp();
        
   	State = IDLE;
    	Power_Motor_Status = 0;

	SCI_Config();
	PORTS_Init();
 	TIMB_Config();
 	SPI_Init();

	MTC_InitPeripheral();	// Initialize peripheral for Sensor BLDC drive
	EnableInterrupts();

	Flash_Both_Led();
	PORTS_RedLedOn();
	
//	Send_EEPROM(0,CRC);      	// write CRC at adress 0x00
//	while(Chk_WP_Bit() == TRUE);    // wait for end of writing process (max 10 ms)
//	Send_EEPROM(1,102);             // write 102 at adress 0x01
	

	while(1)    // main loop
	{
//	if (Chk_Timer_WDG_Elapsed() == TRUE)	 WWD_Refresh();
    	Chk_Power_Motor_Status();
	
	if ((u8)(GetMotorStatus() & FAULT_MSK) != 0) State = FAULT;  // START_UP_FAILED or MOTOR_STALLED 
								 // or HARD_FAILURE or EMERGENCY_STOP?

	switch (State)
			{
			case IDLE:
        		    	if (timer_10ms == 0) PORTS_RedLedOn();  // red LED back to normal after
		    	                                                // overvoltage, overtemperature detection
				if (key_scan() == TRUE)                 // check SW1 button
					{
					MTC_StartMotor();
					State = RUN;
					}
				break;
			
			case RUN:             
				if (SCI_Tx_Timer == 0)
					{ 
			 		#if (FEEDBACK_TYPE == CLOSED_LOOP)
					Lin_Tx_Buffer[0] = Rising_bemf;
					Lin_Tx_Buffer[1] = Falling_bemf;
					Lin_Tx_Buffer[2] = Ki;    
					Lin_Tx_Buffer[3] = Kp;
					Lin_Tx_Buffer[4] = (u8)(Freq_Motor>>8); // send MSB
					Lin_Tx_Buffer[5] = (u8)(Freq_Motor);    // send LSB
					//Lin_Tx_Buffer[6] = Read_EEPROM(0);
					Lin_Tx_Buffer[6] = 0;
					#else
					Lin_Tx_Buffer[0] = Rising_bemf;
					Lin_Tx_Buffer[1] = Falling_bemf;
					Lin_Tx_Buffer[2] = (u8)(Period_To_Frequency()>>8); // send MSB
					Lin_Tx_Buffer[3] = (u8)(Period_To_Frequency());    // send LSB
					Lin_Tx_Buffer[4] = 0;
					//Lin_Tx_Buffer[5] = Read_EEPROM(0);
					Lin_Tx_Buffer[5] = 0;
					Lin_Tx_Buffer[6] = 0;
					#endif		
					
					SCI_Send_Data();
					SCI_Tx_Timer = 100;    // 1 sec delay
					}

				if (ValBit(Flag_MTC,SAMP_EVT))     // update PWM?
					{
					u32 temp;
					
					ClrBit(Flag_MTC,SAMP_EVT);
					#if (FEEDBACK_TYPE == CLOSED_LOOP)
				 		temp = (u8)(Get_RV1());      // target_freq = (Get_RV1 * (Freq_Max-Freq_Min))/256 + Freq_Min
				 		temp *= (u32)(Freq_Max-Freq_Min);
 						temp >>= 8;
 						temp += Freq_Min;
            Set_Target_Electrical_Frequency((u16)(temp));
 					#elif (FEEDBACK_TYPE == OPEN_LOOP)					
						Falling_bemf = (u8)(Get_RV3());   // read RV3 & set falling Bemf coefficient accordingly
						Rising_bemf = (u8)(Get_RV2());    // read RV2 & set rising Bemf coefficient accordingly

						temp = (u8)(Get_RV1());                                                                      
						
						#if (DRIVING_MODE == VOLTAGE_MODE)
 					 	temp *= (u32)(Max_Duty);          // temp =  (Max_Duty * Get_RV1)/256
						#elif (DRIVING_MODE == CURRENT_MODE)
						temp *= (u32)(PWM_FREQUENCY);	  // temp =  (PWM_FREQUENCY * Get_RV1)/256	
 					 	#else
  							#error"Wrong Driving Mode Parameter!"	
						#endif
						
						temp >>= 8;
						Set_Duty((u16)(temp));
						Lin_Tx_Buffer[2] = (u8)(temp>>8); // send MSB
						Lin_Tx_Buffer[3] = (u8)(temp);    // send LSB

					#else
  						#error"Wrong Feedback Type Parameter!"	
					#endif
					}
    		   	    	Chk_Motor_Stalled();    
   	       	    		if (timer_10ms == 0) PORTS_GreenLedOn();   
				if (key_scan() == TRUE) State = BRAKE;  // check SW1 button
				break;

			case BRAKE: 
     	    			if (active_brake(Brake_Duty,Brake_Time) == TRUE) State = STOP;
				break;

			case STOP:
                    		MTC_StopMotor();
	    	    		PORTS_RedLedOn();
				State = IDLE;
				break;

			case FAULT:
		        default:
			        MTC_StopMotor();
	    	    		PORTS_RedLedOn();
				if ((u8)(GetMotorStatus() & FAULT_MSK) == 0) State = IDLE;
				break;
			}

    }
} // main loop


/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/

