/**************** (c) 2005  STMicroelectronics **********************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  opamp.c
LIBRARY VERSION :  2.0

CREATION DATE :    08.2003
AUTHOR :      F.COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Opamp routines              

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#include "lib.h"
#include "ST7MC_hr.h"
#include "opamp.h"
#include "misc.h"


void OPAMP_InitOffset(u8 Gain)
{   

	OACSR |= OAON;	// Power-up the Op-Amp 
    Wait1ms();    // Wait for OPAMP to wake up
	
	OACSR |= OAON + OFFCMP + AVGCMP;
	while(!(OACSR & CMPOVR));		// Wait compensation completion

	if	(Gain == LOW_GAIN)	OACSR &= ((u8) ~HIGHGAIN);		// Close Loop Gain up to 20dB
	else	OACSR |= HIGHGAIN;				// Close Loop Gain More than 20dB

}	
    

/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/
