/**************** (c) 2005 STMicroelectronics **********************

PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  ports.c
LIBRARY VERSION :  2.0

CREATION DATE : 07.2003 
AUTHOR :      F.COSTE	/  Microcontroller Application Lab  /  ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   I/O routines 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :


******************************************************************************/

#include "lib.h"
#include "ST7MC_hr.h"
#include "ports.h"
#include "it_ST7MC.h"
#include "Timer.h"



#define  BUTTON			0
#define  BUTTON_PORT	PCDR

#define		Led		((u8)0x80)	// PB7
#define		PB7		7

/* Private Variables -------------------------------------------------------- */ 

static u8 key_state;      // status of key panel
#define KEY_IDLE		0
#define KEY_IDLE_NEXT	1
#define KEY_PUSHED		2

/* Public Variables -------------------------------------------------------- */ 
 
u8 Flag_port;      // flag used for LED on/off reference


/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the ports

COMMENTS     :
-----------------------------------------------------------------------------*/
void PORTS_Init(void)           // Setting for 56 pins case of Starter kit
{

	PADDR    = 0x52;       	//PA1, PA4, PA6, push-pull Output
	PAOR	 = 0x52;       	//PA5, PA3 floating Input
				            //PA7, PA2, PA0 not connected set in floating Input

  	PBDDR    = 0x01; 	//PB7 to PB1 floating Input
	PBOR     = 0x01;        //PB0 push-pull Output 
	PBDR     = 0x01;        //PB0 Output high

	PCDDR    = 0x00; 	    //PC7 to PC0 floating Input
	PCOR     = 0x00;      

	PDDDR    = 0x00; 	    //PD7 to PD0 floating Input
	PDOR     = 0x00;
    
	PEDDR    = 0x0F;        //PE7 to PE4 floating Input            
	PEOR     = 0x0F;        //PE3 to PE0 push-pull Output

	PFDDR    = 0x01;        //PF7 to PF1 floating Input           
	PFOR     = 0x01;        //PF0 push-pull Output   

	Flag_port=key_state=0;
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_RedLedOn; PORTS_RedLedOff; PORTS_RedLedToggle
					PORTS_GreenLedOn; PORTS_GreenLedOff; PORTS_GreenLedToggle
					PORTS_RedGreenLedToggle; PORTS_BothLedOff
INPUT/OUTPUT : None

DESCRIPTION  : Set/Reset/Toggle Red or Green or Both LED

COMMENTS     :
-----------------------------------------------------------------------------*/
void PORTS_RedLedOn(void)
{
	Flag_port &= (u8)~BothLedFlash;          // stop flashing LED if previously selected

	PBDDR |= Led; 				//PB7 push-pull Output
	PBOR  |= Led;        
	PBDR  |= Led;				// ((u8)0x80)
}

void PORTS_RedLedOff(void)
{
	Flag_port &= (u8)~BothLedFlash;          // stop flashing LED if previously selected

	PBOR  &= (u8)~Led;      // touch PBOR first
	PBDDR &= (u8)~Led; 		// then PBDDR -> PB7 Floating Input
}

void PORTS_RedLedToggle(void)
{
if (ValBit(PBDDR,PB7))    // push-pull config?
		{
		PBOR  &= (u8)~Led;
		PBDDR &= (u8)~Led; 				//Toggle PB7 direction (Floating Input or push-pull Output)
    	}
else
		{
		PBDDR |= Led; 				//Toggle PB7 direction (Floating Input or push-pull Output)
		PBOR  |= Led;
		PBDR  |= Led;				// ((u8)0x80)
		}
}

void PORTS_GreenLedOn(void)
{
	Flag_port &= (u8)~BothLedFlash;          // stop flashing LED if previously selected

	PBDDR |= Led; 				//PB7 push-pull Output
	PBOR  |= Led;        
	PBDR 	&= (u8)~Led;		// ((u8)0x00)
}

void PORTS_GreenLedOff(void)
{
	Flag_port &= (u8)~BothLedFlash;          // stop flashing LED if previously selected
       
	PBOR  &= (u8)~Led;      // touch first PBOR
	PBDDR &= (u8)~Led; 		// then PBDDR -> PB7 Floating Input
}

void PORTS_GreenLedToggle(void)
{
	if (ValBit(PBDDR,PB7))          // output config?
		{
		PBOR  &= (u8)~Led;
		PBDDR &= (u8)~Led; 				//Toggle PB7 direction (Floating Input or push-pull Output)
    	}
	else
		{
		PBDDR |= Led; 				//Toggle PB7 direction (Floating Input or push-pull Output)
		PBOR  |= Led;
		PBDR  &= (u8)~Led;		// ((u8)0x00)
		}
}

void PORTS_RedGreenLedToggle(void)
{
if (!ValBit(PBDDR,PB7))
	{
	PBDDR |= Led; 				//Toggle PB7 direction (Floating Input or push-pull Output)
	PBOR  |= Led; 
	}
	PBDR ^= Led;
}	

void PORTS_BothLedOff(void)
{
	Flag_port &= (u8)~BothLedFlash;          // stop flashing LED if previously selected

	PBDDR &= (u8)~Led; 		//PB7 Floating Input
	PBOR  &= (u8)~Led;
}


void Flash_Red_Led(void)
{
	Flag_port &= (u8)~BothLedFlash;          // flash red LED 
	Flag_port |= RedLedFlash;
}

void Flash_Green_Led(void)
{
	Flag_port &= (u8)~BothLedFlash;          // flash green LED
	Flag_port |= GreenLedFlash;
}

void Flash_Both_Led(void)
{
Flag_port |= BothLedFlash;                  // flah red & green LED
}


/*-----------------------------------------------------------------------------
ROUTINE Name :  key_scan
Description :  return TRUE if button is read and released
-----------------------------------------------------------------------------*/ 
BOOL key_scan(void)
{
if (!ValBit(BUTTON_PORT,BUTTON)) // Button released (Pull-up resistor)
	{
  	switch(key_state)
		{
		case KEY_PUSHED:
               	if (DebounceButton == 0) 
		    		{
		    		key_state = KEY_IDLE_NEXT;
		    		return (TRUE);
		    		}
				else return (FALSE);
				break;
		case KEY_IDLE:
				DebounceButton = 10;	// 100ms debounce time
	            key_state = KEY_PUSHED;
				return(FALSE);
				break;
        case KEY_IDLE_NEXT:
		default:
				return(FALSE);
				break;
		}
	}
else key_state = KEY_IDLE;
return(FALSE);
}


void toggle_PA1(void)   // for debugging purpose
{
if (PADR & 0x02) PADR &= (u8)(~0x02);
else	PADR |= 0x02;
}

/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/














