/**************** (c) 2005  STMicroelectronics **********************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  spi.c
LIBRARY VERSION :  2.0

CREATION DATE :    08.2003
AUTHOR :      Florent COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   SPI routines  
            
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#include "version.h"
#include "lib.h"   // Predifined libraries working at bit level    
#include "ST7MC_hr.h"      
#include "spi.h"

                    
#define Port_B		0x03
#define Select        (Port_B * 8 + 7 - 0)   


/* EEPROM instructions */
#define WREN	0x06
#define WRDI	0x04
#define RDSR 	0x05
#define WRSR	0x01
#define READ	0x03
#define WRITE	0x02

                       

/*-----------------------------------------------------------------------------
ROUTINE NAME : SPI_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the SPI peripheral

COMMENTS     :
-----------------------------------------------------------------------------*/

void SPI_Init(void)
{
SPICR = 0x20;    // cpol 0
  		 // cpha 0
   		 // fcpu/4

SPICSR = 0x03;  // ssm	ssi  

SetBit(SPICR,4);  // master mode
}            

 
     

/*-----------------------------------------------------------------------------
ROUTINE NAME : Chk_WP_Bit
INPUT/OUTPUT : None/Boolean

DESCRIPTION  : Return 'TRUE' if write is still in progress in the EEPROM (M95040)

COMMENTS     :
-----------------------------------------------------------------------------*/

BOOL Chk_WP_Bit(void)
{
SetBit(SPICR,6);  // spi enable

BitClr(Select);
SPIDR = RDSR;
while(!ValBit(SPICSR,7));
SPIDR = RDSR;
while(!ValBit(SPICSR,7));
BitSet(Select);
ClrBit(SPICR,6);  // spi disable

if (ValBit(SPIDR,0)) return(TRUE);
else return(FALSE);
}



     
/*-----------------------------------------------------------------------------
ROUTINE NAME : Read_EEPROM
INPUT/OUTPUT : u8 (adress) / u8 (data)

DESCRIPTION  : Return data located at the adress specified

COMMENTS     :
-----------------------------------------------------------------------------*/
 
u8 Read_EEPROM(u8 add)
{
u8 data;

SetBit(SPICR,6);  // spi enable

BitClr(Select);
SPIDR = READ;
while(!ValBit(SPICSR,7));
SPIDR = add;
while(!ValBit(SPICSR,7));
SPIDR = add;
while(!ValBit(SPICSR,7));
data = SPIDR;
BitSet(Select);
ClrBit(SPICR,6);  // spi disable

return (data);
}
 
                                
 
 
/*-----------------------------------------------------------------------------
ROUTINE NAME : Send_EEPROM
INPUT/OUTPUT : u8,u8 (adress,data) / None 

DESCRIPTION  : Send data byte to the adress specified

COMMENTS     :
-----------------------------------------------------------------------------*/

void Send_EEPROM(u8 add, u8 data)
{
SetBit(SPICR,6);  // spi enable

BitClr(Select);
SPIDR = WREN;
while(!ValBit(SPICSR,7));
SPIDR;  
BitSet(Select);

Nop();

BitClr(Select);
SPIDR = WRITE;
while(!ValBit(SPICSR,7));
SPIDR = add;
while(!ValBit(SPICSR,7));
SPIDR = data;
while(!ValBit(SPICSR,7));
SPIDR;
BitSet(Select);

ClrBit(SPICR,6);  // spi disable
}
  
  
/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/
  