/**************** (c) 2005 STMicroelectronics **********************

PROJECT  : ST7MC demokit
COMPILER : COSMIC

MODULE  :  vector.c   --  not used with METROWERKS & STVD7 2.5.x  (see .prm file)		     
LIBRARY VERSION :  2.0

CREATION DATE :    08.2003
AUTHOR :      Florent COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : File contains Prototypes of Interrupt Service Routines

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/


// Interrupt service routines prototypes

extern void dummy_rt(void);
extern void ART_Interrupt (void);
extern void AVD_Interrupt (void);
extern void SCI_IT_Routine (void);
extern void TIMB_Interrupt (void);
extern void TIMA_Interrupt (void);
extern void SPI_Interrupt (void);
extern void MTC_C_D_IT (void);
extern void MTC_R_Z_IT (void);
extern void MTC_U_CL_SO_IT (void);
extern void PORTS_2_Interrupt (void);
extern void PORTS_1_Interrupt (void);
extern void PORTS_0_Interrupt (void);
extern void MCC_Interrupt (void);
extern void MCES_SE_IT (void);
extern void TRAP_Interrupt (void);

#if defined ( __HIWARE__)	/* test for HIWARE Compiler */
extern void _Startup();		/* startup routine */  
#pragma CONST_SEG .myVectorTable

#elif defined ( __CSMC__ )			/* test for Cosmic Compiler */
extern void _stext(void);

#endif

// Interrupt service routines vector table (unused vectors point to Dummy int (iret)

volatile void (*const _vectab[])() = {
		ART_Interrupt,		    // ART_Interrupt, 
		AVD_Interrupt,			// AVD_Interrupt,
		SCI_IT_Routine,			// SCI_IT_Routine,
		TIMB_Interrupt,			// TIMB_Interrupt,
		TIMA_Interrupt,			// TIMA_Interrupt,
		SPI_Interrupt,			// SPI_Interrupt,
		MTC_C_D_IT,             // Event C or D
		MTC_R_Z_IT,             // Event R or Z
		MTC_U_CL_SO_IT,         // Event U or Current Loop or Sampling Out
		PORTS_2_Interrupt,		// PORTS_2_Interrupt,
		PORTS_1_Interrupt,		// PORTS_1_Interrupt,
		PORTS_0_Interrupt,		// PORTS_0_Interrupt,
		MCC_Interrupt,			// MCC_Interrupt,
		MCES_SE_IT,
		TRAP_Interrupt,			// TRAP_Interrupt,
#if defined ( __HIWARE__)	/* test for HIWARE Compiler */
		_Startup,		/* Reset Vector */
		};
#pragma DATA_SEG DEFAULT             

#elif defined ( __CSMC__ )			/* test for Cosmic Compiler */
		_stext
	       };
#endif

/*** (c) 2005 STMicroelectronics ****************** END OF FILE ***/

