/**************** (c) 2005  STMicroelectronics **********************

PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  it_ST7MC.c
LIBRARY VERSION  :  2.0

CREATION DATE :    08.2003
AUTHOR :      Florent COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main interrupt service routines

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
                
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/


#include "lib.h"
#include "it_ST7MC.h"
#include "ST7MC_hr.h" 
#include "version.h" 
#include "ports.h"
#include "timer.h"
#include "mtc.h"
#include "regul.h" 
#include "wwdg.h"   
#include "LinSCI.h"


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : dummy_rt
INPUT/OUTPUT : None

DESCRIPTION  : Empty Interrupt Service Routine

COMMENTS     : all the non-connected interrupt vectors are connected to this empty function
-----------------------------------------------------------------------------*/ 
void dummy_rt(void)
{
}

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : TRAP_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Software Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void TRAP_Interrupt(void)
{
}


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : MCC_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Software Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void MCC_Interrupt(void)
{
}


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_0_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_0_Interrupt(void)
{
}


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_1_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_1_Interrupt(void)
{
}


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_2_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_2_Interrupt(void)
{
}


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : SPI_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void SPI_Interrupt(void)
{
}

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : TIMA_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer A Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void TIMA_Interrupt(void)
{
}

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : TIMB_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer B Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void TIMB_Interrupt(void)
{
unsigned int timer;

if (ValBit(TBSR,6))
	{
	timer=TBOC1HR<<8;
	timer+=TBOC1LR;
	timer+= 10000;   // int every 10 ms
	TBOC1HR=(u8)(timer>>8);
	TBOC1LR=(u8)timer;

	if (DebounceButton != 0) DebounceButton--;
	if (timer_10ms != 0) timer_10ms--;
	if (timer_CL_10ms != 0) timer_CL_10ms--;
	if (SCI_Tx_Timer != 0) SCI_Tx_Timer--;
	if (timer_led_10ms != 0) timer_led_10ms--;
	else 
		{	
		switch(Flag_port & 0x03)
				{
				case RedLedFlash:    // bit set? -> flash the red LED!
						PORTS_RedLedToggle();
						timer_led_10ms = 15;  // 150 ms delay before next toggling event
				        break;
		        case GreenLedFlash:    // flash the green LED!
				       	PORTS_GreenLedToggle();
						timer_led_10ms = 40;  // 400 ms delay before next toggling event
		 		        break;           
				case BothLedFlash:    // flash both LED!
						PORTS_RedGreenLedToggle();
						timer_led_10ms = 30;  // 300 ms delay before next toggling event
					break;
				default:
					break;
				}  
		}           
	}                                 
else 
	{
	timer=TBOC2HR<<8;
	timer+=TBOC2LR;
	timer+= 1000;   // int every 1 ms
	TBOC2HR=(u8)(timer>>8);
	TBOC2LR=(u8)timer;

	if (Timer_1ms !=0) Timer_1ms--;
	if (Timer_WDG !=0) Timer_WDG--;
	if (PI_Sampling != 0) PI_Sampling--;
	else      
		{
		SetBit(Flag_MTC,SAMP_EVT);
		PI_Sampling = SAMPLING_TIME;
		}
    }
}

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : SCI_IT_Routine
INPUT/OUTPUT : None

DESCRIPTION  : SCI Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void SCI_IT_Routine(void)
{
if (Tx_Index == LIN_TX_BUFFER_SIZE) ClrBit(SCICR2,TCIE);	// Transmitter interrupt disable
else
	{
	SCISR;
	SCIDR = Lin_Tx_Buffer[Tx_Index];
	}         
Tx_Index++;
}

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : AVD_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Auxiliary Voltage Detector Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void AVD_Interrupt(void)
{
}

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : ART_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : ART Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void ART_Interrupt(void)
{
}



/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/
