/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : BLDC Software Sensorless Library 
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  MTC_Settings_Sensorless.h

CREATION DATE :    7/5/2005  13:22

AUTHOR :  File generated by the AK-ST7FMC Control Panel

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Software settings for PMDC motor control
                
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/


#include "lib.h" 


#define MTC_CLOCK		((u32)16000000) 	// Resolution: 1Hz     

#define mem_MPCR	 	((u8)0)  // Selection of PWM Mode(standard), type(Edge-aligned) and prescaler setting for 12 Bits timer

#define mem_MCPOL	 	((u8)64) // Setting of PWM frequency on 12Bits Timer Low Register
#define mem_MCPOH	 	((u8)6) // Setting of PWM frequency on 12Bits Timer High Register

#define mem_MCPVL      	((u8)0) // Setting of PWM duty cycle use for current limitation in voltage mode Low Register
#define mem_MCPVH      	((u8)0) // Setting of PWM duty cycle use for current limitation in voltage mode High Register

#define mem_MCRA    		((u8)8) // Setting of MCRA register for polarization type, detection mode, filter,... 
#define mem_MCRC		((u8)64) // Setting of MCRC register for sampling and voltage reference

#define mem_MPRSR       	((u8)80) // Setting of PWM frequency used in current mode
#define mem_MDTG        	((u8)31) // Selection of Dead time
#define mem_MCONF       	((u8)2) // Selection of delay before sampling and Peripheral frequency (4MHz with 16Mhz input frequency)
#define mem_MCFR        	((u8)1) // Set filter of current feedback 
#define mem_MZFR        	((u8)0) // Set filter of Z event detection
#define mem_MSCR        	((u8)0) // Set sampling frequency to count D & Z events
#define Freq_Min	 	((u16)0) // Setting of min frequency in closed loop mode
#define Freq_Max	 	((u16)0) // Setting of max frequency in closed loop mode
#define Pole_Pair_Num	 	((u8)2) // number of pair poles

#define Brake_Duty	 	((u16)0) // Duty cycle in Break mode
#define Brake_Time	 	((u16)0) // Time, Break mode

#define Max_Duty	 	((u16)495)   // Max duty cycle allowed (Voltage mode, closed loop)

#define Rotor_Direction     ((u8)128)

// Value of MCRB for each of the six steps in sensorless mode CW Direction
// Defines the expected Bemf edge, Demag type and PWM behaviour between events
#define mem_MCRB1         ((u8)32)      // HDM, falling BEMF
#define mem_MCRB2         ((u8)112)     // HDM & SDM, rising BEMF
#define mem_MCRB3         ((u8)32)      // HDM, falling BEMF
#define mem_MCRB4         ((u8)112)     // HDM & SDM, rising BEMF
#define mem_MCRB5         ((u8)32)      // HDM, falling BEMF
#define mem_MCRB6         ((u8)112)     // HDM & SDM, rising BEMF


// Value of MCRB for each of the six steps in sensorless mode CCW Direction
// Defines the expected Bemf edge, Demag type and PWM behaviour between events
#define mem_CCW_MCRB1         ((u8)112)     // HDM & SDM, rising BEMF
#define mem_CCW_MCRB2         ((u8)32)      // HDM, falling BEMF
#define mem_CCW_MCRB3         ((u8)112)     // HDM & SDM, rising BEMF
#define mem_CCW_MCRB4         ((u8)32)      // HDM, falling BEMF
#define mem_CCW_MCRB5         ((u8)112)     // HDM & SDM, rising BEMF
#define mem_CCW_MCRB6         ((u8)32)      // HDM, falling BEMF


#define mem_MDFR	 	((u8)0) // Set filter of D event detection
#define bemf_valid     	((u8)2) // Setting of sucessive bemf to pass before autoswitch  
#define bemf_blank      ((u8)2) // Setting of number of step at starting without bemf detection 
#define mem_MPWME       ((u8)32) // Setting of min off-time in sensorless current mode

#define Align_MCOMP		((u8)195) // Setting of MCOMP for alignment timebase 
#define Align_Ratio		((u8)9) // Setting of Ratio for alignment timebase 

#define Align_MCPUL		((u8)0) // Setting of PWM duty cycle during prepositionning in voltage mode Low Register
#define Align_MCPUH    	((u8)0) // Setting of PWM duty cycle during prepositionning in voltage mode High Register

#define Align_MCPVL    	((u8)74) // Increment of PWM duty cycle for current limit during prepositionning in current mode Low Register
#define Align_MCPVH    	((u8)1) // Increment of PWM duty cycle for current limit during prepositionning in current mode High Register

#define ramp_MCPUL		((u8)0) // Setting of PWM duty cycle during acceleration ramp in voltage mode Low Register
#define ramp_MCPUH    	((u8)0) // Setting of PWM duty cycle during acceleration ramp in voltage mode High Register

#define ramp_MCPVL     	((u8)79) // Setting of PWM duty cycle for current limit during ramp-up in current mode Low Register
#define ramp_MCPVH      ((u8)10) // Setting of PWM duty cycle for current limit during ramp-up in current mode High Register

#define Commut_Dem_MCPUL 	((u8)0) // Setting of PWM duty cycle during Demagnetisation in voltage mode Low Register
#define Commut_Dem_MCPUH 	((u8)0) // Setting of PWM duty cycle during Demagnetisation in voltage mode High Register


// Setting of demagnetisation time in running mode for ratio 0
#define Run_Soft_Dem0   ((u8)255)    // Ratio 0
#define Run_Soft_Dem1   ((u8)255)    // Ratio 1
#define Run_Soft_Dem2   ((u8)225)    // Ratio 2
#define Run_Soft_Dem3   ((u8)112)    // Ratio 3
#define Run_Soft_Dem4   ((u8)56)    // Ratio 4
#define Run_Soft_Dem5   ((u8)28)    // Ratio 5
#define Run_Soft_Dem6   ((u8)14)    // Ratio 6
#define Run_Soft_Dem7   ((u8)7)    // Ratio 7
#define Run_Soft_Dem8   ((u8)4)    // Ratio 8
#define Run_Soft_Dem9   ((u8)2)    // Ratio 9
#define Run_Soft_Dem10   ((u8)1)    // Ratio 10
#define Run_Soft_Dem11   ((u8)1)    // Ratio 11
#define Run_Soft_Dem12   ((u8)1)    // Ratio 12
#define Run_Soft_Dem13   ((u8)1)    // Ratio 13
#define Run_Soft_Dem14   ((u8)1)    // Ratio 14
#define Run_Soft_Dem15   ((u8)1)    // Ratio 15


// Acceleration Ramp
#define def_ramp_ratio0          ((u8)10)
#define def_ramp_value0		 ((u8)159)   
#define def_ramp_ratio1          ((u8)9)
#define def_ramp_value1		 ((u8)132)   
#define def_ramp_ratio2          ((u8)8)
#define def_ramp_value2		 ((u8)203)   
#define def_ramp_ratio3          ((u8)8)
#define def_ramp_value3		 ((u8)171)   
#define def_ramp_ratio4          ((u8)8)
#define def_ramp_value4		 ((u8)151)   
#define def_ramp_ratio5          ((u8)8)
#define def_ramp_value5		 ((u8)136)   
#define def_ramp_ratio6          ((u8)7)
#define def_ramp_value6		 ((u8)250)   
#define def_ramp_ratio7          ((u8)7)
#define def_ramp_value7		 ((u8)233)   
#define def_ramp_ratio8          ((u8)7)
#define def_ramp_value8		 ((u8)219)   
#define def_ramp_ratio9          ((u8)7)
#define def_ramp_value9		 ((u8)207)   
#define def_ramp_ratio10         ((u8)7)
#define def_ramp_value10	 ((u8)197)   
#define def_ramp_ratio11         ((u8)7)
#define def_ramp_value11	 ((u8)188)   
#define def_ramp_ratio12         ((u8)7)
#define def_ramp_value12	 ((u8)180)   
#define def_ramp_ratio13         ((u8)7)
#define def_ramp_value13	 ((u8)174)   
#define def_ramp_ratio14         ((u8)7)
#define def_ramp_value14	 ((u8)168)   
#define def_ramp_ratio15         ((u8)7)
#define def_ramp_value15	 ((u8)162)   
#define def_ramp_ratio16         ((u8)7)
#define def_ramp_value16	 ((u8)157)   
#define def_ramp_ratio17         ((u8)7)
#define def_ramp_value17	 ((u8)152)   
#define def_ramp_ratio18         ((u8)7)
#define def_ramp_value18	 ((u8)148)   
#define def_ramp_ratio19         ((u8)7)
#define def_ramp_value19	 ((u8)144)   
#define def_ramp_ratio20         ((u8)7)
#define def_ramp_value20	 ((u8)141)   
#define def_ramp_ratio21         ((u8)7)
#define def_ramp_value21	 ((u8)138)   
#define def_ramp_ratio22         ((u8)7)
#define def_ramp_value22	 ((u8)134)   
#define def_ramp_ratio23         ((u8)7)
#define def_ramp_value23	 ((u8)132)   
#define def_ramp_ratio24         ((u8)7)
#define def_ramp_value24	 ((u8)129)   
#define def_ramp_ratio25         ((u8)6)
#define def_ramp_value25	 ((u8)253)   
#define def_ramp_ratio26         ((u8)6)
#define def_ramp_value26	 ((u8)248)   
#define def_ramp_ratio27         ((u8)6)
#define def_ramp_value27	 ((u8)243)   
#define def_ramp_ratio28         ((u8)6)
#define def_ramp_value28	 ((u8)239)   
#define def_ramp_ratio29         ((u8)6)
#define def_ramp_value29	 ((u8)235)   
#define def_ramp_ratio30         ((u8)6)
#define def_ramp_value30	 ((u8)231)   
#define def_ramp_ratio31         ((u8)6)
#define def_ramp_value31	 ((u8)227)   
#define def_ramp_ratio32         ((u8)6)
#define def_ramp_value32	 ((u8)224)   
#define def_ramp_ratio33         ((u8)6)
#define def_ramp_value33	 ((u8)220)   
#define def_ramp_ratio34         ((u8)6)
#define def_ramp_value34	 ((u8)217)   
#define def_ramp_ratio35         ((u8)6)
#define def_ramp_value35	 ((u8)214)   
#define def_ramp_ratio36         ((u8)6)
#define def_ramp_value36	 ((u8)211)   
#define def_ramp_ratio37         ((u8)6)
#define def_ramp_value37	 ((u8)208)   
#define def_ramp_ratio38         ((u8)6)
#define def_ramp_value38	 ((u8)206)   
#define def_ramp_ratio39         ((u8)6)
#define def_ramp_value39	 ((u8)203)   
#define def_ramp_ratio40         ((u8)6)
#define def_ramp_value40	 ((u8)200)   
#define def_ramp_ratio41         ((u8)6)
#define def_ramp_value41	 ((u8)198)   
#define def_ramp_ratio42         ((u8)6)
#define def_ramp_value42	 ((u8)196)   
#define def_ramp_ratio43         ((u8)6)
#define def_ramp_value43	 ((u8)193)   
#define def_ramp_ratio44         ((u8)6)
#define def_ramp_value44	 ((u8)191)   
#define def_ramp_ratio45         ((u8)6)
#define def_ramp_value45	 ((u8)189)   
#define def_ramp_ratio46         ((u8)6)
#define def_ramp_value46	 ((u8)187)   
#define def_ramp_ratio47         ((u8)6)
#define def_ramp_value47	 ((u8)185)   
#define def_ramp_ratio48         ((u8)6)
#define def_ramp_value48	 ((u8)183)   
#define def_ramp_ratio49         ((u8)6)
#define def_ramp_value49	 ((u8)181)   
#define def_ramp_ratio50         ((u8)6)
#define def_ramp_value50	 ((u8)180)   
#define def_ramp_ratio51         ((u8)6)
#define def_ramp_value51	 ((u8)178)   
#define def_ramp_ratio52         ((u8)6)
#define def_ramp_value52	 ((u8)176)   
#define def_ramp_ratio53         ((u8)6)
#define def_ramp_value53	 ((u8)174)   
#define def_ramp_ratio54         ((u8)6)
#define def_ramp_value54	 ((u8)173)   
#define def_ramp_ratio55         ((u8)6)
#define def_ramp_value55	 ((u8)171)   
#define def_ramp_ratio56         ((u8)6)
#define def_ramp_value56	 ((u8)170)   
#define def_ramp_ratio57         ((u8)6)
#define def_ramp_value57	 ((u8)168)   
#define def_ramp_ratio58         ((u8)6)
#define def_ramp_value58	 ((u8)167)   
#define def_ramp_ratio59         ((u8)6)
#define def_ramp_value59	 ((u8)165)   
#define def_ramp_ratio60         ((u8)6)
#define def_ramp_value60	 ((u8)164)   
#define def_ramp_ratio61         ((u8)6)
#define def_ramp_value61	 ((u8)163)   
#define def_ramp_ratio62         ((u8)6)
#define def_ramp_value62	 ((u8)161)   
#define def_ramp_ratio63         ((u8)6)
#define def_ramp_value63	 ((u8)160)

//Setting of MPOL register depending of IGBT-MOSFET Drivers used
#define L6386_POLARITY	((u8)0x3F)		/* Positive logic for L6386D drivers: PWM low state = Switch OFF */
#define NEGATIVE_POLARITY	((u8)0x00)	/* Negative logic level: PWM low state = Switch ON */
	
#define DRIVERS_POLARITY ((u8)63)   
 

/*** (c) 2004 STMicroelectronics ****************** END OF FILE **************/


