/**************** (c) 2005  STMicroelectronics **********************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  Misc.h
LIBRARY VERSION  :  2.0

CREATION DATE :    08.2003
AUTHOR :      Florent COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Miscellanous routine prototypes              

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/
                  
#ifndef MISC_H
#define MISC_H          

/*****************************************************************************/

/* Public  macros ---------------------------------------------------------- */
// Accurate timing macros needed (works with 16 MHz CPU clock)

#ifdef __HIWARE__		// for HIWARE Compiler 
	#define Wait1us()	{__asm NOP; __asm NOP; __asm NOP; __asm NOP;}
#else
    #ifdef __CSMC__		    // test for Cosmic Compiler 
	#define Wait1us()	{_asm ("nop\n nop\n nop\n nop\n ");}
    #else
      #error"Unsupported Compiler!"	// Compiler Defines not found! 
    #endif
#endif

/* Public Functions prototypes --------------------------------------------- */

void Wait(u8 time);
void Wait100us(void);
void Wait1ms(void); 
void Chk_Power_Motor_Status(void);
void ST7_IntPrioritySetUp(void);
	
#endif
/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/
