/**************** (c) 2005 STMicroelectronics **********************

PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  ST7MC_hr.h
LIBRARY VERSION  :  2.0

CREATION DATE : 07.2003 
AUTHOR : PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :  harwdare register prototype definitions

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/

#ifndef MAP_ST7MC_H
#define MAP_ST7MC_H


#ifdef __HIWARE__				/* only for HIWARE Compiler*/
extern volatile u8 PADR;		/* port A data register             */          
extern volatile u8 PADDR;		/* port A data direction register   */
extern volatile u8 PAOR;		/* port A option register           */  

extern volatile u8 PBDR;		/* port B data register             */          
extern volatile u8 PBDDR;		/* port B data direction register   */
extern volatile u8 PBOR;		/* port B option register           */

extern volatile u8 PCDR;		/* port C data register             */          
extern volatile u8 PCDDR;		/* port C data direction register   */
extern volatile u8 PCOR;		/* port C option register           */

extern volatile u8 PDDR;		/* port D data register             */          
extern volatile u8 PDDDR;		/* port D data direction register   */
extern volatile u8 PDOR;		/* port D option register           */  

extern volatile u8 PEDR;		/* port E data register             */          
extern volatile u8 PEDDR;		/* port E data direction register   */
extern volatile u8 PEOR;		/* port E option register           */

extern volatile u8 PFDR;		/* port F data register             */          
extern volatile u8 PFDDR;		/* port F data direction register   */
extern volatile u8 PFOR;		/* port F option register           */

extern volatile u8 PGDR;		/* port G data register             */          
extern volatile u8 PGDDR;		/* port G data direction register   */
extern volatile u8 PGOR;		/* port G option register           */

extern volatile u8 PHDR;		/* port H data register             */          
extern volatile u8 PHDDR;		/* port H data direction register   */
extern volatile u8 PHOR;		/* port H option register           */

extern volatile u8 SCISR;		/* SCI status register							*/
extern volatile u8 SCIDR;		/* SCI data register							*/
extern volatile u8 SCIBRR;		/* SCI baud rate register						*/
extern volatile u8 SCICR1;		/* SCI control register 1						*/
extern volatile u8 SCICR2;		/* SCI control register 2						*/
extern volatile u8 SCICR3;		/* SCI control register 3						*/
extern volatile u8 SCIERPR;		/* SCI extended receive prescaler register		*/
extern volatile u8 SCIETPR;		/* SCI extended transmit prescaler register		*/

extern volatile u8 SPIDR;               /* SPI Data Register                 */
extern volatile u8 SPICR;               /* SPI Control Register              */
extern volatile u8 SPICSR;              /* SPI Status Register               */
                                                                                 
extern volatile u8 ITSPR0;          /* interrupt software priority reg0*/
extern volatile u8 ITSPR1;          /* interrupt software priority reg1*/
extern volatile u8 ITSPR2;          /* interrupt software priority reg2*/
extern volatile u8 ITSPR3;          /* interrupt software priority reg3*/
extern volatile u8 EICR;            /* external interrupt control register */   

extern volatile u8 FSCR;		/* Flash Control Status Register */

extern volatile u8 WWDGCR;		/* Window Watchdog Control Register */
extern volatile u8 WWDGWR;		/* Window Watchdog Status Register */

extern volatile u8 ADCCSR;		/* ADC Control Status Register */
extern volatile u8 ADCDRH;		/* ADC Data Register high */
extern volatile u8 ADCDRL;		/* ADC Data Register low */

extern volatile u8 TACR2;               /* timer A control register 2                 */
extern volatile u8 TACR1;               /* timer A control register 1                 */
extern volatile u8 TASR;                /* timer A status register                    */
extern volatile u8 TAIC1HR;             /* timer A input capture 1 high register      */
extern volatile u8 TAIC1LR;             /* timer A input capture 1 low register       */
extern volatile u8 TAOC1HR;             /* timer A output compare 1 high register     */
extern volatile u8 TAOC1LR;             /* timer A output compare 1 low register      */
extern volatile u8 TACHR;               /* timer A counter high register              */
extern volatile u8 TACLR;               /* timer A counter low register               */
extern volatile u8 TAACHR;              /* timer A alternate counter high register    */
extern volatile u8 TAACLR;              /* timer A alternate counter low register     */
extern volatile u8 TAIC2HR;             /* timer A input capture 2 high register      */
extern volatile u8 TAIC2LR;             /* timer A input capture 2 low register       */
extern volatile u8 TAOC2HR;             /* timer A output compare 2 high register     */
extern volatile u8 TAOC2LR;             /* timer A output compare 2 low register      */

extern volatile u8 SICSR;               /* System Integrity Control Status Register   */

extern volatile u8 TBCR2;               /* timer B control register 2                 */
extern volatile u8 TBCR1;               /* timer B control register 1                 */
extern volatile u8 TBSR;                /* timer B status register                    */
extern volatile u8 TBIC1HR;             /* timer B input capture 1 high register      */
extern volatile u8 TBIC1LR;             /* timer B input capture 1 low register       */
extern volatile u8 TBOC1HR;             /* timer B output compare 1 high register     */
extern volatile u8 TBOC1LR;             /* timer B output compare 1 low register      */
extern volatile u8 TBCHR;               /* timer B counter high register              */
extern volatile u8 TBCLR;               /* timer B counter low register               */
extern volatile u8 TBACHR;              /* timer B alternate counter high register    */
extern volatile u8 TBACLR;              /* timer B alternate counter low register     */
extern volatile u8 TBIC2HR;             /* timer B input capture 2 high register      */
extern volatile u8 TBIC2LR;             /* timer B input capture 2 low register       */
extern volatile u8 TBOC2HR;             /* timer B output compare 2 high register     */
extern volatile u8 TBOC2LR;             /* timer B output compare 2 low register      */


extern volatile u8 MCCSR;       /* Main Clock Control/Status Register */
extern volatile u8 MCCBCR;      /* Main Clock Controller: Beep Control Register */

extern volatile u8 DMCR;          /* Debug Control Register                 */
extern volatile u8 DMSR;          /* Debug Status Register                  */
extern volatile u8 DMBK1H;        /* Debug Breakpoint 1 MSB MSB Register    */
extern volatile u8 DMBK1L;        /* Debug Breakpoint 1 MSB MSB Register    */
extern volatile u8 DMBK2H;        /* Debug Breakpoint 1 MSB MSB Register    */
extern volatile u8 DMBK2L;        /* Debug Breakpoint 1 MSB MSB Register    */

extern volatile u8 PWMDCR3;             /* PWM AR Timer Duty Cycle Register 3         */
extern volatile u8 PWMDCR2;             /* PWM AR Timer Duty Cycle Register 2         */
extern volatile u8 PWMDCR1;             /* PWM AR Timer Duty Cycle Register 1         */
extern volatile u8 PWMDCR0;             /* PWM AR Timer Duty Cycle Register 0         */
extern volatile u8 PWMCR;               /* PWM AR Timer Control Register              */
extern volatile u8 ARTCSR;              /* Auto-Reload Timer Control/Status Register  */
extern volatile u8 ARTCAR;              /* Auto-Reload Timer Counter Access Register  */
extern volatile u8 ARTARR;              /* Auto-Reload Timer Auto-Reload Register     */
extern volatile u8 ARTICCSR;            /* AR Timer Input Capture Control/Status Reg. */
extern volatile u8 ARTICR1;             /* AR Timer Input Capture Register 1          */
extern volatile u8 ARTICR2;             /* AR Timer Input Capture Register 2          */

extern volatile u8 OACSR;		/* Operational Amplifier Control/Status register */ 

#else
#ifdef __CSMC__							/* only for Cosmic Compiler*/         

@tiny extern volatile u8 PADR;	/* port A data register             */          
@tiny extern volatile u8 PADDR;	/* port A data direction register   */
@tiny extern volatile u8 PAOR;	/* port A option register           */  

@tiny extern volatile u8 PBDR;	/* port B data register             */          
@tiny extern volatile u8 PBDDR;	/* port B data direction register   */
@tiny extern volatile u8 PBOR;	/* port B option register           */

@tiny extern volatile u8 PCDR;	/* port C data register             */          
@tiny extern volatile u8 PCDDR;	/* port C data direction register   */
@tiny extern volatile u8 PCOR;	/* port C option register           */

@tiny extern volatile u8 PDDR;	/* port D data register             */          
@tiny extern volatile u8 PDDDR;	/* port D data direction register   */
@tiny extern volatile u8 PDOR;	/* port D option register           */  

@tiny extern volatile u8 PEDR;	/* port E data register             */          
@tiny extern volatile u8 PEDDR;	/* port E data direction register   */
@tiny extern volatile u8 PEOR;	/* port E option register           */

@tiny extern volatile u8 PFDR;	/* port F data register             */          
@tiny extern volatile u8 PFDDR;	/* port F data direction register   */
@tiny extern volatile u8 PFOR;	/* port F option register           */

@tiny extern volatile u8 PGDR;	/* port G data register             */          
@tiny extern volatile u8 PGDDR;	/* port G data direction register   */
@tiny extern volatile u8 PGOR;	/* port G option register           */

@tiny extern volatile u8 PHDR;	/* port H data register             */          
@tiny extern volatile u8 PHDDR;	/* port H data direction register   */
@tiny extern volatile u8 PHOR;	/* port H option register           */ 

@tiny extern volatile u8 SCISR;		/* SCI status register					*/
@tiny extern volatile u8 SCIDR;		/* SCI data register					*/
@tiny extern volatile u8 SCIBRR;		/* SCI baud rate register				*/
@tiny extern volatile u8 SCICR1;		/* SCI control register 1				*/
@tiny extern volatile u8 SCICR2;		/* SCI control register 2				*/
@tiny extern volatile u8 SCICR3;		/* SCI control register 3				*/
@tiny extern volatile u8 SCIERPR;		/* SCI extended receive prescaler register		*/
@tiny extern volatile u8 SCIETPR;		/* SCI extended transmit prescaler register		*/

@tiny extern volatile u8 SPIDR;               /* SPI Data Register                 */
@tiny extern volatile u8 SPICR;               /* SPI Control Register              */
@tiny extern volatile u8 SPICSR;              /* SPI Status Register               */

@tiny extern volatile u8 ITSPR0;          /* interrupt software priority reg0*/
@tiny extern volatile u8 ITSPR1;          /* interrupt software priority reg1*/
@tiny extern volatile u8 ITSPR2;          /* interrupt software priority reg2*/
@tiny extern volatile u8 ITSPR3;          /* interrupt software priority reg3*/
@tiny extern volatile u8 EICR;            /* external interrupt control register */   

@tiny extern volatile u8 FSCR;        		/* Flash Control Status Register */

@tiny extern volatile u8 WWDGCR;	    	/* Window Watchdog Control Register */
@tiny extern volatile u8 WWDGWR;		    /* Window Watchdog Status Register */

@tiny extern volatile u8 MCCSR;	/* Main Clock Control/Status Register */
@tiny extern volatile u8 MCCBCR;	/* Main Clock Controller: Beep Control Register */

@tiny extern volatile u8 ADCCSR;	/* ADC Control Status Register */
@tiny extern volatile u8 ADCDRH;	/* ADC Data Register High */
@tiny extern volatile u8 ADCDRL;	/* ADC Data Register Low */

@tiny extern volatile u8 TACR2;               /* timer A control register 2                 */
@tiny extern volatile u8 TACR1;               /* timer A control register 1                 */
@tiny extern volatile u8 TASR;                /* timer A status register                    */
@tiny extern volatile u8 TAIC1HR;             /* timer A input capture 1 high register      */
@tiny extern volatile u8 TAIC1LR;             /* timer A input capture 1 low register       */
@tiny extern volatile u8 TAOC1HR;             /* timer A output compare 1 high register     */
@tiny extern volatile u8 TAOC1LR;             /* timer A output compare 1 low register      */
@tiny extern volatile u8 TACHR;               /* timer A counter high register              */
@tiny extern volatile u8 TACLR;               /* timer A counter low register               */
@tiny extern volatile u8 TAACHR;              /* timer A alternate counter high register    */
@tiny extern volatile u8 TAACLR;              /* timer A alternate counter low register     */
@tiny extern volatile u8 TAIC2HR;             /* timer A input capture 2 high register      */
@tiny extern volatile u8 TAIC2LR;             /* timer A input capture 2 low register       */
@tiny extern volatile u8 TAOC2HR;             /* timer A output compare 2 high register     */
@tiny extern volatile u8 TAOC2LR;             /* timer A output compare 2 low register      */

@tiny extern volatile u8 SICSR;               /* System Integrity Control Status Register   */

@tiny extern volatile u8 TBCR2;               /* timer B control register 2                 */
@tiny extern volatile u8 TBCR1;               /* timer B control register 1                 */
@tiny extern volatile u8 TBSR;                /* timer B status register                    */
@tiny extern volatile u8 TBIC1HR;             /* timer B input capture 1 high register      */
@tiny extern volatile u8 TBIC1LR;             /* timer B input capture 1 low register       */
@tiny extern volatile u8 TBOC1HR;             /* timer B output compare 1 high register     */
@tiny extern volatile u8 TBOC1LR;             /* timer B output compare 1 low register      */
@tiny extern volatile u8 TBCHR;               /* timer B counter high register              */
@tiny extern volatile u8 TBCLR;               /* timer B counter low register               */
@tiny extern volatile u8 TBACHR;              /* timer B alternate counter high register    */
@tiny extern volatile u8 TBACLR;              /* timer B alternate counter low register     */
@tiny extern volatile u8 TBIC2HR;             /* timer B input capture 2 high register      */
@tiny extern volatile u8 TBIC2LR;             /* timer B input capture 2 low register       */
@tiny extern volatile u8 TBOC2HR;             /* timer B output compare 2 high register     */
@tiny extern volatile u8 TBOC2LR;             /* timer B output compare 2 low register      */

@tiny extern volatile u8 DMCR;          /* Debug Control Register                 */
@tiny extern volatile u8 DMSR;          /* Debug Status Register                  */
@tiny extern volatile u8 DMBK1H;        /* Debug Breakpoint 1 MSB MSB Register    */
@tiny extern volatile u8 DMBK1L;        /* Debug Breakpoint 1 MSB MSB Register    */
@tiny extern volatile u8 DMBK2H;        /* Debug Breakpoint 1 MSB MSB Register    */
@tiny extern volatile u8 DMBK2L;        /* Debug Breakpoint 1 MSB MSB Register    */

@tiny extern volatile u8 PWMDCR3;             /* PWM AR Timer Duty Cycle Register 3         */
@tiny extern volatile u8 PWMDCR2;             /* PWM AR Timer Duty Cycle Register 2         */
@tiny extern volatile u8 PWMDCR1;             /* PWM AR Timer Duty Cycle Register 1         */
@tiny extern volatile u8 PWMDCR0;             /* PWM AR Timer Duty Cycle Register 0         */
@tiny extern volatile u8 PWMCR;               /* Auto-Reload Timer Control/Status Register  */
@tiny extern volatile u8 ARTCSR;              /* Auto-Reload Timer Control/Status Register  */
@tiny extern volatile u8 ARTCAR;              /* Auto-Reload Timer Counter Access Register  */
@tiny extern volatile u8 ARTARR;              /* Auto-Reload Timer Auto-Reload Register     */
@tiny extern volatile u8 ARTICCSR;            /* AR Timer Input Capture Control/Status Reg. */
@tiny extern volatile u8 ARTICR1;             /* AR Timer Input Capture Register 1          */
@tiny extern volatile u8 ARTICR2;             /* AR Timer Input Capture Register 2          */

@tiny extern volatile u8 OACSR;	/* Operational Amplifier Control/Status register */

#else
  #error"Unsupported Compiler!"	// Compiler Defines not found! 
#endif
#endif   
   
/*---CONSTANTS---*/

// LinSCI Peripheral
// SCISR
#define TDRE		((u8)0x07)		/* Transmit data bit */
#define TC			((u8)0x06)		/* Transmission complete */
#define RDRF		((u8)0x05)		/* Received data ready */
#define IDL			((u8)0x04)		/* Idle line detected  */
#define OR			((u8)0x03)		/* Overrun error */
#define NF			((u8)0x02)		/* Noise flag */
#define FE			((u8)0x01)		/* Framing error */
#define PE			((u8)0x00)		/* Parity error */

// SCICR1
#define R8			((u8)0x07)		/* Receive data bit 8 */
#define T8			((u8)0x06)		/* Transmit data bit 8 */
#define SCID		((u8)0x05)		/* Disable for low power consumption */
#define M			((u8)0x04)		/* Word length  */
#define WAKE		((u8)0x03)		/* Wake-up method */
#define PCE			((u8)0x02)		/* Parity control enable */
#define PS			((u8)0x01)		/* Parity selection */
#define PIE			((u8)0x00)		/* Parity interrupt enable */

// SCICR2
#define TIE			((u8)0x07)		/* Transmitter interrupt enable */
#define TCIE		((u8)0x06)		/* Transmission complete interrupt enable */
#define RIE			((u8)0x05)		/* Receiver interrupt enable */
#define ILIE		((u8)0x04)		/* Idle line interrupt enable  */
#define TE			((u8)0x03)		/* Transmitter enable */
#define RE			((u8)0x02)		/* Receiver enable */
#define RWU			((u8)0x01)		/* Receiver wake-up */
#define SBK			((u8)0x00)		/* Send break */


#define TX_RX_SCIBRR_9600_Bauds		0xd2		/* TX/RX 9600 bauds	*/

#define TX_RX_SCIBRR_57600_Bauds	0x00		/* TX/RX 57600 bauds	*/
#define TX_ETPR_57600_Bauds			8			/* TX 57600 bauds	*/
#define RX_ERPR_57600_Bauds			8			/* RX 57600 bauds	*/


// ADC peripheral
// ADCCSR: ADC Control/Status Register bit definition
#define EOC			((u8)0x07)		/* End of Conversion */
#define PRSC1		((u8)0x06)		/* A/D Clock Prescaler */
#define PRSC0		((u8)0x05)		/* A/D Clock Prescaler */
#define ADON		((u8)0x04)		/* A/D converter on */
#define CS3			((u8)0x03)		/* ADC Channel selection */
#define CS2			((u8)0x02)		/* ADC Channel selection */
#define CS1			((u8)0x01)		/* ADC Channel selection */
#define CS0			((u8)0x00)		/* ADC Channel selection */

#define EOC_MSK			((u8)0x80)		/* End of Conversion Mask */
#define PRSC1_MSK		((u8)0x40)		/* A/D Clock Prescaler Mask */
#define PRSC0_MSK		((u8)0x20)		/* A/D Clock Prescaler Mask */
#define ADON_MSK		((u8)0x10)		/* A/D converter on Mask */
#define CS3_MSK			((u8)0x08)		/* ADC Channel selection Mask */
#define CS2_MSK			((u8)0x04)		/* ADC Channel selection Mask */
#define CS1_MSK			((u8)0x02)		/* ADC Channel selection Mask */
#define CS0_MSK			((u8)0x01)		/* ADC Channel selection Mask */

#define PRSC_MASK		((u8)0x00)		/* Define here selected prescaler ratio */

#define CONVERT_AIN0	((u8)ADON_MSK	+ PRSC_MASK													)
#define CONVERT_AIN1	((u8)ADON_MSK 	+ PRSC_MASK										+ CS0_MSK	)
#define CONVERT_AIN2	((u8)ADON_MSK 	+ PRSC_MASK							+ CS1_MSK				)
#define CONVERT_AIN3	((u8)ADON_MSK	+ PRSC_MASK							+ CS1_MSK	+ CS0_MSK	)
#define CONVERT_AIN4	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK							)
#define CONVERT_AIN5	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK				+ CS0_MSK	)
#define CONVERT_AIN6	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK	+ CS1_MSK				)
#define CONVERT_AIN7	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK	+ CS1_MSK	+ CS0_MSK	)
#define CONVERT_AIN8	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK										)
#define CONVERT_AIN9	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK							+ CS0_MSK	)
#define CONVERT_AIN10	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK				+ CS1_MSK				)
#define CONVERT_AIN11	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK				+ CS1_MSK	+ CS0_MSK	)
#define CONVERT_AIN12	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK							)
#define CONVERT_AIN13	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK				+ CS0_MSK	)
#define CONVERT_AIN14	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK	+ CS1_MSK				)
#define CONVERT_AIN15	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK	+ CS1_MSK	+ CS0_MSK	)



/* Timers A&B Control Register 1 bit definition  */

#define ICIE        0x07        // Input capture interrupt enable                                    
#define OCIE        0x06        // Output compare interrupt enable                            
#define TOIE        0x05        // Timer overflow interrupt enable
#define OLVL2       0x02        // Output level 2
#define IEDG1       0x01        // Input edge 1
#define OLVL1       0x00        // Ouput level 1

/* Timers A&B Control Register 2 bit definition  */

#define OC1E        0x07        // Output compare 1 pin
#define OC2E        0x06        // Output compare 1 pin
#define OPM         0x05        // One pulse mode
#define PWM         0x04        // PWM Mode
#define IEDG2       0x01        // Input edge 2

/* Timer A&B Status register bit definition  */

#define ICF1        0x07        // Input capture 1 flag
#define OCF1        0x06        // Output compare 1 flag
#define TOF         0x05        // Timer overflow flag
#define ICF2        0x04        // Input capture 2 flag
#define OCF2        0x03        // Output compare 2 flag


/*------------------------------REGISTER BITS DEFINITION---------------------*/
// MCCSR: MCC Status register
#define TB_INT_FLAG	((u8)0x01) /* Time base interrupt flag */
#define TB_INT_EN	((u8)0x02) /* Time Base interrupt enable */
#define TB25MS		((u8)0x0C) /* Time base (Fosc2=8MHz) */
#define TB10MS		((u8)0x08) /* Time base (Fosc2=8MHz) */
#define TB4MS		((u8)0x04) /* Time base (Fosc2=8MHz) */
#define TB2MS		((u8)0x00) /* Time base (Fosc2=8MHz) */
#define SLOW_MODE	((u8)0x10) /* Slow Mode Select */
#define FOSC_2		((u8)0x00) /* Fcpu = Fosc2/2 */
#define FOSC_4		((u8)0x20) /* Fcpu = Fosc2/4 */
#define FOSC_8		((u8)0x40) /* Fcpu = Fosc2/8 */
#define FOSC_16		((u8)0x60) /* Fcpu = Fosc2/16 */
#define MCO_ENABLE	((u8)0x80) /* Main Clock Out Selection */

// MCCBCR: MCC Beep control register
#define ADSTS		((u8)0x03)		/* ADC Converter Sample Time Stretch */
#define ADCIE		((u8)0x02)		/* ADC Interrupt Enable */
#define BC1			((u8)0x01)		/* MCC Beep Control */
#define BC0			((u8)0x00)		/* MCC Beep Control */


/*---CONSTANTS---*/

/* OP-AMP: Operational Amplifier */ 

#define CMPOVR		((u8)0x80)			/* Offset Compensation Status bit */
#define OFFCMP		((u8)0x40)          /* Offset compensation start bit */
#define AVGCMP		((u8)0x20)          /* Average Compensation times selection */
#define OAON		((u8)0x10)          /* Op-Amp power on/off bit */
#define HIGHGAIN	((u8)0x08)          /* Gain range selection bit */
   

/* Window Watchdog */
#define WDGA		((u8)0x80)

#endif

/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/
