/*****************************************************
 lustart.h - Startup data structure for ST7
 ----------------------------------------------------
   Copyright (c) HIWARE AG, Basel, Switzerland
               All rights reserved               
                  Do not modify!
 *****************************************************/

#ifndef START07_H
#define START07_H

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char Byte;

typedef void (*PROC) (void);

#undef FAR
#define FAR far

/**** These data structure contain several pointers. All data pointers are
      FAR pointers! */

#if defined(__ST19X__) && (defined(__BANKED_DATA__) || defined(__BANKED__))
typedef unsigned char * POINTER;
#else
typedef unsigned char *FAR POINTER;
#endif

/**** The following is a description of a memory range starting at address
      'base' and 'size' bytes long. (I.e. [base .. (base+size)[) */
      
typedef struct _Range{
  POINTER  beg;
  unsigned int size;
} _Range, *FAR _RangePtr;

/*
  Note: The structure above does not exactly describe the actual range
        descriptors generate by the linker. To save memory, the linker
        simply allocates a POINTER, followed by a WORD, i.e. 5 bytes.
          Due to a padding byte added by the compiler to make the struct's
        size even, one cannot use this description to access the memory
        containing the ranges to clear.
 */
  
/**** The copy-down descriptor. */

typedef struct _Copy{
  unsigned int size;
  POINTER  dest;
/* Byte     data[(size & 1) ? size + 1 : size];*/
} _Copy, *FAR _CopyPtr;

      
/* After the data of a copy-down descriptor, the next one follows, i.e. the
   whole copy-down section can be described as
      
      CopyDesc copyDownSection[];
      
   An entry with (size == 0) terminates the array.
 */

typedef void (*_PFunc)(void);

typedef struct _LibInit{
  _PFunc  *FAR startup;      /* address of startup desc */
} _LibInit;

typedef struct _Cpp{
  _PFunc  initFunc;      /* address of init function */
} _Cpp;

typedef POINTER _Init;

typedef struct _tagStartup {
  unsigned int flags;
  PROC       main;             /* Main function of user's application       */
#ifndef __ELF_OBJECT_FILE_FORMAT__
  unsigned int filler1;
  unsigned int filler2;
#endif
  char       filler21;
  /* POINTER */ unsigned char stackOffset;      /* Initial value of the stack pointer        */
  unsigned int nofZeroOuts;      /* #blocks to clear in memory                */
  _RangePtr  pZeroOut;         /* Pointer to array of '_Range', terminated
                                  by an entry with size 0                   */
#ifndef __ELF_OBJECT_FILE_FORMAT__
  unsigned int filler3;
#endif
  _CopyPtr   toCopyDownBeg;    /* First copy descriptor                     */
#ifdef __ELF_OBJECT_FILE_FORMAT__
   unsigned short  nofLibInits;     /* number of library startup descriptors */
   _LibInit        *FAR libInits;   /* vector of pointers to library startup descriptors */
   unsigned short  nofInitBodies;   /* number of init functions for C++ constructors */
   _Cpp            *FAR initBodies; /* vector of function pointers to init functions for C++ constructors */
#else
  PROC *FAR  mInits;           /* Pointer to array of function pointers,
                                  terminated by a 0 entry                   */
  unsigned char *FAR *FAR libInits;         /* Pointer to array of pointers to startup
                                  descriptors of ROM libraries, terminated
                                  by 0x0000FFFF                             */
#endif
} _startupDesc;

#pragma DATA_SEG __FAR_SEG _STARTUP
 
extern _startupDesc _startupData;   

#pragma DATA_SEG DEFAULT

#pragma CODE_SEG __NEAR_SEG NON_BANKED 

extern void _Startup (void);     /* Execution begins in this procedure        */   


#pragma CODE_SEG DEFAULT

/*--------------------------------------------------------------------*/

#ifdef __cplusplus
 }
#endif

#endif


