/******************** (C) COPYRIGHT 2006 STMicroelectronics **********************
* File Name          : I2C.c
* Author             : MPA Systems Lab
* Date First Issued  : 04/13/2006 :  V1.0
* Description        : I2C low level function prototype and definition
                       ( POW Code : DP.APN0004.01 )
**********************************************************************************
* History:
* Date          Version     Description
* 04/13/06   :  V1.0        First version
*********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**********************************************************************************/

#ifndef _I2C_DRIVER
#define _I2C_DRIVER

	// Standard types definitions and ST7 specific macros
	#include "lib.h"

	#define AC 3
	#define PMAC 1
	#define BLDC 2
	
	#define MOTOR_TYPE DEFINE_HERE
	
	#if (MOTOR_TYPE==DEFINE_HERE)
		#error "Select the Motor Type inside I2C.h header file"
	#endif
	
	#if (MOTOR_TYPE==BLDC)
		/**** Only BLDC motor*****/
		#define SPICR_SPE 6   
		#define TACSR TASR   
		#define TACSR_TIMD 2
	#endif
    	
	#define SLAVE_ADDRESS   	((u8)(0xa0))	/*"Modifiable":seven bit number multiplied by 2 */
	#define I2C_TABLE_SIZE 		((u8)(16))	 /*"Modifiable":maximum number of bytes per transmission*/

	// SPI Configuration                
	// 0x80 for SPI clock on falling
	// 0x88 for SPI clock on rising
	#define SPI_CONFIG_CR ((u8) 0x80)   
	#define SPI_CONFIG_CSR ((u8) 0x06) 
	
	// TIMER Configuration
	#define TIMEOUT ((u16)500)
	#define TCOUNTL (u8)((TIMEOUT*4)-3)
	#define TCOUNTH (u8)(((TIMEOUT*4)-3)>>8)
	
	void Init_I2C_Protocol(void);	//to be called from main to initialise the I2C driver
					  
	extern u8 I2C_Datas_W[];				//for high level protocol purpose:	  ProtoSup.c
	extern u8 I2C_Datas_R[];				//for high level protocol purpose:	  ProtoSup.c
	extern BOOL New_Data_Receved;	  			//for high level protocol purpose:	  ProtoSup.c
	extern BOOL New_Data_Sent;		  		//for high level protocol purpose:	  ProtoSup.c
#endif

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
