/******************** (C) COPYRIGHT 2006 STMicroelectronics **********************
* File Name          : I2C.c
* Author             : MPA Systems Lab
* Date First Issued  : 04/13/2006 :  V1.0
* Description        : I2C high level function
                       ( POW Code : DP.APN0004.01 )
**********************************************************************************
* History:
* Date          Version     Description
* 04/13/06   :  V1.0        First version
*********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**********************************************************************************/

// Public I2C high/low level function prototypes 
#include "I2C.h"
#include "ProtoSup.h"

#if (MOTOR_TYPE==BLDC)
		/**** Only BLDC motor*****/
		#include "st7mc_hr.h"
		
		#include "regul.h"
		#define MTC_GetRotorFreq Period_To_Frequency
		
#else
		// Library configuration and ST7FMC peripherals Hardware Registers declaration
		#include "config.h"
#endif

// Motor Control Library Include
#include "mtc.h"      

extern u8 Power_Motor_Status;

/******************************  functions   *************************************/
static BOOL Test_Check_sum(void) ;	/*this function compare the CRC sent by the master to the CRC of the data receved */
static u16 Return_CRC(u8*);		 	/* this function return the CRC of the datas in or out */
static void New_Cde_Detected(void);  /* New command detect */ 
static void Not_Ready_Function(void); 
static void Not_ACK_Function(void);	  
static void ACK_Function(void);		
static BOOL Master_Querry(void);	    /*Data sent by the master is request or informations*/
static void Querries_of_Master(void); /*Type of master requirements*/
static BOOL Test_STX_Presence(void) ;
static void Fill_Data_In(void);	  
static void Fill_Data_valid(void);  
static void Stop_machine(void);	   /*This function may stop the motor when the commade is receved*/

void  LINK_protocol(void);

/******************************** variables   ********************************************/
volatile u8	COMMAND;
static u8 Data_In[ Data_In_Sizetab ];
u8 Valid_Data_In[ Data_In_Sizetab ];	/* you find there real effective datas D1...to Dn without STX,ETX,CRC,LG... */
u8 Valid_Data_Out[ Data_Out_Sizetab ];
static u8 Data_Lenght ;
static u8 tampon;
static u8 Last_tab_index;
static BOOL Trame_Recev = FALSE; //need in essorage mode when all datas are receved  start the new program
static u16 CRC_Calculation = 0;  //See return_CRC function
static BOOL Test_ETX_Presence = FALSE ;


/***********************************************
 ** Return_CRC
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:	This fonction returns the CRC of the datas in or out
 *					The CRC is only the sum for the moment
 *
 *  RETURNS:
 *
 ***********************************************/
static u16 Return_CRC(u8 *tab_pointer)
{  /* see Data_in structure schematic above. */
 	
	CRC_Calculation = 0; 
	/* From D1 to Dn */
	for (tampon = 2; (tampon < (2 + *(tab_pointer + 1))) && (tampon < Data_In_Sizetab ) ; tampon ++)
	{
		CRC_Calculation += *(tab_pointer + tampon); 
	}
	if( *(tab_pointer + tampon + 2)== ETX ) /* stop reached for assurance */
	{
		return(CRC_Calculation);
	}
	else
	{
		return(0xffff);
	}
}

/***********************************************
 ** Master_Querry
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:	Master asks slave for Status or other information ?
 *
 *  RETURNS:
 *
 ***********************************************/
static BOOL Master_Querry(void)
{
	if ( ( COMMAND >= 7 ) && ( COMMAND <= 9 ) ) 
	{
		return(TRUE);
	}
	else
	{
		return(FALSE);
	}
}

/***********************************************
 ** Querries_of_Master
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:	The Data_Out table is filled according to the master's request
 *
 *  RETURNS:
 *
 ***********************************************/
static void Querries_of_Master(void)
{                        
	u16 RotorFreq;
	switch(COMMAND)
	{	
		case ASK_SPEED:
			RotorFreq=MTC_GetRotorFreq(); 
			I2C_Datas_W[0] = (u8)(RotorFreq>>8);			
			I2C_Datas_W[1] = (u8)(RotorFreq);
			I2C_Datas_W[2] = (u8)(~I2C_Datas_W[0]); 
			I2C_Datas_W[3] = (u8)(~I2C_Datas_W[1]);
		break;
		
		case ASK_STATUS:
		        I2C_Datas_W[0] = Power_Motor_Status;
		        I2C_Datas_W[1] = (u8)(~I2C_Datas_W[0]);
	}
}

/***********************************************
 ** Test_STX_Presence
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static BOOL Test_STX_Presence(void) 
{
	if(I2C_Datas_R[1] == STX ) /* should be confirmed: position of STX */
	{
		if( I2C_Datas_R[2] < Data_In_Sizetab ) 
		{
			Data_Lenght = I2C_Datas_R[2]; 
		}
		else
		{
			Data_Lenght = Data_In_Sizetab;/* Bad case may not happen: limitation here is to avoid overflow */
		}
		Last_tab_index = 0; /* to fill table at the beginning */
		return(TRUE);
	}
	else
	{
		return(FALSE);
	}
}

/***********************************************
 ** Stop_machine
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static void Stop_machine(void)
{       
/*
	NOP;//most be filled by the ...
	// when new command is send; this function may stop the motor
	//ACM_StopInverter();
	//USER_StopMotor();
*/
}                                                

/***********************************************
 ** Not_Ready_Function
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static void Not_Ready_Function(void)
{
	I2C_Datas_W[0] = STX ;
	I2C_Datas_W[1] = 1 ;  /* number of bytes */
	I2C_Datas_W[2] = NOT_READY ;
	I2C_Datas_W[5] = ETX ; // Set before CRC calculation
	I2C_Datas_W[3] = ((u8) (Return_CRC(I2C_Datas_W ) / 256));
	I2C_Datas_W[4] = ((u8) (Return_CRC(I2C_Datas_W ) & 0x00ff));
}

/***********************************************
 ** Not_ACK_Function
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static void Not_ACK_Function(void)
{										  	
	I2C_Datas_W[0] = STX ;
	I2C_Datas_W[1] = 1 ;  /* number of bytes */
	I2C_Datas_W[2] = NOT_ACK ;
	I2C_Datas_W[5] = ETX ; // Set before CRC calculation
	I2C_Datas_W[3] = ((u8) (Return_CRC(I2C_Datas_W ) / 256));
	I2C_Datas_W[4] = ((u8) (Return_CRC(I2C_Datas_W ) & 0x00ff));
	
}

/***********************************************
 ** ACK_Function
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static void ACK_Function(void)
{
	I2C_Datas_W[0] = STX ;
	I2C_Datas_W[1] = 1 ;  /* number of bytes */
	I2C_Datas_W[2] = ACK ;
	I2C_Datas_W[5] = ETX ; // Set before CRC calculation
	I2C_Datas_W[3] = ((u8) (Return_CRC(I2C_Datas_W ) / 256));
	I2C_Datas_W[4] = ((u8) (Return_CRC(I2C_Datas_W ) & 0x00ff));
	
}

/***********************************************
 ** New_Cde_Detected
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static void New_Cde_Detected(void)
{                            
     COMMAND = Valid_Data_In[0];  
}  /* end of New_Cde_Detected */

/***********************************************
 ** Test_Check_sum
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:	test if CRC sent and the calculated one are identical
 *
 *  RETURNS:
 *
 ***********************************************/
static BOOL Test_Check_sum(void)
{
	if ( Return_CRC(Data_In) == 256*(u16)Data_In[Data_Lenght + 2 ] +  (u16)Data_In[Data_Lenght + 3 ] )
	{
		return( TRUE);
	}
	else
	{
   		return( FALSE);
	}             
}//end of Test_Check_sum

/***********************************************
 ** Fill_Data_In
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static void Fill_Data_In(void)
{/*1	we fill data_in */

	for( tampon = 0 ; tampon < (MAX_BYTES_TRAME - 1) ; tampon ++ ) /* MAX_BYTES_TRAME number of "data receved - 1" */
	{
		Data_In[tampon + Last_tab_index ] = I2C_Datas_R[tampon + 1];
	}
 	Last_tab_index =  (u8)(Last_tab_index + tampon) ; /* -1 ??  */

 	if( Data_Lenght < (I2C_TABLE_SIZE - 6) ) /* ETX is in the original frame */
 	{
	 	if( I2C_Datas_R[ Data_Lenght + 5 ] == ETX )  /* I2C_Datas_R[3] = number of byte transmited */
	 	{
			Test_ETX_Presence = TRUE;
			Last_tab_index = 0;
	 	}

  	}
	else
	{ /* ETX is sent in another trame than  the STX one */
  		if( ( Last_tab_index > (Data_Lenght + 3) ) && (Data_In[ Data_Lenght + 4] == ETX ) )
		{
			Test_ETX_Presence = TRUE;
			Last_tab_index = 0;
		}
		else
		{
			Test_ETX_Presence = FALSE;
		}
  	}
	
	/*2	datas_receved is set false  to avoid reading twice the same datas*/
	New_Data_Receved = FALSE ; 

}//end of Fill_Data_In

/***********************************************
 ** Fill_Data_valid
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS:
 *
 ***********************************************/
static void Fill_Data_valid(void)
{
	for( tampon = 0; (tampon < (Data_In_Sizetab -2)) && (tampon < Data_In[ 1])  ; tampon ++ )
	{
		Valid_Data_In[ tampon ] =  Data_In[ tampon + 2 ];
	}
}

/***********************************************
 ** LINK_protocol
 *
 *  FILENAME:
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:  This function has to be called inside the main loop to execute the 
 *		  comunication protocol.
 *
 *  RETURNS:
 *
 ***********************************************/
void LINK_protocol(void)
{               
	if(New_Data_Receved) 
	{       
		New_Data_Receved = FALSE;
		
		/*// Test (Togle PB0)
		if (ValBit(PBDR,0))
			ClrBit(PBDR,0);
		else
			SetBit(PBDR,0);		
		}*/
				
//////////////////////////////////////////////////////////////////////////////////
		if( Test_STX_Presence() ) // beginning of datas 
		{ 	
			// More than one byte of valid data is sent 
			Fill_Data_In();								
			if( Test_ETX_Presence )  // test of ETX 
			{
				if( Test_Check_sum() )
				{   
					ACK_Function();
					Fill_Data_valid();   						
					New_Cde_Detected();
					if( Master_Querry() ) 
						Querries_of_Master();
				}
				else
				{
					Not_ACK_Function();
				}
			}
			else
			{
				
				_asm ("NOP"); //data send with STX but no ETX
				
			}
		}			

//////////////////////////////////////////////////////////////////////////////////
	} // end of New_Data_received 
	
	else if (New_Data_Sent)
	{

		New_Data_Sent = FALSE ;
		Not_Ready_Function();	// Fill the output table with Not Ready frame 
	}

}/*end of LINK_protocol*/

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
