/******************** (C) COPYRIGHT 2006 STMicroelectronics **********************
* File Name          : I2C.c
* Author             : MPA Systems Lab
* Date First Issued  : 04/13/2006 :  V1.0
* Description        : I2C high level function prototype and definitions
                       ( POW Code : DP.APN0004.01 )
**********************************************************************************
* History:
* Date          Version     Description
* 04/13/06   :  V1.0        First version
*********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**********************************************************************************/

#ifndef _PROTOSUP
#define _PROTOSUP  
	
	/************* constants   ************************/
	#define Data_In_Sizetab 		((u8)61)	  	//"Modifiable"  Size of reception buffer
	#define Data_Out_Sizetab 		((u8)15)	  	//"Modifiable"  Size of transmission buffer
	#define MAX_BYTES_TRAME		   	((u8)11)	  	//"Modifiable"  must be <=I2C_TABLE_SIZE 
	
	#define CMD_START 			((u8) (0x66))	  	//"Modifiable"
	#define CMD_BRAKE				((u8) (0x88))	  	//"Modifiable"
	#define CMD_SETSPEED				((u8) (0x77))	  	//"Modifiable"
	
	#define ETX 						((u8) (0x03))	  	//"Modifiable"
	#define STX 						((u8) (0x02))		//"Modifiable"
	#define ACK 						((u8) (0x1c))		//"Modifiable"

	#define NOT_ACK					((u8) (0xee))		//"Modifiable"
	#define NOT_READY					((u8) (0xcc))		//"Modifiable"
	
	//Define di master query

	#define ASK_STATUS				((u8) (0x08))		//"Modifiable"
	
	#define ASK_SPEED				((u8) (0x07))		//"Modifiable"
	
	extern volatile u8	COMMAND;
	
	/************* functions   ************************/
	void  LINK_protocol(void);
	/************* variables   ************************/
	extern u8 I2C_Datas_R[];
	extern u8 I2C_Datas_W[];
	
	extern BOOL New_Data_Receved ; /* these variables are true when datas are receved(or sent) by I2c link */
	extern BOOL New_Data_Sent;
	
	extern u8 Valid_Data_In[];
	extern u8 Valid_Data_Out[];

#endif

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
