/******************** (C) COPYRIGHT 2006 STMicroelectronics **********************
* File Name          : I2C.c
* Author             : MPA Systems Lab
* Date First Issued  : 04/13/2006 :  V1.0
* Description        : Definition of interrupt vector
                       ( POW Code : DP.APN0004.01 )
**********************************************************************************
* History:
* Date          Version     Description
* 04/13/06   :  V1.0        First version
*********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**********************************************************************************/

// Public I2C high/low level function prototypes
#include "I2C.h"

#if ((MOTOR_TYPE==AC) || (MOTOR_TYPE==PMAC))
	#include "config.h"		/* AC or PMAC motor library configuration keys */
#endif

// Interrupt service routines prototypes

void Dummy_Interrupt(void);
extern void ART_Interrupt (void);

#if ((MOTOR_TYPE==AC) || (MOTOR_TYPE==PMAC))
	#ifdef ENABLE_RS232
		extern void SCI_IT_Routine (void);
	#endif
#else
	extern void SCI_IT_Routine (void);
#endif
extern void TIMB_Interrupt (void);


extern void MTC_C_D_IT (void);
extern void MTC_R_Z_IT (void);
extern void MTC_U_CL_SO_IT (void);

extern void TIMER_A_Interrupt_Routine (void);
extern void SPI_Interrupt_Routine (void);
extern void INT_SCK_I2C (void);
extern void INT_SDA_I2C (void);

extern void MCES_SE_IT (void);

extern void _stext(void);

// Interrupt service routines vector table (unused vectors point to Dummy_Interrupt (iret)

void (*const _vectab[])() = {
		ART_Interrupt,
		Dummy_Interrupt,		// AVD_Interrupt,
		#if ((MOTOR_TYPE==AC) || (MOTOR_TYPE==PMAC))
			#ifdef ENABLE_RS232
				SCI_IT_Routine,
			#else 
				Dummy_Interrupt,
			#endif
		#else
			SCI_IT_Routine,
		#endif
		#if ((MOTOR_TYPE==AC) || (MOTOR_TYPE==PMAC))
		Dummy_Interrupt,		// TIMB_Interrupt,
		#else
		TIMB_Interrupt,
		#endif
		TIMER_A_Interrupt_Routine,		// TIMA_Interrupt,
		SPI_Interrupt_Routine,		// SPI_Interrupt,
		MTC_C_D_IT,
		MTC_R_Z_IT,
		MTC_U_CL_SO_IT,
		INT_SCK_I2C,     //PORTS_ei2_Interrupt
		Dummy_Interrupt, //PORTS_ei1_Interrupt,
		INT_SDA_I2C,     //PORTS_ei0_Interrupt
		Dummy_Interrupt,		// MCC_Interrupt,
		MCES_SE_IT,
		Dummy_Interrupt,		// TRAP_Interrupt,
		_stext
};

@interrupt						/* Cosmic interrupt handling */
/*-----------------------------------------------------------------------------
ROUTINE NAME : Dummy_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Empty Interrupt Service Routine

COMMENTS     : all the non-connected interrupt vectors are connected to this
				empty function
-----------------------------------------------------------------------------*/ 
void Dummy_Interrupt(void)
{
}

/*** (c) 2006 STMicroelectronics ****************** END OF FILE ***/