/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : E3PROM.h
* Author             : MCD Application Team
* Date First Issued  : 01/06/2005
* Description        : This file contains all the functions prototypes for the
*                      E3PROM software functions.
********************************************************************************
* History:
*  01/06/2005 : V1.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#ifndef _E3PROM_H
#define _E3PROM_H

#include "71x_lib.h"

/* Offset of the two sectors */
#define Offset_Sector_1     0xC0000
#define Offset_Sector_2     0xC2000

/* The valid sector address */
#define ValidSectorAddress_1      0x400C1FFC
#define ValidSectorAddress_2      0x400C3FFC
#define ValidSector1       *(vu32*)0x400C1FFC
#define ValidSector2       *(vu32*)0x400C3FFC

/* The valid region address */
#define Valid_Region_1     0x400C1FF8
#define Valid_Region_2     0x400C3FF8

/* Max status bits for data set */
#define Max_Count_1         35 /* The number of Data-Set in the first sector */
#define Max_Count_2         35 /* the number of Data-Set in the second sector */

/* Max Data-set */
#define Max_Data_Set_1      (4 * Max_Count_1) 
#define Max_Data_Set_2      (4 * Max_Count_2) + 0x2000


/* Define the ERASE STATUS */
#define EEPROM_SECTOR_1_VALID          0x0000
#define EEPROM_SECTOR_2_VALID          0x0001
#define EEPROM_FULL_ERASE_REQUIRED     0x0002
#define EEPROM_SUCCESSFUL_DATA_SET     0x0003
#define EEPROM_SUCCESSFUL_DATA_READ    0x0004
#define EEPROM_NO_DATA_SET             0x0007
#define EEPROM_NO_VALID_DATA           0x0008
#define EEPROM_SUCCESSFUL_DATA_WRITE   0x0009


/*******************************************************************************
* Function Name  : EEPROM_Init
* Description    : Initialize the EEPROM 
* Input          : None
* Return         : None
*******************************************************************************/
void EEPROM_Init(void);

/*******************************************************************************
* Function Name  : EEPROM_GetValidSector
* Description    : Get the valid sector 
* Input          : None
* Return         : The valid sector 
*******************************************************************************/
u32 EEPROM_GetValidSector(void);

/*******************************************************************************
* Function Name  : EEPROM_ValidDataSet
* Description    : Get the valid data set 
* Input 1        : The valid sector
* Input 2        : The valid data set
* Return         : The status of the data set
*******************************************************************************/
u32 EEPROM_ValidDataSet(vu32 Valid_Sector,vu32 *Valid_Data_Set);

/*******************************************************************************
* Function Name  : EEPROM_DataRead
* Description    : Read the valid data 
* Input          : The Data
* Return         : The status of the read operation
*******************************************************************************/
u32 EEPROM_DataRead(vu32 *Data);

/*******************************************************************************
* Function Name  : EEPROM_DataWrite
* Description    : Write the new data
* Input          : The data to be written
* Return         : The status of the write operation
*******************************************************************************/
u32 EEPROM_DataWrite(vu32 Data);

/*******************************************************************************
* Function Name  : EEPROM_UpdateDataSet
* Description    : Update the data set
* Input  1       : The current valid data set  
* Input  2       : The valid sector
* Return         : None
*******************************************************************************/
void  EEPROM_UpdateDataSet(vu32 Valid_Data_Set, vu32 Valid_Sector);

#endif
/******************* (C) COPYRIGHT 2005 STMicroelectronics *****END OF FILE****/
