/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : common.c
* Author             : MCD Application Team
* Date First Issued  : 10/25/2004
* Description        : This file provides all the common functions.
********************************************************************************
* History:
*  09/15/2006 : IAP Version 3.0
*  02/01/2006 : IAP Version 2.0
*  11/24/2004 : IAP Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "common.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : Int2Str
* Description    : Convert an Integer to a string
* Input          : - str: The string
*                  - intnum: The intger to be converted
* Output         : None
* Return         : None
*******************************************************************************/
void Int2Str(u8* str, s32 intnum)
{
    u32 i, Div = 1000000000, j = 0, Status = 0;

    for (i = 0; i < 10; i++)
    {
        str[j++] = (intnum / Div) + 48;

        intnum = intnum % Div;
        Div /= 10;
        if ((str[j-1] == '0') & (Status == 0))
        {
            j = 0;
        }
        else
        {
            Status++;
        }
    }
}
/*******************************************************************************
* Function Name  : Str2Int
* Description    : Convert a string to an integer
* Input 1        : - inputstr: The string to be converted
*                  - intnum: The intger value
* Output         : None
* Return         : 1: Correct
*                  0: Error
*******************************************************************************/
u32 Str2Int(u8 *inputstr, s32 *intnum)
{
    u32 i = 0, res = 0;
    u32 val = 0;

    if (inputstr[0] == '0' && (inputstr[1] == 'x' || inputstr[1] == 'X'))
    {
        if (inputstr[2] == '\0')
        {
            return 0;
        }
        for (i = 2; i < 11; i++)
        {
            if (inputstr[i] == '\0')
            {
                *intnum = val;
                res = 1; /* return 1; */
                break;
            }
            if (ISVALIDHEX(inputstr[i]))
            {
                val = (val << 4) + CONVERTHEX(inputstr[i]);
            }
            else
            {
                /* return 0; Invalid input */
                res = 0;
                break;
            }
        }

        if (i >= 11) res = 0; /* over 8 digit hex --invalid */
    }
    else /* max 10-digit decimal input */
    {
        for (i = 0;i < 11;i++)
        {
            if (inputstr[i] == '\0')
            {
                *intnum = val;
                /* return 1; */
                res = 1;
                break;
            }
            else if ((inputstr[i] == 'k' || inputstr[i] == 'K') && (i > 0))
            {
                val = val << 10;
                *intnum = val;
                res = 1;
                break;
            }
            else if ((inputstr[i] == 'm' || inputstr[i] == 'M') && (i > 0))
            {

                val = val << 20;
                *intnum = val;
                res = 1;
                break;
            }
            else if (ISVALIDDEC(inputstr[i]))
                val = val * 10 + CONVERTDEC(inputstr[i]);
            else
            {
                /* return 0; Invalid input */
                res = 0;
                break;
            }
        }
        if (i >= 11) res = 0; /* Over 10 digit decimal --invalid */
    }

    return res;
}
/*******************************************************************************
* Function Name  : GetIntegerInput
* Description    : Get an integer from the HyperTerminal
* Input          : - num: The inetger
* Output         : None
* Return         : 1: Correct
*                  0: Error
*******************************************************************************/
u32 GetIntegerInput(s32 * num)
{
    u8 inputstr[16];

    while (1)
    {
        GetInputString(inputstr);
        if (inputstr[0] == '\0') continue;

        if ((inputstr[0] == 'a' || inputstr[0] == 'A') && inputstr[1] == '\0')
        {
            SerialPutString("User Cancelled \r\n");
            return 0;
        }

        if (Str2Int(inputstr, num) == 0)
        {
            SerialPutString("Error, Input again: \r\n");
        }
        else
        {
            return 1;
        }
    }
}

/*******************************************************************************
* Function Name  : SerialKeyPressed
* Description    : Test to see if a key has been pressed on the HyperTerminal
* Input          : - key: The key pressed
* Output         : None
* Return         : 1: Correct
*                  0: Error
*******************************************************************************/
u32 SerialKeyPressed(u8 *key)

{
#ifdef STR71x

    if (UART0->SR & UART_RxBufFull)
    {
        *key = (u8)UART0->RxBUFR;
        return 1;
    }
    else
    {
        return 0;
    }
#endif

#ifdef STR73x
    /* First clear Rx buffer */

    if (UART0->SR & UART_Flag_RxBufFull)
    {
        *key = (u8)UART0->RxBUFR;
        return 1;
    }
    else
    {
        return 0;
    }
#endif

#ifdef STR75x

    if ( UART_GetFlagStatus(UART0, UART_FLAG_RxFIFOEmpty) != SET)
    {
        *key = (u8)UART0->DR;
        return 1;
    }
    else
    {
        return 0;
    }
#endif
}

/*******************************************************************************
* Function Name  : GetKey
* Description    : Get a key from the HyperTerminal
* Input          : None
* Output         : None
* Return         : The Key Pressed
*******************************************************************************/
u8 GetKey(void)
{
    u8 key = 0;
    /* Waiting for user input */
    while (1)
    {
        if (SerialKeyPressed((u8*)&key)) break;
    }
    return key;

}

/*******************************************************************************
* Function Name  : SerialPutChar
* Description    : Print a character on the HyperTerminal
* Input          : - c: The character to be printed
* Output         : None
* Return         : None
*******************************************************************************/
void SerialPutChar(u8 c)
{
#ifdef STR71x
    UART_ByteSend(UART0, (u8*)&c);
    while ((UART0->SR & UART_TxEmpty) != UART_TxEmpty);
#endif

#ifdef STR73x
    UART_ByteSend(UART0, c);
    while ((UART0->SR & UART_Flag_TxEmpty) != UART_Flag_TxEmpty);
#endif

#ifdef STR75x
    UART_SendData(UART0, c);
    while (UART_GetFlagStatus(UART0, UART_FLAG_TxFIFOFull) != RESET);
#endif
}

/*******************************************************************************
* Function Name  : SerialPutString
* Description    : Print a string on the HyperTerminal
* Input          : - s: The string to be printed
* Output         : None
* Return         : None
*******************************************************************************/
void SerialPutString(u8 *s)
{
    while (*s != '\0')
    {
        SerialPutChar(*s);
        s ++;
    }
}

/*******************************************************************************
* Function Name  : GetInputString
* Description    : Get Input string from the HyperTerminal
* Input          : - buffP: The input string
* Output         : None
* Return         : None
*******************************************************************************/
void GetInputString (u8 * buffP)
{
    u32 bytes_read = 0;
    u8 c = 0;
    do
    {
        c = GetKey();
        if (c == '\r')
            break;
        if (c == '\b') /* Backspace */
        {
            if (bytes_read > 0)
            {
                SerialPutString("\b \b");
                bytes_read --;
            }
            continue;
        }
        if (bytes_read >= CMD_STRING_SIZE )
        {
            SerialPutString("Command string size overflow\r\n");
            bytes_read = 0;
            continue;
        }
        if (c >= 0x20 && c <= 0x7E)
        {
            buffP[bytes_read++] = c;
            SerialPutChar(c);
        }

    }
    while (1);
    SerialPutString("\n\r");
    buffP[bytes_read] = '\0';
}

/*******************************************************************************
* Function Name  : FLASH_SectorMask
* Description    : Calculate the sectors mask
* Input          : - Size: The image size
* Output         : None
* Return         : The sectors mask
*******************************************************************************/
u32 FLASH_SectorMask(vu32 Size)
{
    if (Size <= 0x2000)
        return 0x2;
    if (Size <= 0x4000)
        return 0x6;
    if (Size <= 0x6000)
        return 0xE;
    if (Size <= 0xE000)
        return 0x1E;
    if (Size <= 0x1E000)
        return 0x3E;
    if (Size <= 0x2E000)
        return 0x7E;
    if (Size <= 0x3E000)
        return 0xFE;
    return 0;

}


/*******************************************************************************
* Function Name  : Main_Menu
* Description    : Display the  Main Menu on to HyperTerminal
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Main_Menu(void)
{
    u8 key = 0;


    while (1)
    {
        SerialPutString("\r\n================== Main Menu ============================\r\n\n");
#ifdef STR71x
        SerialPutString("  Download Image To the STR71x Internal Flash ---------- 1\r\n\n");
#endif


#ifdef STR73x
        SerialPutString("  Download Image To the STR73x Internal Flash ---------- 1\r\n\n");
#endif


#ifdef STR75x
        SerialPutString("  Download Image To the STR75x Internal Flash ---------- 1\r\n\n");
#endif



        SerialPutString("  Execute The New Program ------------------------------ 2\r\n\n");
        SerialPutString("==========================================================\r\n\n");

        key = GetKey();
        if (key == 0x31)
        {
            /* Download user application in the Flash */
            SerialDownload();

        }
        else if (key == 0x32)
        {
            /* Jump to the user program and execute it */

            pFunction Jump_To_Application;
            Jump_To_Application = (pFunction) ApplicationAddress;
            Jump_To_Application();

        }
        else
        {
            SerialPutString("Invalid Number ! ==> The number should be either 1 or 2\r\n");
        }
    } /* While(1)*/
}   /* Main_Menu */






/*******************(C)COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/


