/******************** (C) COPYRIGHT 2007 STMicroelectronics ***************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V2.0
* Date               : 12/06/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Define the RTC prescaler 0x7FFF to have 1 second basic clock */
#define RTC_Prescaler 0x7FFF 

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void SYS_INIT(void);
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY);
void GPIO_Configuration(void);
void EIC_Configuration(void);
void XTI_Configuration(void);
void Delay(u32 nCount);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{

  #ifdef DEBUG
  debug();
  #endif 

  /* System clocks configuration ---------------------------------------------*/
  SYS_INIT();
  /*  RCLK= MCLK = PCLK1 = PCLK2 = CLK2_16 = 500KHz */
  RCCU_RCLKSourceConfig (RCCU_CLOCK2_16);
  /* Disable PLL1 */
  RCCU_PLL1Disable();
    
  /* Enable GPIO0 and GPIO1 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph | GPIO1_Periph); 
  /* Enable EIC and XTI clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, EIC_Periph | XTI_Periph);

  /* Enable the CKOUT clock for debug purpose*/
  APB_ClockConfig (APB2, ENABLE, CKOUT_Periph);
 
   /* (RCLK = CK_AF) */
    RCCU_RCLKSourceConfig(RCCU_CK_AF);
    
  /* XTI Configuration */
   XTI_Configuration();

  /* EIC configuration */
   EIC_Configuration();

  /* GPIO Configuration */
   GPIO_Configuration(); 

#ifdef __LPWFI_CK2_16

   /* Set the MVR disabled, the FLASH in PWD mode during LP_WFI mode and 
      goes into LP_WFI mode with RCLK = CLK2_16 */
   PCU_LPModesConfig(DISABLE, DISABLE,DISABLE,ENABLE, LPWFI_CLK2_16);
  
#ifdef Wakeup_RTC 
  /* RTC configuration -------------------------------------------------------*/
  /* Enable RTC clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, RTC_Periph);
  /*  Configure RTC prescaler */
  RTC_PrescalerConfig(RTC_Prescaler);

  /* Clear Pending Flags */
  RTC_FlagClear(RTC_OWIR);
  RTC_FlagClear(RTC_AIR);
  RTC_FlagClear(RTC_SIR);
  RTC_FlagClear(RTC_GIR);
 
  /*  Enable Alarm Interrupt */
  RTC_ITConfig( RTC_AIT, ENABLE );
  RTC_ITConfig( RTC_GIT, ENABLE );

  /* Configure the first RTC Alarm */
  RTC_AlarmConfig(RTC_CounterValue() + 5);
  
  /* Congigure the EIC to acknowledg RTC interrupt */
  EIC_IRQChannelPriorityConfig(RTC_IRQChannel,1);
  EIC_IRQChannelConfig(RTC_IRQChannel,ENABLE);

#endif /* Wakeup_RTC */  
#endif /* LPWFI_CK2_16 */    

#ifdef __LPWFI_CK_AF
  
  /* Set the MVR disabled and the FLASH in PWD mode during LP_WFI mode and 
     goes into LP_WFI mode with RCLK = CK_AF = RTC clock */
   PCU_LPModesConfig(DISABLE, DISABLE, DISABLE, ENABLE, LPWFI_CK_AF);
 
   /* Stop the external oscillator using the GPIO pin (P0.10) */
    GPIO_BitWrite(GPIO0,10,0); 
    
#endif  /* LPWFI_CK_AF */
    
  while(1)
  {
    /* Toggle the P0.0 GPIO pin */
    GPIO_PinToggle(0,0xFFF);
    
    /* Enter LPWFI mode with RCLK = CLK2_16 */
    PCU_WFI();

   }
}

/*******************************************************************************
* Function Name  : GPIO_Configuration
* Description    : Configures the used I/O ports pins.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration(void)
{
  /* Configure  the P1.14 as input*/
  GPIO_Config (GPIO0 , 1<<14, GPIO_IN_TRI_TTL);
  
  /* Configure P0.0 in Output Push-Pull */
  GPIO_Config(GPIO0,1,GPIO_OUT_PP);
  GPIO_BitWrite(GPIO0,0,0);
  
  /* Configure P0.10 in Output Push-Pull */
  GPIO_BitWrite(GPIO0,10,1);
  GPIO_Config(GPIO0,1<<10,GPIO_OUT_PP);
  
  /* Configure the unused pin as Output Push-Pull */
  GPIO_Config(GPIO0, 0xFBFE ,GPIO_OUT_PP);
  GPIO_Config(GPIO1, 0xBFFF ,GPIO_OUT_PP);
  GPIO_WordWrite(GPIO0, 0x0000);
  GPIO_WordWrite(GPIO1, 0x0000);
}

/*******************************************************************************
* Function Name  : EIC_Configuration
* Description    : Configures the interrupt controller.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EIC_Configuration(void)
{
  /* Congigure the EIC to acknowledg XTI interrupt */
  EIC_IRQChannelPriorityConfig(XTI_IRQChannel,1);
  EIC_IRQChannelConfig(XTI_IRQChannel,ENABLE);

  /* Enable the IRQ */
  EIC_IRQConfig(ENABLE);  
}

/*******************************************************************************
* Function Name  : XTI_Configuration
* Description    : Configures the interrupt controller.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void XTI_Configuration(void)
{
  /* Configure XTI to generate interrupt on P1.14 */
  /* Initialize the XTI */
  XTI_Init(); 
  /* Configure the line 8, select Falling edge trigger */
  XTI_LineModeConfig(XTI_Line8,  XTI_FallingEdge);
  /* Enable line 8 Wake-Up interrupts */
  XTI_LineConfig(XTI_Line8, ENABLE);
  /* Enable Wake-Up mode in the XTI */
  XTI_ModeConfig(XTI_WakeUpInterrupt, ENABLE);  
}

/*******************************************************************************
* Function Name  : GPIO_PinToggle
* Description    : P0.0 toggling 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY)
{
  u8 counter = 10;

  while(counter)
  {
    GPIO_BitWrite (GPIO0, GPIO_PIN, 1);
    Delay(DELAY);
    GPIO_BitWrite (GPIO0, GPIO_PIN, 0);
    Delay(DELAY);
    counter--;
  } 
}

/*******************************************************************************
* Function Name  : SYS_INIT
* Description    : Initialize the system clock and IOs
* Input          : Delay value
* Output         : None
* Return         : None
*******************************************************************************/
void SYS_INIT(void)
{
  /* Set the PRCCU registers to their reset values( This is for debug purpose) */

  RCCU->CCR = 0;
  RCCU->CFR = 0x00008008;
  RCCU->PLL1CR = 0x00000007;
  PCU->PWRCR = 0x8000;

   /* Disable all peripheral on APB1 */
  APB_ClockConfig (APB1, DISABLE,  APB1_ALL_Periph);
    
   /* Disable all peripheral on APB2 */
  APB_ClockConfig (APB2, DISABLE, APB2_ALL_Periph);
  
  /* Stop the PLL2 */
  RCCU_PLL2Disable();

  /* Stop unused periph clocks in PRCCU_PER register for low power consumption */
  RCCU->PER &=~0x001F;
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(u32 nCount)
{
  for(; nCount!= 0;nCount--);
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/


