/******************** (C) COPYRIGHT 2007 STMicroelectronics ***************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V2.0
* Date               : 12/06/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void SYS_INIT(void);
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY);
void GPIO_Configuration(void);
void Delay(u32 nCount);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{

  #ifdef DEBUG
  debug();
  #endif 

  /* System clocks configuration ---------------------------------------------*/
  SYS_INIT();

  /* Enable GPIO0 and GPIO1 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph | GPIO1_Periph);
  /* Enable the CKOUT clock for debug purpose*/
  APB_ClockConfig (APB2, ENABLE, CKOUT_Periph); 
  
  /* GPIO Configuration */
   GPIO_Configuration();
    
   /* Select CLK2 as RCLK clock source */
    RCCU_RCLKSourceConfig(RCCU_CLOCK2);
    /* Disable PLL1 */
    RCCU_PLL1Disable();
    
    /* Toggle the P0.0 GPIO pin */
    GPIO_PinToggle(0,0x2FFFF);
    
#ifdef SlowMode_CLK2_16
  
    /* SLOW mode with RCLK = CLK2_16  */
    RCCU_RCLKSourceConfig(RCCU_CLOCK2_16);
    
#endif /* SlowMode_CLK2_16 */

#ifdef SlowMode_CK_AF

    /* SLOW mode with RCLK = CK_AF */
    RCCU_RCLKSourceConfig(RCCU_CK_AF);
    
#endif /* SlowMode_CK_AF */

#ifdef SlowMode_PLL1FreeRunning
      
    /* Configure the PLL in free runnign mode at 125*/
    RCCU_PLL1FreeRunningModeConfig(RCCU_PLL1FreeRunning125);
    /* Enter SLOW4 mode (RCLK = PLL1 out put) */
    RCCU_RCLKSourceConfig(RCCU_PLL1_Output);
    
#endif /* SlowMode_PLL1FreeRunning */
   
    /* Set the FLASH in LP mode */
    PCU_FlashBurstCmd(DISABLE);

    /* Disable MVREG */
    PCU_VRConfig (PCU_MVR,DISABLE);
    
  while(1)
  { 
    /* Toggle the P0.0 GPIO pin */
    GPIO_PinToggle(0,0x1FFF);
   }
}

/*******************************************************************************
* Function Name  : GPIO_Configuration
* Description    : Configures the used I/O ports pins.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration(void)
{
  /* Configure P0.0 in Output Push-Pull */
  GPIO_Config(GPIO0,1,GPIO_OUT_PP);
  GPIO_BitWrite(GPIO0,0,0);
  
  /* Configure the unused pin as Output Push-Pull */
  GPIO_Config(GPIO0, 0xFBFE ,GPIO_OUT_PP);
  GPIO_Config(GPIO1, 0xFFFF ,GPIO_OUT_PP);
  GPIO_WordWrite(GPIO0, 0x0000);
  GPIO_WordWrite(GPIO1, 0x0000);
}

/*******************************************************************************
* Function Name  : GPIO_PinToggle
* Description    : P0.0 toggling 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY)
{
  u8 counter = 10;

  while(counter)
  {
    GPIO_BitWrite (GPIO0, GPIO_PIN, 1);
    Delay(DELAY);
    GPIO_BitWrite (GPIO0, GPIO_PIN, 0);
    Delay(DELAY);
    counter--;
  } 
}

/*******************************************************************************
* Function Name  : SYS_INIT
* Description    : Initialize the system clock and IOs
* Input          : Delay value
* Output         : None
* Return         : None
*******************************************************************************/
void SYS_INIT(void)
{
  /* Set the PRCCU registers to theire reset values (This is for debug purpose) */
  RCCU->CCR = 0;
  RCCU->CFR = 0x00008008;
  RCCU->PLL1CR = 0x00000007;
  PCU->PWRCR = 0x8000;

  /* Disable all peripheral on APB1 */
  APB_ClockConfig (APB1, DISABLE,  APB1_ALL_Periph);
    
  /* Disable all peripheral on APB2 */
  APB_ClockConfig (APB2, DISABLE, APB2_ALL_Periph);
  
  /* Stop the PLL2 */
  RCCU_PLL2Disable();

  /* Stop unused periph clocks in PRCCU_PER register for low power consumption */
  RCCU->PER &=~0x001F;
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(u32 nCount)
{
  for(; nCount!= 0;nCount--);
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
