/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V2.0
* Date               : 12/06/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Define the RTC prescaler 0x7FFF to have 1 second basic clock */
#define RTC_Prescaler 0x7FFF 

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
void SYS_INIT(void);
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY);
void EIC_Configuration(void);
void Delay(u32 nCount);

/*******************************************************************************
* Function Name  : main
* Description    : main program.
* Input          : None.
* Return         : None.
*******************************************************************************/
int main (void)
{
  #ifdef DEBUG
    debug();
  #endif
 
  /* System clocks configuration ---------------------------------------------*/
  SYS_INIT();
  /* MCLK = PCLK1 = PCLK2 = 24MHz*/ 
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output as RCLK clock */
   RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;
   
  /* Enable RTC and EIC clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, RTC_Periph | EIC_Periph | GPIO0_Periph);
  /* Enable the CKOUT clock for debug purpose*/
  APB_ClockConfig (APB2, ENABLE, CKOUT_Periph);
  
  /* RTC configuration -------------------------------------------------------*/
  /*  Configure RTC prescaler */
  RTC_PrescalerConfig(RTC_Prescaler);

  /*  Clear Pending Flags */
  RTC_FlagClear(RTC_OWIR);
  RTC_FlagClear(RTC_AIR);
  RTC_FlagClear(RTC_SIR);
  RTC_FlagClear(RTC_GIR);
 
  /*  Enable Alarm Interrupt */
  RTC_ITConfig( RTC_AIT, ENABLE );
  RTC_ITConfig( RTC_GIT, ENABLE );

  /* Configure the first RTC Alarm */
  RTC_AlarmConfig(RTC_CounterValue() + 5);
  
  EIC_Configuration();
  
  /*  Configure Port 0 pins */
  GPIO_Config(GPIO0, 0xFFFF, GPIO_OUT_PP);
  GPIO0->PD = 0x0000;
  
   /* Toggle the P0.0 pin */
  GPIO_PinToggle(0,0x2FFFF);
  
  /* System goes into standby mode */ 
  PCU_STANDBY(); 
 }

/*******************************************************************************
* Function Name  : EIC_Configuration
* Description    : Configures the interrupt controller.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EIC_Configuration(void)
{
 /* Congigure the EIC to acknowledg XTI interrupt */
  EIC_IRQChannelPriorityConfig(RTC_IRQChannel,1);
  EIC_IRQChannelConfig(RTC_IRQChannel,ENABLE);
  
  /* Enable the IRQ */
  EIC_IRQConfig(ENABLE);  
}

/*******************************************************************************
* Function Name  : GPIO_PinToggle
* Description    : P0.0 toggling 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY)
{
  u8 counter = 20;

  while(counter)
  {
    GPIO_BitWrite (GPIO0, GPIO_PIN, 1);
    Delay(DELAY);
    GPIO_BitWrite (GPIO0, GPIO_PIN, 0);
    Delay(DELAY);
    counter--;
  } 
}

/*******************************************************************************
* Function Name  : SYS_INIT
* Description    : Initialize the system clock and IOs
* Input          : Delay value
* Output         : None
* Return         : None
*******************************************************************************/
void SYS_INIT(void)
{

 /* Set the PRCCU registers to theire reset values (This is for debug purpose) */

  RCCU->CCR = 0;
  RCCU->CFR = 0x00008008;
  RCCU->PLL1CR = 0x00000007;
  PCU->PWRCR = 0x8000;

  /* Disable all peripheral on APB1 */
  APB_ClockConfig (APB1, DISABLE,  APB1_ALL_Periph);
    
  /* Disable all peripheral on APB2 */
  APB_ClockConfig (APB2, DISABLE, APB2_ALL_Periph);
  
  /* Stop the PLL2 */
  RCCU_PLL2Disable();

  /* Stop unused periph clocks in PRCCU_PER register for low power consumption */
  RCCU->PER &=~0x001F;
  
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(u32 nCount)
{
  for(; nCount!= 0;nCount--);
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
