   1                     
   2                     ;***************** (c) 2006  STMicroelectronics, Inc. **********************
   3                     
   4                     ;**************************************************************************
   5                     ;     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR WITH INNER
   6                     ;                CURRENT LOOP
   7                     ;     COMPILER : COSMIC
   8                     ;     FILENAME : ASM.S 
   9                     ;     RELEASE  : 1.0
  10                     ;     DATE     : 3 Jan 2006
  11                     ;     AUTHOR   : Power Systems Application Lab
  12                     ;                STMicroelectronics, Inc.
  13                     ;                Schaumburg, IL - 60173
  14                     ;
  15                     ;***************************************************************************
  16                     
  17                     ;******************************************************************************
  18                     ; DISCLAIMER :
  19                     ; ===========
  20                     ; THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
  21                     ; SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
  22                     ; WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
  23                     ;******************************************************************************
  24                     
  25                     
  26                     ;        *****************************************************
  27                     ;        *  This file contains all asm macros and functions  *
  28                     ;        *   needed to implement pi regulators               *
  29                     ;        *****************************************************
  30                     
  31                     
  32                     ;MODIFICATIONS :
  33                     
  34                     ;******************************************************************************
  35                     
  36                     
  37                     ;***********************************************
  38                     ;*  Assembly macro for 16b variable assignment *
  39                     ;***********************************************
  40                     assign16:  macro  \in, \out
  41                            ld   a, \in
  42                            ld   \out, a
  43                            ld   a, \in + 1
  44                            ld   \out + 1, a
  45                     endm       
  46                     
  47                     ;***********************************************
  48                     ;*  Assembly macro to subtract two 16b numbers *
  49                     ;*    for comparison                           *
  50                     ;***********************************************
  51                     sub16temp:   macro   \in1, \in2
  52                            ld   a, \in1+1
  53                            sub  a, \in2+1
  54                            ld   a, \in1
  55                            sbc  a, \in2
  56                     endm
  57                     
  58                     ;*****************************************************
  59                     ;*  Assembly macro for subtracting two 16b numbers   *
  60                     ;*****************************************************
  61                     sub16:   macro   \in1, \in2, \out
  62                            ld  a, \in1+1
  63                            sub a, \in2+1
  64                            ld  \out+1, a
  65                            
  66                            ld  a, \in1
  67                            sbc a, \in2
  68                            ld  \out, a
  69                     endm
  70                     
  71                     ;***************************************************
  72                     ;*  Assembly macro for subtracting two 32b numbers *
  73                     ;***************************************************
  74                     sub32:   macro  \in1, \in2, \out
  75                         ld   A, \in1 + 3
  76                         sub  A, \in2 + 3
  77                         ld   \out + 3, A
  78                         
  79                         ld   A, \in1 + 2
  80                         sbc  A, \in2 + 2
  81                         ld   \out + 2, A
  82                         
  83                         ld   A, \in1 + 1
  84                         sbc  A, \in2 + 1
  85                         ld   \out + 1, A
  86                         
  87                         ld   A, \in1
  88                         sbc  A, \in2
  89                         ld   \out, A
  90                     endm    
  91                     
  92                     ;**********************************************
  93                     ;*  Assembly macro for adding two 32b numbers *
  94                     ;**********************************************
  95                     add32:   macro  \in1, \in2, \out
  96                         ld   A, \in1 + 3
  97                         add  A, \in2 + 3
  98                         ld   \out + 3, A
  99                         
 100                         ld   A, \in1 + 2
 101                         adc  A, \in2 + 2
 102                         ld   \out + 2, A
 103                         
 104                         ld   A, \in1 + 1
 105                         adc  A, \in2 + 1
 106                         ld   \out + 1, A
 107                         
 108                         ld   A, \in1
 109                         adc  A, \in2
 110                         ld   \out, A
 111                     endm    
 112                     
 113                     ;*********************************************************************
 114                     ;*  Assembly macro for multiplying SIGNED 16bit with UNSIGNED 16bit  *
 115                     ;*********************************************************************
 116                     mul_s16xu16:   macro    \s16, \u16, \product
 117                         ld   X, \s16 + 1                                           
 118                         ld   A, \u16 + 1                                        
 119                         mul  X, A                                                             
 120                         ld   \product + 3, A                                                
 121                         ld   \product + 2, X                                                
 122                         
 123                         ld   X, \s16                                               
 124                         ld   A, \u16
 125                         mul  X, A                                                             
 126                         ld   \product + 1, A                                                
 127                         ld   \product, X                                
 128                         
 129                         ld   X, \s16 + 1                       
 130                         ld   A, \u16                         
 131                         mul  X, A                                        
 132                         add  A, \product + 2                            
 133                         ld   \product + 2, A                            
 134                         ld   A, X                                        
 135                         adc  A, \product + 1                            
 136                         ld   \product + 1, A                            
 137                         ld   A, \product                                
 138                         adc  A, #0                                       
 139                         ld   \product, A                                
 140                         
 141                         ld   X, \s16                           
 142                         ld   A, \u16 + 1                      
 143                         mul  X, A                                        
 144                         add  A, \product + 2                            
 145                         ld   \product + 2, A                            
 146                         ld   A, X                                        
 147                         adc  A, \product + 1                            
 148                         ld   \product + 1, A                            
 149                         ld   A, \product                                
 150                         adc  A, #0                                       
 151                         ld   \product, A
 152                         
 153                     ; The following code performs a correction on the 'product' to
 154                     ; get signed multiplication result
 155                         ld   A, \s16                           
 156                         jrpl \@loop
 157                         sub16  \product, \u16, \product
 158                     \@loop:
 159                     endm
 160                     
 161                     ;*************************************************************************
 162                     ;*************************************************************************
 163                     ;  Assembly MACROs end here 
 164                     ;*************************************************************************
 165                     ;*************************************************************************
 166                     
 167                        xdef  _piconCur
 168                        xref  _currentRef
 169                        xref  _currentFb
 170                        xref  _curError
 171                        xref  _curErrorPrev
 172                        xref  _Kb_curLoop
 173                        xref  _Ka_curLoop
 174                        xref  _productCur
 175                        xref  _PIconCur
 176                        xref  _max_duty
 177                        xref  _min_duty
 178                        
 179                        xdef  _piconSpd
 180                        xref  _speedError
 181                        xref  _speedErrorPrev
 182                        xref  _Kb_spdLoop
 183                        xref  _Ka_spdLoop
 184                        xref  _productSpeed
 185                        xref  _PIconSpeed
 186                        xref  _maxCurRef
 187                        xref  _minCurRef
 188                        
 189                     ;*****************************************************************
 190                     ;  PI regulator for current loop
 191                     ;*****************************************************************
 192  0000               _piconCur:
 193                         ;curErrorPrev = curError;
 194                         assign16      _curError, _curErrorPrev
 195                         
 196                         ;curError = currentRef - currentFb;
 197                         sub16         _currentRef, _currentFb, _curError
 198                         
 199                         ; productCur = curError * Ka_curLoop
 200                         mul_s16xu16   _curError, _Ka_curLoop, _productCur
 201                         
 202                         ; PIconCur += productCur
 203                         add32         _PIconCur, _productCur, _PIconCur
 204                         
 205                         ; productCur = curErrorPrev * Kb_curLoop
 206                         mul_s16xu16   _curErrorPrev, _Kb_curLoop, _productCur
 207                         
 208                         ; PIconCur -= productCur
 209                         sub32         _PIconCur, _productCur, _PIconCur
 210                         
 211                         ; ===================================
 212                         ; Clamp on current controller output
 213                         ; ===================================
 214                         ; if (PIconCur.word.w1 > MAX_DUTY_CYCLE) 
 215                         sub16temp   _PIconCur,  _max_duty
 216  0144 2b0e              jrmi	check_min      
 217                           ; PIconCur.word.w1 = MAX_DUTY_CYCLE;
 218                           assign16 _max_duty, _PIconCur
 219  0152 201a                jp	clr_w0
 220                           
 221  0154               check_min:
 222                         ; else if ( PIconCur.word.w1 < MIN_DUTY_CYCLE )
 223                         sub16temp   _PIconCur,  _min_duty
 224  0160 2a13              jrpl	done      
 225                           ; PIconCur.word.w1 = MIN_DUTY_CYCLE;
 226                     	    assign16 _min_duty, _PIconCur
 227                           
 228  016e               clr_w0:
 229                           ; PIconCur.word.w0 = 0;
 230  016e 4f                  clr a
 231  016f c70002              ld	_PIconCur + 2, a
 232  0172 c70003              ld	_PIconCur + 3, a
 233                           
 234  0175               done:
 235  0175 81                  ret
 236                           
 237                     ;*****************************************************************
 238                     ;  PI regulator for speed loop
 239                     ;*****************************************************************
 240  0176               _piconSpd:
 241                         ;productSpeed = speedError * Ka_spdLoop
 242                         mul_s16xu16   _speedError, _Ka_spdLoop, _productSpeed
 243                         
 244                         ;PIconSpeed += productSpeed
 245                         add32    _PIconSpeed, _productSpeed, _PIconSpeed
 246                         
 247                         ;productSpeed = speedErrorPrev * Kb_spdLoop
 248                         mul_s16xu16  _speedErrorPrev, _Kb_spdLoop, _productSpeed
 249                         
 250                         ;PIconSpeed -= productSpeed
 251                         sub32    _PIconSpeed, _productSpeed, _PIconSpeed
 252                        
 253                         ; ================================
 254                         ; Clamp on Speed Controller output
 255                         ; ================================
 256                         ; if (PIconSpeed.word.w1 > MAX_CUR_REF) 
 257                         sub16temp   _PIconSpeed,  _maxCurRef
 258  029c 2b0e              jrmi	check_min2
 259                           ; PIconSpeed.word.w1 = MAX_CUR_REF;
 260                           assign16 _maxCurRef, _PIconSpeed
 261                           ; PIconSpeed.word.w0 = 0xffff;
 262  02aa 201a                jp	max_w0
 263                           
 264  02ac               check_min2:
 265                         ; else if ( PIconSpeed.word.w1 < MIN_CUR_REF )
 266                         sub16temp   _PIconSpeed,  _minCurRef
 267  02b8 2a14              jrpl	done2
 268                           ; PIconSpeed.word.w1 = MIN_CUR_REF;
 269                     	    assign16 _minCurRef, _PIconSpeed
 270  02c6               max_w0:
 271                           ; PIconSpeed.word.w0 = 0xffff;
 272  02c6 a6ff                ld   a, #255
 273  02c8 c70002              ld	_PIconSpeed + 2, a
 274  02cb c70003              ld	_PIconSpeed + 3, a
 275                           
 276  02ce               done2:
 277  02ce 81                  ret
 278                     ;*************************************************************************
 279                     ; Assembly code ends here
 280                     ;*************************************************************************
