   1                     ;/****************************************************
   2                     ;*  Assembly macro for subtracting two 16b numbers   *
   3                     ;****************************************************/
   4                     sub16:   macro   \in1, \in2, \out
   5                            ld  a, \in1+1
   6                            sub a, \in2+1
   7                            ld  \out+1, a
   8                            
   9                            ld  a, \in1
  10                            sbc a, \in2
  11                            ld  \out, a
  12                            
  13                            endm
  14                     ;/********************************************************************
  15                     ;*  Assembly macro for multiplying SIGNED 16bit with UNSIGNED 16bit  *
  16                     ;********************************************************************/
  17                     mul_s16xu16:   macro    \s16, \u16, \product
  18                         ld   X, \s16 + 1                                           
  19                         ld   A, \u16 + 1                                        
  20                         mul  X, A                                                             
  21                         ld   \product + 3, A                                                
  22                         ld   \product + 2, X                                                
  23                         
  24                         ld   X, \s16                                               
  25                         ld   A, \u16
  26                         mul  X, A                                                             
  27                         ld   \product + 1, A                                                
  28                         ld   \product, X                                
  29                         
  30                         ld   X, \s16 + 1                       
  31                         ld   A, \u16                         
  32                         mul  X, A                                        
  33                         add  A, \product + 2                            
  34                         ld   \product + 2, A                            
  35                         ld   A, X                                        
  36                         adc  A, \product + 1                            
  37                         ld   \product + 1, A                            
  38                         ld   A, \product                                
  39                         adc  A, #0                                       
  40                         ld   \product, A                                
  41                         
  42                         ld   X, \s16                           
  43                         ld   A, \u16 + 1                      
  44                         mul  X, A                                        
  45                         add  A, \product + 2                            
  46                         ld   \product + 2, A                            
  47                         ld   A, X                                        
  48                         adc  A, \product + 1                            
  49                         ld   \product + 1, A                            
  50                         ld   A, \product                                
  51                         adc  A, #0                                       
  52                         ld   \product, A
  53                         
  54                     ; The following code performs a correction on the 'product' to
  55                     ; get signed multiplication result
  56                         ld   A, \s16                           
  57                         jrpl \@loop                                       
  58                         ld   A, \product + 1                            
  59                         sub  A, \u16 + 1                      
  60                         ld   \product + 1, A                            
  61                         ld   A, \product                                
  62                         sbc  A, \u16                         
  63                         ld   \product, A                                
  64                     \@loop:
  65                        endm
  66                     
  67                     ;/*********************************************
  68                     ;*  Assembly macro for adding two 32b numbers *
  69                     ;*********************************************/
  70                     add32:   macro  \in1, \in2, \out
  71                         ld   A, \in1 + 3
  72                         add  A, \in2 + 3
  73                         ld   \out + 3, A
  74                         
  75                         ld   A, \in1 + 2
  76                         adc  A, \in2 + 2
  77                         ld   \out + 2, A
  78                         
  79                         ld   A, \in1 + 1
  80                         adc  A, \in2 + 1
  81                         ld   \out + 1, A
  82                         
  83                         ld   A, \in1
  84                         adc  A, \in2
  85                         ld   \out, A
  86                     
  87                         endm    
  88                     
  89                     ;/**************************************************
  90                     ;*  Assembly macro for subtracting two 32b numbers *
  91                     ;**************************************************/
  92                     sub32:   macro  \in1, \in2, \out
  93                         ld   A, \in1 + 3
  94                         sub  A, \in2 + 3
  95                         ld   \out + 3, A
  96                         
  97                         ld   A, \in1 + 2
  98                         sbc  A, \in2 + 2
  99                         ld   \out + 2, A
 100                         
 101                         ld   A, \in1 + 1
 102                         sbc  A, \in2 + 1
 103                         ld   \out + 1, A
 104                         
 105                         ld   A, \in1
 106                         sbc  A, \in2
 107                         ld   \out, A
 108                     
 109                         endm    
 110                     
 111                     ;/**************************************************
 112                     sub16temp:   macro   \in1, \in2
 113                            ld   a, \in1+1
 114                            sub  a, \in2+1
 115                            ld   a, \in1
 116                            sbc  a, \in2
 117                     endm
 118                     
 119                     ;/**************************************************
 120                     assign16:  macro  \in, \out
 121                            ld   a, \in
 122                            ld   \out, a
 123                            ld   a, \in + 1
 124                            ld   \out + 1, a
 125                     endm       
 126                     
 127                     ;/**************************************************
 128                        xdef  _piconCur
 129                        xref  _currentRef
 130                        xref  _currentFb
 131                        xref  _curError
 132                        xref  _curErrorPrev
 133                        xref  _Kb_curLoop
 134                        xref  _Ka_curLoop
 135                        xref  _productCur
 136                        xref  _PIconCur
 137                        xref  _max_duty
 138                        xref  _min_duty
 139                        
 140  0000               _piconCur:
 141                         ;curErrorPrev = curError;
 142                         assign16      _curError, _curErrorPrev
 143                         
 144                         ;curError = currentRef - currentFb;
 145                         sub16         _currentRef, _currentFb, _curError
 146                         
 147                         ; productCur = curError * Ka_curLoop
 148                         mul_s16xu16   _curError, _Ka_curLoop, _productCur
 149                         
 150                         ; PIconCur += productCur
 151                         add32         _PIconCur, _productCur, _PIconCur
 152                         
 153                         ; productCur = curErrorPrev * Kb_curLoop
 154                         mul_s16xu16   _curErrorPrev, _Kb_curLoop, _productCur
 155                         
 156                         ; PIconCur -= productCur
 157                         sub32         _PIconCur, _productCur, _PIconCur
 158                         
 159                         ; Clamp on current controller output
 160                         ; if (PIconCur.word.w1 > MAX_DUTY_CYCLE) 
 161                         sub16temp   _PIconCur,  _max_duty
 162  0144 2b0e              jrmi	check_min      
 163                           ; PIconCur.word.w1 = MAX_DUTY_CYCLE;
 164                           assign16 _max_duty, _PIconCur
 165  0152 201a                jp	clr_w0
 166                           
 167  0154               check_min:
 168                         ; else if ( PIconCur.word.w1 < MIN_DUTY_CYCLE )
 169                         sub16temp   _PIconCur,  _min_duty
 170  0160 2a13              jrpl	done      
 171                           ; PIconCur.word.w1 = MIN_DUTY_CYCLE;
 172                     	    assign16 _min_duty, _PIconCur
 173                           
 174  016e               clr_w0:
 175                           ; PIconCur.word.w0 = 0;
 176  016e 4f                  clr a
 177  016f c70002              ld	_PIconCur + 2, a
 178  0172 c70003              ld	_PIconCur + 3, a
 179                           
 180  0175               done:
 181  0175 81                  ret
 182                     ;/**************************************************
 183                     
