
;***************** (c) 2006  STMicroelectronics, Inc. **********************

;**************************************************************************
;     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR WITH INNER
;                CURRENT LOOP
;     COMPILER : COSMIC
;     FILENAME : ASM.S 
;     RELEASE  : 1.0
;     DATE     : 3 Jan 2006
;     AUTHOR   : Power Systems Application Lab
;                STMicroelectronics, Inc.
;                Schaumburg, IL - 60173
;
;***************************************************************************

;******************************************************************************
; DISCLAIMER :
; ===========
; THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
; SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
; WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
;******************************************************************************


;        *****************************************************
;        *  This file contains all asm macros and functions  *
;        *   needed to implement pi regulators               *
;        *****************************************************


;MODIFICATIONS :

;******************************************************************************


;***********************************************
;*  Assembly macro for 16b variable assignment *
;***********************************************
assign16:  macro  \in, \out
       ld   a, \in
       ld   \out, a
       ld   a, \in + 1
       ld   \out + 1, a
endm       

;***********************************************
;*  Assembly macro to subtract two 16b numbers *
;*    for comparison                           *
;***********************************************
sub16temp:   macro   \in1, \in2
       ld   a, \in1+1
       sub  a, \in2+1
       ld   a, \in1
       sbc  a, \in2
endm

;*****************************************************
;*  Assembly macro for subtracting two 16b numbers   *
;*****************************************************
sub16:   macro   \in1, \in2, \out
       ld  a, \in1+1
       sub a, \in2+1
       ld  \out+1, a
       
       ld  a, \in1
       sbc a, \in2
       ld  \out, a
endm

;***************************************************
;*  Assembly macro for subtracting two 32b numbers *
;***************************************************
sub32:   macro  \in1, \in2, \out
    ld   A, \in1 + 3
    sub  A, \in2 + 3
    ld   \out + 3, A
    
    ld   A, \in1 + 2
    sbc  A, \in2 + 2
    ld   \out + 2, A
    
    ld   A, \in1 + 1
    sbc  A, \in2 + 1
    ld   \out + 1, A
    
    ld   A, \in1
    sbc  A, \in2
    ld   \out, A
endm    

;**********************************************
;*  Assembly macro for adding two 32b numbers *
;**********************************************
add32:   macro  \in1, \in2, \out
    ld   A, \in1 + 3
    add  A, \in2 + 3
    ld   \out + 3, A
    
    ld   A, \in1 + 2
    adc  A, \in2 + 2
    ld   \out + 2, A
    
    ld   A, \in1 + 1
    adc  A, \in2 + 1
    ld   \out + 1, A
    
    ld   A, \in1
    adc  A, \in2
    ld   \out, A
endm    

;*********************************************************************
;*  Assembly macro for multiplying SIGNED 16bit with UNSIGNED 16bit  *
;*********************************************************************
mul_s16xu16:   macro    \s16, \u16, \product
    ld   X, \s16 + 1                                           
    ld   A, \u16 + 1                                        
    mul  X, A                                                             
    ld   \product + 3, A                                                
    ld   \product + 2, X                                                
    
    ld   X, \s16                                               
    ld   A, \u16
    mul  X, A                                                             
    ld   \product + 1, A                                                
    ld   \product, X                                
    
    ld   X, \s16 + 1                       
    ld   A, \u16                         
    mul  X, A                                        
    add  A, \product + 2                            
    ld   \product + 2, A                            
    ld   A, X                                        
    adc  A, \product + 1                            
    ld   \product + 1, A                            
    ld   A, \product                                
    adc  A, #0                                       
    ld   \product, A                                
    
    ld   X, \s16                           
    ld   A, \u16 + 1                      
    mul  X, A                                        
    add  A, \product + 2                            
    ld   \product + 2, A                            
    ld   A, X                                        
    adc  A, \product + 1                            
    ld   \product + 1, A                            
    ld   A, \product                                
    adc  A, #0                                       
    ld   \product, A
    
; The following code performs a correction on the 'product' to
; get signed multiplication result
    ld   A, \s16                           
    jrpl \@loop
    sub16  \product, \u16, \product
\@loop:
endm

;*************************************************************************
;*************************************************************************
;  Assembly MACROs end here 
;*************************************************************************
;*************************************************************************

   xdef  _piconCur
   xref  _currentRef
   xref  _currentFb
   xref  _curError
   xref  _curErrorPrev
   xref  _Kb_curLoop
   xref  _Ka_curLoop
   xref  _productCur
   xref  _PIconCur
   xref  _max_duty
   xref  _min_duty
   
   xdef  _piconSpd
   xref  _speedError
   xref  _speedErrorPrev
   xref  _Kb_spdLoop
   xref  _Ka_spdLoop
   xref  _productSpeed
   xref  _PIconSpeed
   xref  _maxCurRef
   xref  _minCurRef
   
;*****************************************************************
;  PI regulator for current loop
;*****************************************************************
_piconCur:
    ;curErrorPrev = curError;
    assign16      _curError, _curErrorPrev
    
    ;curError = currentRef - currentFb;
    sub16         _currentRef, _currentFb, _curError
    
    ; productCur = curError * Ka_curLoop
    mul_s16xu16   _curError, _Ka_curLoop, _productCur
    
    ; PIconCur += productCur
    add32         _PIconCur, _productCur, _PIconCur
    
    ; productCur = curErrorPrev * Kb_curLoop
    mul_s16xu16   _curErrorPrev, _Kb_curLoop, _productCur
    
    ; PIconCur -= productCur
    sub32         _PIconCur, _productCur, _PIconCur
    
    ; ===================================
    ; Clamp on current controller output
    ; ===================================
    ; if (PIconCur.word.w1 > MAX_DUTY_CYCLE) 
    sub16temp   _PIconCur,  _max_duty
    jrmi	check_min      
      ; PIconCur.word.w1 = MAX_DUTY_CYCLE;
      assign16 _max_duty, _PIconCur
      jp	clr_w0
      
check_min:
    ; else if ( PIconCur.word.w1 < MIN_DUTY_CYCLE )
    sub16temp   _PIconCur,  _min_duty
    jrpl	done      
      ; PIconCur.word.w1 = MIN_DUTY_CYCLE;
	    assign16 _min_duty, _PIconCur
      
clr_w0:
      ; PIconCur.word.w0 = 0;
      clr a
      ld	_PIconCur + 2, a
      ld	_PIconCur + 3, a
      
done:
      ret
      
;*****************************************************************
;  PI regulator for speed loop
;*****************************************************************
_piconSpd:
    ;productSpeed = speedError * Ka_spdLoop
    mul_s16xu16   _speedError, _Ka_spdLoop, _productSpeed
    
    ;PIconSpeed += productSpeed
    add32    _PIconSpeed, _productSpeed, _PIconSpeed
    
    ;productSpeed = speedErrorPrev * Kb_spdLoop
    mul_s16xu16  _speedErrorPrev, _Kb_spdLoop, _productSpeed
    
    ;PIconSpeed -= productSpeed
    sub32    _PIconSpeed, _productSpeed, _PIconSpeed
   
    ; ================================
    ; Clamp on Speed Controller output
    ; ================================
    ; if (PIconSpeed.word.w1 > MAX_CUR_REF) 
    sub16temp   _PIconSpeed,  _maxCurRef
    jrmi	check_min2
      ; PIconSpeed.word.w1 = MAX_CUR_REF;
      assign16 _maxCurRef, _PIconSpeed
      ; PIconSpeed.word.w0 = 0xffff;
      jp	max_w0
      
check_min2:
    ; else if ( PIconSpeed.word.w1 < MIN_CUR_REF )
    sub16temp   _PIconSpeed,  _minCurRef
    jrpl	done2
      ; PIconSpeed.word.w1 = MIN_CUR_REF;
	    assign16 _minCurRef, _PIconSpeed
max_w0:
      ; PIconSpeed.word.w0 = 0xffff;
      ld   a, #255
      ld	_PIconSpeed + 2, a
      ld	_PIconSpeed + 3, a
      
done2:
      ret
;*************************************************************************
; Assembly code ends here
;*************************************************************************
