
/***************** (c) 2006  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR WITH INNER
                CURRENT LOOP
     COMPILER : COSMIC
     FILENAME : MAIN.C
     RELEASE  : 1.0
     DATE     : 3 Jan 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173

***************************************************************************

 DISCLAIMER :
 ============
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
***************************************************************************


      ************************************************
      *   This file contains                         *
      *      - main() function definition            *
      ************************************************


MODIFICATIONS :

/******************************************************************************
******************************************************************************/

#define _MAIN_C

#include "include.inc"

extern u8
      key1count,
      flag,
      starting_failed;

extern sQUAD_8
      PIconCur,
      PIconSpeed;

extern s16
      currentRef,
      speedRef;
/************************************************************************
*************************************************************************/



   /********************************************/
   /*************  MAIN FUNCTION   *************/
   /********************************************/
void main(void) {

uDOUBLE_8  uTEMP;

  sim();
  wait_1ms(10);

  /*****************************
  *** Test pins  ***************
  ******************************/
  bitSet(PEDDR, BIT(3));
  bitSet(PEOR, BIT(3));

  bitSet(PCDDR, BIT(5));
  bitSet(PCOR, BIT(5));

  // internal OPAM
  OACSR = 00;    // OAON = 0/1;  opamp disable/enable
  // OPAM settings
  wait_1ms(10);
  OACSR  = OAON;
  wait_1ms(20);
  OACSR = OAON + OFFCMP + AVGCMP;
  wait_1ms(20);
  //OACSR = HIGHGAIN + OAON + OFFCMP + AVGCMP;
  while ( !( OACSR & CMPOVR) );

  // Software Interrupt priority settings
  ITSPR0 = ITSPR0_init;
  ITSPR1 = ITSPR1_init;
  ITSPR2 = ITSPR2_init;
  ITSPR3 = ITSPR3_init;

  // Watch dog reg setup
  WWDGWR = 0x7f;
  WWDGCR = 0x7f;     // Watch dog disabled

  // Master clk ctrl register
  MCCSR = 0x02;      /* Enable timer interrupt */

  rim();

  //***** System variables initialisation starts here *****
  flag = starting_failed = 0;
  //***** System variables initialisation ends here *****

  while(1) {
    speedFb_Cal();
#if OPEN_LOOP
    /********************************/
    /*  Open Loop code starts here  */
    /********************************/
    if (flag) {
      start_from_zero();
      while (flag) {
        getADC_10bit (uTEMP.word, RV3_CHANNEL);
        uTEMP.word = uTEMP.word << 3;
        MCPUL = uTEMP.byte.b0;
        MCPUH = uTEMP.byte.b1;
        speedFb_Cal();              // speed feedback calculation
        if (starting_failed == 0)
          break;
      }
    } else {
      MCsoft_reset();
    }
    /*  Open Loop code ends here  */
#else
    /**********************************/
    /*  Closed Loop code starts here  */
    /**********************************/
    if (flag) {
      current_loop_init();
      while (flag) {
        speedFb_Cal();        // speed feedback calculation
        if (starting_failed == 0)  {
          MCsoft_reset();
          currentRef = PIconCur.dw = PIconSpeed.dw = 0;
          break;
        }
      }
    } else {
      MCsoft_reset();
      currentRef = PIconCur.dw = PIconSpeed.dw = 0;
    }
    /*  Closed Loop code ends here  */
#endif
  }

  return;
}
/************************************************************************/
/********** Program Ends Here *******************************************/
/************************************************************************/
