
/***************** (c) 2006  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR WITH INNER
                CURRENT LOOP
     COMPILER : COSMIC
     FILENAME : MISC.C
     RELEASE  : 1.0
     DATE     : 3 Jan 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173

***************************************************************************

 DISCLAIMER :
 ============
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
***************************************************************************


      *******************************************************
      *   This file contains                                *
      *      - all miscellaneous function definitions       *
      *        such as delay modules                        *
      *******************************************************

MODIFICATIONS :

*****************************************************************************/

#define  _MISC_C

#include "include.inc"

/*************************
 delay loop for 50uS
**************************/
void wait_50us(void)  {
u8 count=0;

    while (++count <= 45)
     ;
    return;
}

/*************************
 delay loop for 100uS
**************************/
void wait_100us(void)  {
u8 count=0;

    while (++count <= 93)
     ;
    return;
}

/*************************
 delay loop for 1mS
**************************/
void wait_1ms(u16 count_ms)  {
u8 count_100us;

    while (count_ms--) {
      count_100us = 0;
      while (++count_100us <= 10)
        wait_100us();
    }
    return;
}

/****************************************************************************/
