
/***************** (c) 2006  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR WITH INNER
                CURRENT LOOP
     COMPILER : COSMIC
     FILENAME : PARAMETERS.H
     RELEASE  : 1.0
     DATE     : 3 Jan 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173

***************************************************************************

 DISCLAIMER :
 ============
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
***************************************************************************


    ****************************************************************
    *  This file contains all system parameters                    *
    *  such as                                                     *
               - dead time
               - D event sanity control settings
               - Z event sanity control settings
               - Over current event sanity control settings
               - Z,C and D debug and PWM output control settings
               - D, Z sampling clock control settings
               - BEMF comparator ref control settings
               - Z sampling control settings
                  - at end of PWM off
                  - at high freq (with or without delay)
                  - delay control settings, when Z sampling at on
               - MC peripheral clock freq control settings
    ****************************************************************


MODIFICATIONS :

******************************************************************************/

#ifndef   _PARAMETERS_H
#define   _PARAMETERS_H

#ifndef   _ST72MC_H
#include  "st72mc.h"
#endif

/**************************************************************************/
/**************************************************************************/

#define   OPEN_LOOP   0
#define   CUR_LOOP    1
#define   SPEED_LOOP  1


#define   NULL                  0x00
#define   DEBOUNCE_TIME_COUNT   50

/*Parameters for Motor Controller
***********************************/
#define  Minbemf_SL      4      /* minimum number of consecutive Z events to
                                   pass over to autoswitch commutation */
#define  Val_Z_read     12      /* number of step in synchronous mode before
                                   sampling for Z event  */
#define  Carrier_mag    0x1ff   /* Carrier magnitude */
#define  start_duty     (10*4)  /* duty cycle at start of alignment */
#define  n_align_step   25      /* number of step in aligment phase */
#define  duty_ramp      (1*4)   /* current ramping in alignment phase  */

#define  start_ki       128     /* Delay Coeffiecient at start */
#define  delay_ki       80      /* Delay Coeffiecient at run */
#define  Z_select       0       /* Select previous(0) or current(1) ZCD */



  /*************************************************
        PI Controller Implementation Notes
  **************************************************

      Vo(s)          Ki
      ----- =  Kp +  --
      Vi(s)          s


               Ki   [        Kp ]
            =  -- . |1  + s  -- |
                s   |        Ki |
                    -          -
      If stator electric time constant is 2mS (say)
        kp
        -- = 0.002 ,  or,  kp = 0.002 x ki
        ki

      If gain is chosen as 100,
        then,
            ki = 100
            kp = 0.2

  *******************************************************/


/*********************************
 SPEED PI CONTROLLER PARAMETERS
*********************************/
   //================================
   // Parameters from ST72141 code
   //================================
   //  Kp     0.96
   //  KiTs   0.04
   //
   // Current parameters
   //  Kp     0.96  << 3
   //  KiTs   0.006 << 3
   //================================
#define   SPEED_LOOP_TIME_CONSTANT    0.32
#define   SPEED_LOOP_PICON_GAIN       3
#define   Ts_spdLoop                  0.002    /* sampling time in Seconds */
#define   SPEED_PI_SCALE              3

#define   Ki_spdLoop     SPEED_LOOP_PICON_GAIN
#define   Kp_spdLoop     ( SPEED_LOOP_PICON_GAIN * SPEED_LOOP_TIME_CONSTANT )

#define   SPEED_SCALE        4
#define   SPEED_REF_MAX      (200*SPEED_SCALE)    /* in electrical Hz */
#define   SPEED_FB_MAX       (250*SPEED_SCALE)    /* in electrical Hz */
#define   MAX_CURRENT_REF    0x3ff
#define   MIN_CURRENT_REF    0

/****************************************
 CURRENT LOOP PI CONTROLLER PARAMETERS
****************************************/
#define   STATOR_TIME_CONSTANT      0.00
#define   CURRENT_LOOP_PICON_GAIN   50
#define   Ts_curLoop                0.0005     /* sampling time in Seconds */
#define   CURRENT_FB_SCALE          1

#define   Ki_curLoop          CURRENT_LOOP_PICON_GAIN
#define   Kp_curLoop         ( CURRENT_LOOP_PICON_GAIN * STATOR_TIME_CONSTANT )

#define   MAX_DUTY_CYCLE     ((Carrier_mag + 1) << 3)
#define   MIN_DUTY_CYCLE     (0.08*MAX_DUTY_CYCLE)
/**************************************************************************/
/**************************************************************************/

/* dead time parameters
************************/
#define  NO_DEAD_TIME        0
//#define  DEAD_TIME           (DTE + ...)   /* identify value based on req */

#define  DEAD_TIME_SETTING   NO_DEAD_TIME
#define  MDTG_init           DEAD_TIME_SETTING
/**************************************************************************/
/**************************************************************************/
/* D event control general definitions
***************************************/
#define  D_blank_5us      0
#define  D_blank_10us     1
#define  D_blank_15us     2
#define  D_blank_20us     3
#define  D_blank_25us     4
#define  D_blank_30us     5
#define  D_blank_35us     6
#define  D_blank_40us     7
#define  D_blank_60us     8
#define  D_blank_80us     9
#define  D_blank_100us   10
#define  D_blank_120us   11
#define  D_blank_140us   12
#define  D_blank_160us   13
#define  D_blank_180us   14
#define  D_blank_200us   15

/* D event control settings
*****************************/
#define  D_blank_window   D_blank_20us
#define  D_event_samples  4              /* from 1 to 16  */

#define  MDFR_init  ( ((D_event_samples - 1) * 0x10) + D_blank_window )

/**************************************************************************/
/**************************************************************************/
/* Z event control general definitions
****************************************/
#define  Z_blank_5us      0
#define  Z_blank_10us     1
#define  Z_blank_15us     2
#define  Z_blank_20us     3
#define  Z_blank_25us     4
#define  Z_blank_30us     5
#define  Z_blank_35us     6
#define  Z_blank_40us     7
#define  Z_blank_60us     8
#define  Z_blank_80us     9
#define  Z_blank_100us   10
#define  Z_blank_120us   11
#define  Z_blank_140us   12
#define  Z_blank_160us   13
#define  Z_blank_180us   14
#define  Z_blank_200us   15

/* Z event control settings
*****************************/
#define  Z_blank_window   Z_blank_20us
#define  Z_event_samples  1               /* from 1 to 16  */

#define  MZFR_init  ( ((Z_event_samples - 1) * 0x10) + Z_blank_window )

/**************************************************************************/
/**************************************************************************/
/* Over current event control general definitions
**************************************************/
#define  Current_blank_OFF      0
#define  Current_blank_0_5us    1
#define  Current_blank_1_0us    2
#define  Current_blank_1_5us    3
#define  Current_blank_2_0us    4
#define  Current_blank_2_5us    5
#define  Current_blank_3_0us    6
#define  Current_blank_3_5us    7

/* Over current event control settings
****************************************/
#define  Current_blank_window           Current_blank_3_0us
#define  Over_Current_event_samples     5

#define  MCFR_init   ( ((Over_Current_event_samples - 1) * 0x8) + \
                        Current_blank_window )

/**************************************************************************/
/**************************************************************************/
/* PWM output and debug (Z, C, D) general definitions
******************************************************/
#define  DEBUG_ON          DG
#define  DEBUG_OFF         0

#define  CONNECT_PWMU      PWMU
#define  CONNECT_PWMV      PWMV
#define  CONNECT_PWMW      PWMW
#define  DISCONNECT_PWMU   0
#define  DISCONNECT_PWMV   0
#define  DISCONNECT_PWMW   0

/* PWM output and debug (Z, C, D) settings
*******************************************/
#define  DEBUG_MODE        DEBUG_ON
#define  PWMU_TO_PIN       DISCONNECT_PWMU
#define  PWMV_TO_PIN       CONNECT_PWMV
#define  PWMW_TO_PIN       DISCONNECT_PWMW

#define  MPWME_init        (DEBUG_ON +    \
                            PWMU_TO_PIN + \
                            PWMV_TO_PIN + \
                            PWMW_TO_PIN)

/**************************************************************************/
/**************************************************************************/
/* PWM control general definitions
************************************/
// PWM clock freq
#define  Fmtc_div_1   0
#define  Fmtc_div_2   1
#define  Fmtc_div_3   2
#define  Fmtc_div_4   3
#define  Fmtc_div_5   4
#define  Fmtc_div_6   5
#define  Fmtc_div_7   6
#define  Fmtc_div_8   7

// PWM counter mode
#define  EDGE_ALIGNED    0
#define  CENTER_ALIGNED  CMS

// PWM resolution
#define  bit16  0
#define  bit8   PMS

/* PWM control settings
**************************/
#define  PWM_clk_freq       Fmtc_div_1
#define  PWM_counter_mode   CENTER_ALIGNED
#define  PWM_bit_size       bit16

#define  MPCR_init   ( PWM_clk_freq + PWM_counter_mode + PWM_bit_size)

/**************************************************************************/
/**************************************************************************/
/*  D and Z sampling clock general definitions
************************************************/
#define   Sampling_1MHz     0
#define   Sampling_500KHz   SCF0
#define   Sampling_250KHz   SCF1
#define   Sampling_125KHz   (SCF0 + SCF1)

#define   Sampling_OFF      0
#define   Sampling_ON       ZSV

#define   Gnd_unused_MCIx     0
#define   Float_unused_MCIx   DISS

/*  D and Z sampling clock settings
*************************************/
#define   Sampling_clk                 Sampling_250KHz
#define   Sampling_when_MOE_is_RESET   Sampling_ON
#define   Unused_MCIx                  Float_unused_MCIx

#define  MSCR_init          (Sampling_when_MOE_is_RESET + \
                             Sampling_clk + \
                             Unused_MCIx)

/**************************************************************************/
/**************************************************************************/
/* BEMZ comparator reference - general defintions
***************************************************/
#define   ref_0_2V   0
#define   ref_0_6V   1
#define   ref_1_0V   2
#define   ref_1_5V   3
#define   ref_2_0V   4
#define   ref_2_5V   5
#define   ref_3_5V   6
#define   ref_ext    7

/* Z sampling definitions
***************************/
#define  End_of_PWM_off   0
#define  Sample_at_SCF    SPLG

/* MCRC settings
******************/
#define  MCRC_low_duty_cycle   (HZ + End_of_PWM_off + ref_0_2V)
#define  MCRC_high_duty_cycle  (HZ + Sample_at_SCF  + ref_ext)

/**************************************************************************/
/**************************************************************************/
/* Delay for sampling at Ton - reference definitions
*******************************************************/
#define  No_delay       (0*0x10)
#define  Delay2_5us     (1*0x10)
#define  Delay5_0us     (2*0x10)
#define  Delay7_5us     (3*0x10)
#define  Delay10_0us    (4*0x10)
#define  Delay12_5us    (5*0x10)
#define  Delay15_0us    (6*0x10)
#define  Delay17_5us    (7*0x10)
#define  Delay20_0us    (8*0x10)
#define  Delay22_5us    (9*0x10)
#define  Delay25_0us   (10*0x10)
#define  Delay27_5us   (11*0x10)
#define  Delay30_0us   (12*0x10)
#define  Delay32_5us   (13*0x10)
#define  Delay35_0us   (14*0x10)
#define  Delay37_5us   (15*0x10)

/* Delay for sampling at Ton - setting
***************************************/
#define  Ton_sample_delay   (Delay10_0us)

/* MC Peripheral frequency definitions
*****************************************/
#define  Fmtc        0
#define  Fmtc_by_2   XT8
#define  Fmtc_by_4   XT16

/* MC Peripheral frequency setting
************************************/
#define  MC_Peri_freq    (Fmtc_by_4)

#define  MCONF_init      MC_Peri_freq

/**************************************************************************/
/**************************************************************************/
/* OPAM input setting definitions
**********************************/
#define   OPAMP_in_OAZ     0
#define   OPAMP_in_MCCFI   CFAV

/* OPAM input control setting
*******************************/
#define   OPAMP_INPUT      OPAMP_in_OAZ

/* Chopper definitions
************************/
/* Chopping control defintions
********************************/
#define   CHOPPING_OFF     0
#define   CHOP_ODD         HFE0
#define   CHOP_EVEN        HFE1
#define   CHOP_BOTH        (HFE1 + HFE0)

/* Chopping control settings
********************************/
#define   CHOPPING   CHOPPING_OFF

// chopping freq definitions at Fmtc = 8MHz (or) 16MHz
#define  CHOP_FREQ_100KHz_AT_FMTC_8MHZ     0
#define  CHOP_FREQ_200KHz_AT_FMTC_8MHZ     1
#define  CHOP_FREQ_400KHz_AT_FMTC_8MHZ     2
#define  CHOP_FREQ_500KHz_AT_FMTC_8MHZ     3
#define  CHOP_FREQ_800KHz_AT_FMTC_8MHZ     4
#define  CHOP_FREQ_1000KHz_AT_FMTC_8MHZ    5
#define  CHOP_FREQ_1330KHz_AT_FMTC_8MHZ    6
#define  CHOP_FREQ_2000KHz_AT_FMTC_8MHZ    7

// chopping freq definitions at Fmtc = 4MHz
#define  CHOP_FREQ_50KHz_AT_FMTC_4MHZ      0
#define  CHOP_FREQ_100KHz_AT_FMTC_4MHZ     1
#define  CHOP_FREQ_200KHz_AT_FMTC_4MHZ     2
#define  CHOP_FREQ_250KHz_AT_FMTC_4MHZ     3
#define  CHOP_FREQ_400KHz_AT_FMTC_4MHZ     4
#define  CHOP_FREQ_500KHz_AT_FMTC_4MHZ     5
#define  CHOP_FREQ_666KHz_AT_FMTC_4MHZ     6
#define  CHOP_FREQ_1000KHz_AT_FMTC_4MHZ    7

/* Chopper frequency settings
*******************************/
#define  CHOP_FREQ   NULL

#define  MREF_init   (OPAMP_INPUT + CHOPPING + CHOP_FREQ)
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

/* Auto reload timer definitions
**********************************/
// clock source for ART
#define  ART_CLK_EXT    EXCL
#define  ART_CLK_CPU    0

// clock freq for ART
#define  ART8_FREQ_8MHz      0
#define  ART8_FREQ_4MHz      CC0_ART8
#define  ART8_FREQ_2MHz      CC1_ART8
#define  ART8_FREQ_1MHz      (CC1_ART8 + CC0_ART8)
#define  ART8_FREQ_500KHz    CC2_ART8
#define  ART8_FREQ_250KHz    (CC2_ART8 + CC0_ART8)
#define  ART8_FREQ_125KHz    (CC2_ART8 + CC1_ART8)
#define  ART8_FREQ_62_5KHz   (CC2_ART8 + CC1_ART8 + CC0_ART8)

/* ART control settings
*************************/
#define  ART_CLK        ART_CLK_EXT
#define  ART8_FREQ      ART8_FREQ_250KHz
#define  TIME_BASE      (256 - 125)       /* count value for 500us */



/* Software Interrupt Priority Definitions
********************************************/
// RESET, TRAP and MCES have unchangeable top most priority level

// MCC/RTC
#define  MCC_RTC_LEVEL_1     (I0_1)
#define  MCC_RTC_LEVEL_2     (0)
#define  MCC_RTC_LEVEL_3     (I1_1 + I0_1)

// External Interrupt 0
#define  EI0_LEVEL_1     (I0_2)
#define  EI0_LEVEL_2     (0)
#define  EI0_LEVEL_3     (I1_2 + I0_2)

// External Interrupt 1
#define  EI1_LEVEL_1     (I0_3)
#define  EI1_LEVEL_2     (0)
#define  EI1_LEVEL_3     (I1_3 + I0_3)

// External Interrupt 2
#define  EI2_LEVEL_1     (I0_4)
#define  EI2_LEVEL_2     (0)
#define  EI2_LEVEL_3     (I1_4 + I0_4)

// U/CL/SO
#define  U_CL_SO_LEVEL_1     (I0_5)
#define  U_CL_SO_LEVEL_2     (0)
#define  U_CL_SO_LEVEL_3     (I1_5 + I0_5)

// R/Z
#define  R_Z_LEVEL_1     (I0_6)
#define  R_Z_LEVEL_2     (0)
#define  R_Z_LEVEL_3     (I1_6 + I0_6)

// C/D
#define  C_D_LEVEL_1     (I0_7)
#define  C_D_LEVEL_2     (0)
#define  C_D_LEVEL_3     (I1_7 + I0_7)

// SPI
#define  SPI_LEVEL_1     (I0_8)
#define  SPI_LEVEL_2     (0)
#define  SPI_LEVEL_3     (I1_8 + I0_8)

// TIMER A
#define  TIMER_A_LEVEL_1     (I0_9)
#define  TIMER_A_LEVEL_2     (0)
#define  TIMER_A_LEVEL_3     (I1_9 + I0_9)

// TIMER B
#define  TIMER_B_LEVEL_1     (I0_10)
#define  TIMER_B_LEVEL_2     (0)
#define  TIMER_B_LEVEL_3     (I1_10 + I0_10)

// LINSCI
#define  LIN_SCI_LEVEL_1     (I0_11)
#define  LIN_SCI_LEVEL_2     (0)
#define  LIN_SCI_LEVEL_3     (I1_11 + I0_11)

// AVD/ADC
#define  AVD_ADC_LEVEL_1     (I0_12)
#define  AVD_ADC_LEVEL_2     (0)
#define  AVD_ADC_LEVEL_3     (I1_12 + I0_12)

// PWM ART
#define  PWM_ART_LEVEL_1     (I0_13)
#define  PWM_ART_LEVEL_2     (0)
#define  PWM_ART_LEVEL_3     (I1_13 + I0_13)

/* Interrupt software priority settings
*****************************************/
#define  MCC_RTC_LEVEL    MCC_RTC_LEVEL_1
#define  EI0_LEVEL        EI0_LEVEL_1
#define  EI1_LEVEL        EI1_LEVEL_1

#define  EI2_LEVEL        EI2_LEVEL_1
#define  U_CL_SO_LEVEL    U_CL_SO_LEVEL_3
#define  R_Z_LEVEL        R_Z_LEVEL_2
#define  C_D_LEVEL        C_D_LEVEL_2

#define  SPI_LEVEL        SPI_LEVEL_1
#define  TIMER_A_LEVEL    TIMER_A_LEVEL_1
#define  TIMER_B_LEVEL    TIMER_B_LEVEL_1
#define  LIN_SCI_LEVEL    LIN_SCI_LEVEL_1

#define  AVD_ADC_LEVEL    AVD_ADC_LEVEL_1
#define  PWM_ART_LEVEL    PWM_ART_LEVEL_1

///////////////////////////////////////////////

#define  ITSPR0_init    (EI1_LEVEL + \
                         EI0_LEVEL + \
                         MCC_RTC_LEVEL)

#define  ITSPR1_init    (C_D_LEVEL + \
                         R_Z_LEVEL + \
                         U_CL_SO_LEVEL + \
                         EI2_LEVEL)

#define  ITSPR2_init    (LIN_SCI_LEVEL + \
                         TIMER_B_LEVEL + \
                         TIMER_A_LEVEL + \
                         SPI_LEVEL)

#define  ITSPR3_init    (0xf0 + \
                         PWM_ART_LEVEL + \
                         AVD_ADC_LEVEL)
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

#endif   /* End of INCLUDE.INC  */
