
/***************** (c) 2006  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR WITH INNER
                CURRENT LOOP
     COMPILER : COSMIC
     FILENAME : PCBOARD.H
     RELEASE  : 1.0
     DATE     : 3 Jan 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173

***************************************************************************

 DISCLAIMER :
 ============
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
***************************************************************************


  **********************************************************************
  *   This file                                                        *
  *        - identifies ext hardware connection to micro pin           *
  *        - renames pin names based on connected hardware's function  *
  **********************************************************************


MODIFICATIONS :

******************************************************************************/


#ifndef  _PCBOARD_H
#define  _PCBOARD_H

/**************************************************************************/


/* Switch assignments
************************/
// PB3  --->> PC0
// SW8  --->> PA4
// SW9  --->> PE5
// SW10 --->> PA6

#define   PB3_PORT    PCDR
#define   PB3         BIT(0)

#define   SW8_PORT    PADR
#define   SW8         BIT(4)

#define   SW9_PORT    PEDR
#define   SW9         BIT(5)

#define   SW10_PORT   PADR
#define   SW10        BIT(6)

/* Potentiometer assignments
******************************/
// RV1 --->> AIN13 (PD3)
// RV2 --->> AIN11 (PD0)
// RV3 --->> AIN7  (PC7)

#define  RV1_CHANNEL   13
#define  RV2_CHANNEL   11
#define  RV3_CHANNEL   7

#define  SPEED_REF_CHNL      RV3_CHANNEL
#define  CURRENT_REF_CHNL    RV3_CHANNEL
#define  CURRENT_FDBK_CHNL   6

#define   ON_OFF_PORT   SW10_PORT
#define   ON_OFF_PIN    SW10

/* BEMF inputs for scaling control
***********************************/
// BEMF(A) --->> PE0
// BEMF(B) --->> PE1
// BEMF(C) --->> PE2

#define  BEMF_DR        PEDR
#define  BEMF_DDR       PEDDR
#define  BEMF_INPUTS    ( BIT(2) + BIT(1) + BIT(0) )

/**************************************************************************/


#endif   /* end of PCBOARD.H  */
