
/***************** (c) 2006  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR WITH INNER
                CURRENT LOOP
     COMPILER : COSMIC
     FILENAME : ST72MC.H
     RELEASE  : 1.0
     DATE     : 3 Jan 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173

***************************************************************************

 DISCLAIMER :
 ============
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
***************************************************************************

	****************************************
	*   This file contains                 *
	*   	- ST7 register definitions     *
	*    	- bit definitions              *
	*    	- pin definitions              *
	****************************************

MODIFICATIONS :

******************************************************************************/

#ifndef _ST72MC_H
#define _ST72MC_H


/****************************************************************************

   ******************************************************
   *   NOTES :                                          *
   *   =======                                          *
   *    -- To enable ASSEMBLY and C usage ---           *
   *     device registers are prefixed with             *
   *     'a', to indicate that they                     *
   *    are pointers pointing to some address           *
   *     location in memory                             *
   *                                                    *
   *   for example, consider the following lines        *
   *                                                    *
   *   #define  aPCDR   0x0                             *
   *   #define  PCDR    *(unsigned char *)aPCDR         *
   *                                                    *
   *     in assembly language, the code                 *
   *            LD   A, #0                              *
   *            LD   aPCDR, A                           *
   *                                                    *
   *     is equivalent to the C code                    *
   *          PCDR = 0x0;                               *
   *                                                    *
   ******************************************************

****************************************************************************/

/* Register definitions for assembly language use
*************************************************/

/*  Port A register
 *******************/
#define	 aPADR	     0x0
#define	 aPADDR	     0x1
#define	 aPAOR	     0x2

/*  Port B register
 *******************/
#define	 aPBDR	     0x3
#define	 aPBDDR	     0x4
#define	 aPBOR	     0x5

/*  Port C register
 *******************/
#define	 aPCDR	     0x6
#define	 aPCDDR	     0x7
#define	 aPCOR	     0x8

/*  Port D register
 *******************/
#define	 aPDDR	     0x9
#define	 aPDDDR	     0xA
#define	 aPDOR	     0xB

/*  Port E register
 *******************/
#define	 aPEDR	     0xC
#define	 aPEDDR	     0xD
#define	 aPEOR	     0xE

/*  Port F register
 *******************/
#define	 aPFDR	     0xF
#define	 aPFDDR	     0x10
#define	 aPFOR	     0x11

/*  Port G register
 *******************/
#define	 aPGDR	     0x12
#define	 aPGDDR	     0x13
#define	 aPGOR	     0x14

/*  Port H register
 *******************/
#define	 aPHDR	     0x15
#define	 aPHDDR	     0x16
#define	 aPHOR	     0x17

/*  LINSCI register
 *******************/
#define	 aSCISR	     0x18
#define	 aSCIDR	     0x19
#define	 aSCIBRR     0x1A
#define	 aSCICR1     0x1B
#define	 aSCICR2     0x1C
#define	 aSCICR3     0x1D
#define	 aSCIERPR    0x1E
#define	 aSCIETPR    0x1F


/*   SPI register
*****************/
#define	 aSPIDR	     0x21
#define	 aSPICR	     0x22
#define	 aSPICSR     0x23


/*  Interrupt Control Register
 *******************************/
#define  aITSPR0     0x24
#define  aITSPR1     0x25
#define  aITSPR2     0x26
#define  aITSPR3     0x27
#define  aEICR	     0x28


/* Flash Register
 *******************/
#define  aFLASH	     0x29


/*   Watch dog register
************************/
#define	 aWWDGCR     0x2A
#define	 aWWDGWR     0x2B


/* Main Clock Control Register
 *******************************/
#define  aMCCSR	     0x2C
#define  aMCCBCR     0x2D


/*   ADC register
 *****************/
#define	 aADCCSR     0x2E
#define	 aADCDRMSB   0x2F
#define	 aADCDRLSB   0x30


/*   Timer A registers
**********************/
#define  aTACR2	     0x31
#define  aTACR1	     0x32

#define  aTACSR	     0x33

#define  aTAIC1HR    0x34
#define  aTAIC1LR    0x35

#define  aTAOC1HR    0x36
#define  aTAOC1LR    0x37

#define  aTACHR	     0x38
#define  aTACLR	     0x39

#define  aTAACHR     0x3A
#define  aTAACLR     0x3B

#define  aTAIC2HR    0x3c
#define  aTAIC2LR    0x3d

#define  aTAOC2HR    0x3e
#define  aTAOC2LR    0x3f


/*  System Control
 ********************/
#define  aSICSR      0x40

/* Timer B registers
*********************/
#define  aTBCR2	     0x41
#define  aTBCR1	     0x42
#define  aTBCSR	     0x43
#define  aTBIC1HR    0x44
#define  aTBIC1LR    0x45
#define  aTBOC1HR    0x46
#define  aTBOC1LR    0x47
#define  aTBCHR	     0x48
#define  aTBCLR	     0x49
#define  aTBACHR     0x4A
#define  aTBACLR     0x4B
#define  aTBIC2HR    0x4c
#define  aTBIC2LR    0x4d
#define  aTBOC2HR    0x4e
#define  aTBOC2LR    0x4f


/*  Motor control registers (Page 0)
 **************************************/
#define  aMTIM       0x50
#define  aMTIML      0x51
#define  aMZPRV      0x52
#define  aMZREG      0x53
#define  aMCOMP      0x54
#define  aMDREG      0x55
#define  aMWGHT      0x56
#define  aMPRSR      0x57
#define  aMIMR       0x58
#define  aMISR       0x59
#define  aMCRA       0x5a
#define  aMCRB       0x5b
#define  aMCRC       0x5c
#define  aMPHST      0x5d
#define  aMDFR       0x5e
#define  aMCFR       0x5f
#define  aMREF       0x60
#define  aMPCR       0x61
#define  aMREP       0x62
#define  aMCPWH      0x63
#define  aMCPWL      0x64
#define  aMCPVH      0x65
#define  aMCPVL      0x66
#define  aMCPUH      0x67
#define  aMCPUL      0x68
#define  aMCP0H      0x69
#define  aMCP0L      0x6a

/*  Motor control registers (Page 1)
 **************************************/
#define  aMDTG       0x50
#define  aMPOL       0x51
#define  aMPWME      0x52
#define  aMCONF      0x53
#define  aMPAR       0x54
#define  aMZFR       0x55
#define  aMSCR       0x56

/* PWM ART registers
 **********************/
#define  aPWMDCR3    0x74
#define  aPWMDCR2    0x75
#define  aPWMDCR1    0x76
#define  aPWMDCR0    0x77
#define  aPWMCR      0x78
#define  aARTCSR     0x79
#define  aARTCAR     0x7a
#define  aARTARR     0x7b
#define  aARTICCSR   0x7c
#define  aARTICR1    0x7d
#define  aARTICR2    0x7e

/* OPAMP control registers
 ***************************/
#define  aOACSR      0x7f

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

/* BIT FUNCTION MACROS FOR USE IN C
***********************************/
#ifndef  _BIT_MACRO
#define  _BIT_MACRO

#define  BIT(A)                 ( 1 << (A) )
#define  bitToggle(A, B)        ( (A) ^= (B) )
#define  bitSet(A, B)           ( (A) |= (B) )
#define  bitClr(A, B)           ( (A) &= ~(B) )
#define  bitTest_TRUE(A, B)     (  ( (A) & (B) ) )
#define  bitTest_FALSE(A, B)    ( !( (A) & (B) ) )

#endif
/*****************************************************************************/
/*****************************************************************************/
/****************** Register definitions for C language use ******************/
/*****************************************************************************/
/*****************************************************************************/

typedef   volatile unsigned char   vu8;

/* Register definitions for C language use
******************************************/

/* Port A registers
********************/
#define	 PADR      ( * (vu8 *) aPADR  )
#define	 PADDR     ( * (vu8 *) aPADDR )
#define	 PAOR      ( * (vu8 *) aPAOR  )

/* Port B registers
********************/
#define	 PBDR      ( * (vu8 *) aPBDR  )
#define	 PBDDR     ( * (vu8 *) aPBDDR )
#define	 PBOR      ( * (vu8 *) aPBOR  )

/* Port C registers
********************/
#define	 PCDR      ( * (vu8 *) aPCDR  )
#define	 PCDDR     ( * (vu8 *) aPCDDR )
#define	 PCOR      ( * (vu8 *) aPCOR  )

/* Port D registers
 *******************/
#define	 PDDR      ( * (vu8 *) aPDDR  )
#define	 PDDDR     ( * (vu8 *) aPDDDR )
#define	 PDOR      ( * (vu8 *) aPDOR  )

/* Port E registers
 *******************/
#define	 PEDR      ( * (vu8 *) aPEDR  )
#define	 PEDDR     ( * (vu8 *) aPEDDR )
#define	 PEOR      ( * (vu8 *) aPEOR  )

/* Port F registers
 *******************/
#define	 PFDR      ( * (vu8 *) aPFDR  )
#define	 PFDDR     ( * (vu8 *) aPFDDR )
#define	 PFOR      ( * (vu8 *) aPFOR  )

/* Port G registers
 *******************/
#define	 PGDR      ( * (vu8 *) aPGDR  )
#define	 PGDDR     ( * (vu8 *) aPGDDR )
#define	 PGOR      ( * (vu8 *) aPGOR  )

/* Port H registers
 *******************/
#define	 PHDR      ( * (vu8 *) aPHDR  )
#define	 PHDDR     ( * (vu8 *) aPHDDR )
#define	 PHOR      ( * (vu8 *) aPHOR  )

/************************************************************************/

/*  LINSCI registers
 ********************/
// SCISR register
#define	 SCISR     ( * (vu8 *) aSCISR   )
  #define  TDRE     BIT(7)
  #define  TC       BIT(6)
  #define  RDRF     BIT(5)
  #define  IDLE     BIT(4)
  #define  OR       BIT(3)
  #define  NF       BIT(2)
  #define  FE       BIT(1)
  #define  PE       BIT(0)

#define	 SCIDR     ( * (vu8 *) aSCIDR   )

// SCIBRR register
#define	 SCIBRR    ( * (vu8 *) aSCIBRR  )
  #define  SCP1     BIT(7)
  #define  SCP0     BIT(6)
  #define  SCT2     BIT(5)
  #define  SCT1     BIT(4)
  #define  SCT0     BIT(3)
  #define  SCR2     BIT(2)
  #define  SCR1     BIT(1)
  #define  SCR0     BIT(0)

// SCICR1 register
#define	 SCICR1    ( * (vu8 *) aSCICR1  )
  #define  R8       BIT(7)
  #define  T8       BIT(6)
  #define  SCID     BIT(5)
  #define  M        BIT(4)
  #define  WAKE     BIT(3)
  #define  PCE      BIT(2)
  #define  PS       BIT(1)
  #define  PIE      BIT(0)

// SCICR2 register
#define	 SCICR2    ( * (vu8 *) aSCICR2  )
  #define  TIE      BIT(7)
  #define  TCIE     BIT(6)
  #define  RIE      BIT(5)
  #define  ILIE     BIT(4)
  #define  TE       BIT(3)
  #define  RE       BIT(2)
  #define  RWU      BIT(1)
  #define  SBK      BIT(0)

//SCICR3
#define	 SCICR3    ( * (vu8 *) aSCICR3  )
  #define  LDUM     BIT(7)
  #define  LINE     BIT(6)
  #define  LSLV     BIT(5)
  #define  LASE     BIT(4)
  #define  LHDM     BIT(3)
  #define  LHIE     BIT(2)
  #define  LHDF     BIT(1)
  #define  LSF      BIT(0)

#define	 SCIERPR   ( * (vu8 *) aSCIERPR )
#define	 SCIETPR   ( * (vu8 *) aSCIETPR )

/************************************************************************/
/* SPI registers
*****************/
#define	 SPIDR     ( * (vu8 *) aSPIDR )

/* SPI_CR */
#define	 SPICR     ( * (vu8 *) aSPICR )
  #define   spie    BIT(7)
  #define   spe     BIT(6)
  #define   spr2    BIT(5)
  #define   mstr    BIT(4)
  #define   cpol    BIT(3)
  #define   cpha    BIT(2)
  #define   spr1    BIT(1)
  #define   spr0    BIT(0)

/* SPI_SR */
#define	 SPICSR     ( * (vu8 *) aSPICSR )
  #define   spif    BIT(7)
  #define   wcol    BIT(6)
  #define   ovr     BIT(5)
  #define   modf    BIT(4)
  //                BIT(3)
  #define   sod     BIT(2)
  #define   ssm     BIT(1)
  #define   ssi     BIT(0)

/************************************************************************/

/*  Interrupt Control Registers
 *******************************/
//ITSPR0
#define  ITSPR0    ( * (vu8 *) aITSPR0 )
  #define  I0_1   BIT(2)
  #define  I1_1   BIT(3)
  #define  I0_2   BIT(4)
  #define  I1_2   BIT(5)
  #define  I0_3   BIT(6)
  #define  I1_3   BIT(7)
//ITSPR1
#define  ITSPR1    ( * (vu8 *) aITSPR1 )
  #define  I0_4   BIT(0)
  #define  I1_4   BIT(1)
  #define  I0_5   BIT(2)
  #define  I1_5   BIT(3)
  #define  I0_6   BIT(4)
  #define  I1_6   BIT(5)
  #define  I0_7   BIT(6)
  #define  I1_7   BIT(7)

//ITSPR2
#define  ITSPR2    ( * (vu8 *) aITSPR2 )
  #define  I0_8   BIT(0)
  #define  I1_8   BIT(1)
  #define  I0_9   BIT(2)
  #define  I1_9   BIT(3)
  #define  I0_10   BIT(4)
  #define  I1_10   BIT(5)
  #define  I0_11   BIT(6)
  #define  I1_11   BIT(7)

//ITSPR3
#define  ITSPR3    ( * (vu8 *) aITSPR3 )
  #define  I0_12   BIT(0)
  #define  I1_12   BIT(1)
  #define  I0_13   BIT(2)
  #define  I1_13   BIT(3)
  #define  I0_14   BIT(4)
  #define  I1_14   BIT(5)
  #define  I0_15   BIT(6)
  #define  I1_15   BIT(7)

// EICR
#define  EICR      ( * (vu8 *) aEICR   )
  #define  IPA    BIT(2)
  #define  IS20   BIT(3)
  #define  IS21   BIT(4)
  #define  IPB    BIT(5)
  #define  IS10   BIT(6)
  #define  IS11   BIT(7)

/************************************************************************/

/* Flash Register
 *******************/
#define  FLASH     ( * (vu8 *) aFLASH )
  // No user control bits in this register - Not for user control

/************************************************************************/

/*  Watch dog registers
************************/
#define	 WWDGCR	   ( * (vu8 *) aWWDGCR )
  #define   wdga    BIT(7)

#define	 WWDGWR	   ( * (vu8 *) aWWDGWR )

/************************************************************************/

/* Main Clock Control Register
 *******************************/
//MCCSR
#define  MCCSR     ( * (vu8 *) aMCCSR  )
  #define   MCO      BIT(7)
  #define   CP1      BIT(6)
  #define   CP0      BIT(5)
  #define   SMS      BIT(4)
  #define   TB1      BIT(3)
  #define   TB0      BIT(2)
  #define   OIE      BIT(1)
  #define   OIF      BIT(0)

//MCCBCR
#define  MCCBCR	   ( * (vu8 *) aMCCBCR )
  //D[7:4] is 0
  #define   ADSTS    BIT(3)
  #define   ADCIE    BIT(2)
  #define   BC1      BIT(1)
  #define   BC0      BIT(0)

/************************************************************************/

/*  ADC registers
 *****************/
/* ADC_CSR */
#define  ADCCSR   ( * (vu8 *) aADCCSR   )
  #define  EOC 	     BIT(7)
  #define  PRSC1     BIT(6)
  #define  PRSC0     BIT(5)
  #define  ADON      BIT(4)
  #define  CH3	     BIT(3)
  #define  CH2	     BIT(2)
  #define  CH1	     BIT(1)
  #define  CH0	     BIT(0)

#define	 ADCDRMSB  ( * (vu8 *) aADCDRMSB )
#define	 ADCDRLSB  ( * (vu8 *) aADCDRLSB )

/************************************************************************/

/*  Timer A registers
**********************/
#define  TAIC1HR   ( * (vu8 *) aTAIC1HR )
#define  TAIC1LR   ( * (vu8 *) aTAIC1LR )
#define  TAOC1HR   ( * (vu8 *) aTAOC1HR )
#define  TAOC1LR   ( * (vu8 *) aTAOC1LR )
#define  TACHR     ( * (vu8 *) aTACHR   )
#define  TACLR     ( * (vu8 *) aTACLR   )
#define  TAACHR    ( * (vu8 *) aTAACHR  )
#define  TAACLR    ( * (vu8 *) aTAACLR  )
#define  TAIC2HR   ( * (vu8 *) aTAIC2HR )
#define  TAIC2LR   ( * (vu8 *) aTAIC2LR )
#define  TAOC2HR   ( * (vu8 *) aTAOC2HR )
#define  TAOC2LR   ( * (vu8 *) aTAOC2LR )

/* Timer B registers
*********************/
#define  TBIC1HR   ( * (vu8 *) aTBIC1HR )
#define  TBIC1LR   ( * (vu8 *) aTBIC1LR )
#define  TBOC1HR   ( * (vu8 *) aTBOC1HR )
#define  TBOC1LR   ( * (vu8 *) aTBOC1LR )
#define  TBCHR     ( * (vu8 *) aTBCHR   )
#define  TBCLR     ( * (vu8 *) aTBCLR   )
#define  TBACHR    ( * (vu8 *) aTBACHR  )
#define  TBACLR    ( * (vu8 *) aTBACLR  )
#define  TBIC2HR   ( * (vu8 *) aTBIC2HR )
#define  TBIC2LR   ( * (vu8 *) aTBIC2LR )
#define  TBOC2HR   ( * (vu8 *) aTBOC2HR )
#define  TBOC2LR   ( * (vu8 *) aTBOC2LR )

/* TACR1 and TBCR1 */
#define  TACR1     ( * (vu8 *) aTACR1   )
#define  TBCR1     ( * (vu8 *) aTBCR1   )
  #define   icie     BIT(7)
  #define   ocie     BIT(6)
  #define   toie     BIT(5)
  #define   folv2    BIT(4)
  #define   folv1    BIT(3)
  #define   olvl2    BIT(2)
  #define   iedg1    BIT(1)
  #define   olvl1    BIT(0)

/* TACR2 and TBCR2 */
#define  TACR2     ( * (vu8 *) aTACR2   )
#define  TBCR2     ( * (vu8 *) aTBCR2   )
  #define   oc1e     BIT(7)
  #define   oc2e     BIT(6)
  #define   opm      BIT(5)
  #define   pwm	     BIT(4)
  #define   cc1	     BIT(3)
  #define   cc0	     BIT(2)
  #define   iedg2    BIT(1)
  #define   exedg    BIT(0)

/* TASR and TBSR */
#define  TACSR	   ( * (vu8 *) aTACSR   )
#define  TBCSR     ( * (vu8 *) aTBCSR   )
  #define   icf1     BIT(7)
  #define   ocf1     BIT(6)
  #define   tof      BIT(5)
  #define   icf2     BIT(4)
  #define   ocf2     BIT(3)

/************************************************************************/

/*  System Control
 ********************/
#define  SICSR    ( * (vu8 *) aSICSR   )
  // PAGE 0
  #define  PAGE    BIT(7)
  #define  VDIE    BIT(6)
  #define  VDF     BIT(5)
  #define  LVDRF   BIT(4)
  //               BIT(3)
  #define  CFIE    BIT(2)
  #define  CSSD    BIT(1)
  #define  WDGRF   BIT(0)

  // PAGE 1
  #define  PAGE    BIT(7)
  //               BIT(6)
  #define  VCOEN   BIT(5)
  #define  LOCK    BIT(4)
  #define  PLLEN   BIT(3)
  //               BIT(2)
  #define  CKSEL   BIT(1)
  //               BIT(0)

/************************************************************************/

/*  Motor control registers (Page 0)
 **************************************/
#define  MTIM      ( * (vu8 *) aMTIM  )
#define  MTIML     ( * (vu8 *) aMTIML )
#define  MZPRV     ( * (vu8 *) aMZPRV )
#define  MZREG     ( * (vu8 *) aMZREG )
#define  MCOMP     ( * (vu8 *) aMCOMP )
#define  MDREG     ( * (vu8 *) aMDREG )
#define  MWGHT     ( * (vu8 *) aMWGHT )

// MPRSR register
#define  MPRSR     ( * (vu8 *) aMPRSR )
  #define  SA3      BIT(7)
  #define  SA2      BIT(6)
  #define  SA1      BIT(5)
  #define  SA0      BIT(4)
  #define  ST3      BIT(3)
  #define  ST2      BIT(2)
  #define  ST1      BIT(1)
  #define  ST0      BIT(0)

// MIMR register
#define  MIMR      ( * (vu8 *) aMIMR  )
  #define  PUM      BIT(7)
  #define  SEM      BIT(6)
  #define  RIM      BIT(5)
  #define  CLIM     BIT(4)
  #define  EIM      BIT(3)
  #define  ZIM      BIT(2)
  #define  DIM      BIT(1)
  #define  CIM      BIT(0)

// MISR register
#define  MISR      ( * (vu8 *) aMISR  )
  #define  PUI      BIT(7)
  #define  RPI      BIT(6)
  #define  RMI      BIT(5)
  #define  CLI      BIT(4)
  #define  EI       BIT(3)
  #define  ZI       BIT(2)
  #define  DI       BIT(1)
  #define  CI       BIT(0)

// MCRA register
#define  MCRA      ( * (vu8 *) aMCRA  )
  #define  MOE      BIT(7)
  #define  CKE      BIT(6)
  #define  SR       BIT(5)
  #define  DAC      BIT(4)
  #define  V0C1     BIT(3)
  #define  SWA      BIT(2)
  #define  PZ       BIT(1)
  #define  DCB      BIT(0)

// MCRB register
#define  MCRB      ( * (vu8 *) aMCRB  )
  // (BIT7 IS ALWAYS 0)
  #define  CPB      BIT(6)
  #define  HDM      BIT(5)
  #define  SDM      BIT(4)
  #define  OCV      BIT(3)
  #define  OS2      BIT(2)
  #define  OS1      BIT(1)
  #define  OS0      BIT(0)

// MCRC register
#define  MCRC      ( * (vu8 *) aMCRC  )
  #define  SEI      BIT(7)
  #define  HZ       BIT(6)
  #define  SZ       BIT(5)
  #define  SC       BIT(4)
  #define  SPLG     BIT(3)
  #define  VR2      BIT(2)
  #define  VR1      BIT(1)
  #define  VR0      BIT(0)

// MPHST register
#define  MPHST     ( * (vu8 *) aMPHST )
  #define  IS1      BIT(7)
  #define  IS0      BIT(6)
// OO[5:0] NOT SHOWN

// MDFR register
#define  MDFR      ( * (vu8 *) aMDFR  )
// DEF[3:0]
// DWF[7:0]
  #define  DEF3     BIT(7)
  #define  DEF2     BIT(6)
  #define  DEF1     BIT(5)
  #define  DEF0     BIT(4)
  #define  DWF3     BIT(3)
  #define  DWF2     BIT(2)
  #define  DWF1     BIT(1)
  #define  DWF0     BIT(0)

// MCFR register
#define  MCFR      ( * (vu8 *) aMCFR  )
  #define  RPGS     BIT(7)
  #define  RST      BIT(6)
  #define  CFF2     BIT(5)
  #define  CFF1     BIT(4)
  #define  CFF0     BIT(3)
  #define  CFW2     BIT(2)
  #define  CFW1     BIT(1)
  #define  CFW0     BIT(0)

// MREF register
#define  MREF      ( * (vu8 *) aMREF  )
  #define  HST      BIT(7)
  #define  CL       BIT(6)
  #define  CFAV     BIT(5)
  #define  HFE1     BIT(4)
  #define  HFE0     BIT(3)
  #define  HFRQ2    BIT(2)
  #define  HFRQ1    BIT(1)
  #define  HFRQ0    BIT(0)

// MPCR register
#define  MPCR      ( * (vu8 *) aMPCR  )
  #define  PMS      BIT(7)
  #define  OFLU     BIT(6)
  #define  OFLV     BIT(5)
  #define  OFLW     BIT(4)
  #define  CMS      BIT(3)
  #define  PCP2     BIT(2)
  #define  PCP1     BIT(1)
  #define  PCP0     BIT(0)

#define  MREP      ( * (vu8 *) aMREP  )
#define  MCPWH     ( * (vu8 *) aMCPWH )
#define  MCPWL     ( * (vu8 *) aMCPWL )
#define  MCPVH     ( * (vu8 *) aMCPVH )
#define  MCPVL     ( * (vu8 *) aMCPVL )
#define  MCPUH     ( * (vu8 *) aMCPUH )
#define  MCPUL     ( * (vu8 *) aMCPUL )
#define  MCP0H     ( * (vu8 *) aMCP0H )
#define  MCP0L     ( * (vu8 *) aMCP0L )

/*  Motor control registers (Page 1)
 **************************************/
// MDTG register
#define  MDTG      ( * (vu8 *) aMDTG  )
  #define  PCN      BIT(7)
  #define  DTE      BIT(6)
  #define  DTG5     BIT(5)
  #define  DTG4     BIT(4)
  #define  DTG3     BIT(3)
  #define  DTG2     BIT(2)
  #define  DTG1     BIT(1)
  #define  DTG0     BIT(0)

// MPOL register
#define  MPOL      ( * (vu8 *) aMPOL  )
  #define  ZVD      BIT(7)
  #define  REO      BIT(6)
  #define  OP5      BIT(5)
  #define  OP4      BIT(4)
  #define  OP3      BIT(3)
  #define  OP2      BIT(2)
  #define  OP1      BIT(1)
  #define  OP0      BIT(0)

// MPWME register
#define  MPWME     ( * (vu8 *) aMPWME )
  #define  DG       BIT(7)
  #define  PWMW     BIT(6)
  #define  PWMV     BIT(5)
  #define  PWMU     BIT(4)
  #define  OT3      BIT(3)
  #define  OT2      BIT(2)
  #define  OT1      BIT(1)
  #define  OT0      BIT(0)

// MCONF register
#define  MCONF     ( * (vu8 *) aMCONF )
  // DS[3:0] NOT SHOWN
  #define  DS3      BIT(7)
  #define  DS2      BIT(6)
  #define  DS1      BIT(5)
  #define  DS0      BIT(4)
  #define  SOI      BIT(3)
  #define  SOM      BIT(2)
  #define  XT16     BIT(1)
  #define  XT8      BIT(0)

// MPAR register
#define  MPAR      ( * (vu8 *) aMPAR  )
  #define  TES1     BIT(7)
  #define  TES0     BIT(6)
  #define  OE5      BIT(5)
  #define  OE4      BIT(4)
  #define  OE3      BIT(3)
  #define  OE2      BIT(2)
  #define  OE1      BIT(1)
  #define  OE0      BIT(0)

// MZRF register
#define  MZFR      ( * (vu8 *) aMZFR  )
  // ZEF[3:0]
  // ZWF[3:0]
  #define  ZEF3     BIT(7)
  #define  ZEF2     BIT(6)
  #define  ZEF1     BIT(5)
  #define  ZEF0     BIT(4)
  #define  ZWF3     BIT(3)
  #define  ZWF2     BIT(2)
  #define  ZWF1     BIT(1)
  #define  ZWF0     BIT(0)

#define  MSCR      ( * (vu8 *) aMSCR  )
  // BITS[6:4] ARE ALWAYS ZERO
  #define  ZSV      BIT(7)
  #define  SCF1     BIT(3)
  #define  SCF0     BIT(2)
  #define  ECM      BIT(1)
  #define  DISS     BIT(0)

/************************************************************************/

/* PWM ART registers
 **********************/
#define  PWMDCR3   ( * (vu8 *) aPWMDCR3  )
#define  PWMDCR2   ( * (vu8 *) aPWMDCR2  )
#define  PWMDCR1   ( * (vu8 *) aPWMDCR1  )
#define  PWMDCR0   ( * (vu8 *) aPWMDCR0  )

#define  PWMCR     ( * (vu8 *) aPWMCR    )
  #define  OE3_pwm     BIT(7)
  #define  OE2_pwm     BIT(6)
  #define  OE1_pwm     BIT(5)
  #define  OE0_pwm     BIT(4)
  #define  OP3_pwm     BIT(3)
  #define  OP2_pwm     BIT(2)
  #define  OP1_pwm     BIT(1)
  #define  OP0_pwm     BIT(0)

#define  ARTCSR    ( * (vu8 *) aARTCSR   )
  #define  EXCL          BIT(7)
  #define  CC2_ART8      BIT(6)
  #define  CC1_ART8      BIT(5)
  #define  CC0_ART8      BIT(4)
  #define  TCE           BIT(3)
  #define  FCRL          BIT(2)
  #define  OIE_ART8      BIT(1)
  #define  OVF_ART8      BIT(0)

#define  ARTCAR    ( * (vu8 *) aARTCAR   )
#define  ARTARR    ( * (vu8 *) aARTARR   )

#define  ARTICCSR  ( * (vu8 *) aARTICCSR )
  //                BIT(7)
  //                BIT(6)
  #define  CS2      BIT(5)
  #define  CS1      BIT(4)
  #define  CIE2     BIT(3)
  #define  CIE1     BIT(2)
  #define  CF2      BIT(1)
  #define  CF1      BIT(0)

#define  ARTICR1   ( * (vu8 *) aARTICR1  )
#define  ARTICR2   ( * (vu8 *) aARTICR2  )

/************************************************************************/

/* OPAMP control registers
 ***************************/
/* OACSR */
#define  OACSR     ( * (vu8 *) aOACSR )
  #define  CMPOVR      BIT(7)
  #define  OFFCMP      BIT(6)
  #define  AVGCMP      BIT(5)
  #define  OAON        BIT(4)
  #define  HIGHGAIN    BIT(3)

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
#endif	/* -- end of ST7REG.H -- */
