/* 
*******************************************************************************
THIS INFORMATION (or THIS SOFTWARE or THIS DOCUMENT) IS FOR GUIDANCE ONLY. 
ST MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH REGARD TO THIS 
SOFTWARE nor for any infringement of patents or other rights of third parties 
which may result from its use.

ST MICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT 
INCIDENTAL OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING 
IN CONNECTION WITH OR ARISING FROM THE FURNISHING, PERFORMANCE, OR USE 
OF THIS SOFTWARE.

Specifications mentioned in this publication are subject to change without 
notice. This publication supersedes and replaces all information previously 
supplied. STMicroelectronics products are not authorized for use as critical 
components in life support devices or systems without the express written 
approval of STMicroelectronics.

*******************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : main.c
Group            : MLD Systems Lab
Author           : MLD Consumer Team
Date First Issued: 25/11/05
********************************Documentation**********************************
General Purpose:
	1. Top Level file.This file calls the functions written in io.c,
		adc.c, sci.c, i2c.c
	2. This application demonstrates following:
		- SCI to hyperterminal communication.
		- ADC conversion on channel2.
		- I2C- 24C02 EEPROM communication, to write/read temparature values to/from  
			EEPROM.
		- Toggle LEDs using IOs.
*******************************************************************************
Hardware:
	-Raisonance REva board.
	-Serial cabel from REva serial port to PC communication port.
******************************************************************************* 
********************************RevisionHistory********************************
_______________________________________________________________________________
Date :25/11/2005                   Release:1.0                                             
******************************************************************************/     
#include "ST7lib_config.h"       
#define MAX_NO_OF_TEMP_VALS 20 /*Max no of temparature values that will be stored in EEPROM*/
#define CONVERSION_FACTOR 5 /*ADC data value is multiplied by 4800 to convert it into mV.
										It is then divided by 0x3ff(maximum value that can be stored
										in 10 bit ADC). So 4800 by 0x3ff = 5(approx.)*/
#define BASE_ADDR 0x00
#define SIZE_OF_BUFFER 4
#define CHANNEL 2  // ADC channel selected
#define BAUD_PRE 0x00
#define Ext_TPR 0x27
#define Ext_RPR 0x27
#define MAX_NO_SAMPLE_VAL 16 /*Max no of temparature samples used to calculate the average temparature*/
#define TIMER_CMP_VAL 0x963D /*Output compare value to generate a time delay of 50ms, after which
										output compare interrupt is asserted
										Calculation:
											fcpu=6MHz, Presc= 8
											Time Period of counter is 8/(6*10^6) = approx 1.3us(microsecond)
											Time duration required=50ms
											Therefore Counter value=50ms/1.3us=0x963D*/

//protoytpe declaration
void PeriphInit ( void );
void Delay(void);
void Delay_1(void);
void Led_Toggle(void);
void SCI_Read_Data(void);
void I2C_EEPROM_WRITE(unsigned char, unsigned char * , int);
void I2C_EEPROM_READ(unsigned char, int);
void TRtc_CntUpdate(void);/* Function for updating the clock Counters */
void main(void);

/*These messages will be displayed on hyperterminal as application proceeds*/
const unsigned char buff1[]= {"\n\rTemparature Sensor Application demo using LM135 ongoing\n"};
const unsigned char buff2[]= {"\n\rPlease enter Min value (-055 to +150)..."}; 
const unsigned char buff3[]= {"\n\rPlease enter Max value, greater than Min value, (-055 to +150)..."}; 
const unsigned char buff4[]= {"\n\n\r--------------------\n\rData in EEPROM is...\n\r--------------------\n"}; 
const unsigned char buff5[]= {"\n\rTemparature sensed..."};
const unsigned char buff6[]= {"\n\rCritical Temparature Value."};
const unsigned char buff7[]= {"\n\rI2C writing temparature value(s) on EEPROM..."};
const unsigned char buf8[]= {"\n\rI2C reading temparature value(s) from EEPROM\n\r"};
const unsigned char buff9[]= {"\n\rApplication designed to work for Integer values only\n"};

/*Variable to keep track of no. of filled memory location
in EEPROM.Initialized to 0x00 since it is the starting location
where the temparature values will be stored*/
unsigned char eeprom_addr=BASE_ADDR; 

/*Counter*/
int ctr;

/*Buffers*/
unsigned char Buff_Out1[SIZE_OF_BUFFER];
static unsigned char Buff_In1[SIZE_OF_BUFFER];


unsigned char * buffer;
unsigned char hour_flag;

/*Variables used to check address and data transmission during I2C write operation*/
static unsigned char TX_Add_Ret=0;
static unsigned char TX_Byte_Ret=0;

/* Variables Declaration to store the counters for 50ms, second, minute, hour */

unsigned char t_hour;                  	      /* Real time clock HOUR counter. */
unsigned char t_min;                        /* Real time clock MINUTE counter. */
unsigned char t_sec;                        /* Real time clock SECOND counter. */
unsigned char t_50ms;                  /* Real time clock MILLISECOND counter. */

int no_of_sample_vals=0;	//variable used to keep track of number of temparature samples
									//used to calculate the average temparature
int temp_arr[MAX_NO_SAMPLE_VAL];
int code;
void main (void)
{
	long temp_in;//used to store temparature value
	int min=999;
	int min_copy;
	int max=0;
	int max_copy;
	
	
	int no_of_temp_vals=0; //variable used to keep track of number of temparature values
									//stored in EEPROM
 
	int average=0;
	int count=0;																	

	//variables for storing lower and upper bound temparature values	
	int critical_temp_low=0;
	int critical_temp_high=0;
	
	t_50ms = t_sec = t_min = t_hour = 0x00;
	hour_flag='f';
	code=1;
	PeriphInit();
	SCI_PutBuffer(buff1,(unsigned char)sizeof(buff1));
	while(!(SCI_IsTransmitCompleted()));
	SCI_PutBuffer(buff9,(unsigned char)sizeof(buff9));
	while(!(SCI_IsTransmitCompleted()));
	
	buffer=Buff_Out1; //Address of Buff_Out1 stored in pointer buffer

	EnableInterrupts;      
	ADC_Init (ADC_SPEED);	
	ADC_Select_Channel(CHANNEL);                                         
	while(1)
	{
		switch (code)
		{
			case 1: 	//Configuration Mode:
						//Prompts user to enter lower and upper threshold value
						//which are then stored in EEPROM
						TIMERB_Mode_Disable(TIMER_MODE_9);
						/* get minimum critical value */
 						SCI_PutBuffer(buff2,(unsigned char)sizeof(buff2));
						while(!(SCI_IsTransmitCompleted()));
						SCI_Read_Data();
 
						/* Convert the temparature entered by user into its decimal equivalent */
						if (Buff_Out1[0] == '-')
						{
							critical_temp_low = ((Buff_Out1[2] - '0') * 10) + (Buff_Out1[3] - '0');
							critical_temp_low *= -1;
						}
						else
						{
							critical_temp_low = ((Buff_Out1[1] - '0') * 100) + ((Buff_Out1[2] - '0') * 10)\
					   		                + (Buff_Out1[3] - '0');
						}

						/* get maximum critical value */
						SCI_PutBuffer(buff3,(unsigned char)sizeof(buff3));
						while(!(SCI_IsTransmitCompleted()));
						SCI_Read_Data();

						/* Convert the temparature entered by user into its decimal equivalent */
						if(Buff_Out1[0]=='-')
						{
							critical_temp_high = ((Buff_Out1[2] - '0') * 10) + (Buff_Out1[3] - '0');
							critical_temp_high *= -1;
						}
						else
						{
							critical_temp_high = ((Buff_Out1[1] - '0') * 100) + ((Buff_Out1[2] - '0') * 10) \
					   		                 + (Buff_Out1[3] - '0');
						}

						TIMERB_Init(TIMER_FCPU_8);	   /* Set the Timer Frequency = Fcpu/8 */

						/* Enable the Output Compare interrupt */	
						TIMERB_IT_Enable(TIMER_OCMP_IT_ENABLE); 
  
						/* This enables output compare 1 function */
						TIMERB_OCMP_Mode(TIMER_OCMP_1,TIMER_CMP_VAL,TIMER_OUTPUT_F);
						code=-1;
						break;

			case 2:	//Read stored temparature values from EEPROM and 
						//write to hyperterminal via SCI
						TIMERB_Mode_Disable(TIMER_MODE_9);
				
						SCI_PutBuffer(buff4,(unsigned char)sizeof(buff4));
						while(!(SCI_IsTransmitCompleted()));
						ctr=(int)BASE_ADDR;
							
						SCI_PutBuffer(buf8,(unsigned char)sizeof(buf8));
				      while(!(SCI_IsTransmitCompleted()));
		      
						while(ctr!=eeprom_addr)
						{
							I2C_EEPROM_READ(ctr,SIZE_OF_BUFFER);
							ctr+=SIZE_OF_BUFFER;
						}			

						TIMERB_Init(TIMER_FCPU_8);	   /* Set the Timer Frequency = Fcpu/8 */

						/* Enable the Output Compare interrupt */	
						TIMERB_IT_Enable(TIMER_OCMP_IT_ENABLE); 
  
						/* This enables output compare 1 function */
						TIMERB_OCMP_Mode(TIMER_OCMP_1,TIMER_CMP_VAL,TIMER_OUTPUT_F);
						code=-1;
						break;

			case 3: //Normal Mode:
					  //Sense temparature and write to EEPROM. If critical value
					  //then LED glows and message displayed on hyperterminal
						TIMERB_Mode_Disable(TIMER_MODE_9);
						average=0;
						code=-1;
						
						/*After completion of 1 sec the average of the temperature samples is calculated and
							displayed on hyperterminal.*/

						if (t_50ms==0) //t_50ms gets 0 value in function TRtc_CntUpdate after every 1 sec approx.
					  	{
					  		//if(temp_in==0)
							for(count=0; count < MAX_NO_SAMPLE_VAL; ++count)
							{
								temp_in=temp_arr[count]*CONVERSION_FACTOR;
								temp_in -=273;//Convert Kelvin temparature to Celcuis
								temp_in /= 100;//Do away with LSBytes
								average+=temp_in;
							}
							temp_in=average>>4;
							
							if (temp_in < min)
							{
								min=temp_in;						
							}
							if (temp_in > max)
								max=temp_in;
					
							/*If Temparature value beyond threshold then display message on hyperterminal
							and LEDs toggle*/
							if ((temp_in<critical_temp_low) || (temp_in>critical_temp_high))
							{
								TIMERB_Mode_Disable(TIMER_MODE_9);
								SCI_PutBuffer(buff6,(unsigned char)sizeof(buff6));
	      					while(!(SCI_IsTransmitCompleted()));
				      		Led_Toggle();
				      		TIMERB_Init(TIMER_FCPU_8);	   /* Set the Timer Frequency = Fcpu/8 */

								/* Enable the Output Compare interrupt */	
								TIMERB_IT_Enable(TIMER_OCMP_IT_ENABLE); 
  
								/* This enables output compare 1 function */
								TIMERB_OCMP_Mode(TIMER_OCMP_1,TIMER_CMP_VAL,TIMER_OUTPUT_F);
							}
				
							if	(temp_in<0)
								Buff_Out1[0]=(unsigned char) '-';
							else
								Buff_Out1[0]=(unsigned char) '+';
					
							/*Store the decimal equivalent of 3digit temparature in Buff_Out1*/
							for(ctr=(SIZE_OF_BUFFER-1);ctr>=1;--ctr)
							{
								Buff_Out1[ctr]=(unsigned char) (temp_in % 10) +'0';
								temp_in/=10;			
							}
							
							SCI_PutBuffer(buffer,(unsigned char)SIZE_OF_BUFFER);
							while(!(SCI_IsTransmitCompleted()));
						}

						/*After completion of 1 hr the min : max temperature value in 1 hr duration is recorded in EEPROM*/
						if (hour_flag=='t')
						{
							hour_flag='f';
					      SCI_PutBuffer(buff7,(unsigned char)sizeof(buff7));
					      while(!(SCI_IsTransmitCompleted()));
				
							/*If number of temparature values stored in EEPROM exceeds the maximum limit,
							reset eeprom_addr to 0x00*/	
							if (no_of_temp_vals==MAX_NO_OF_TEMP_VALS)
							{
								eeprom_addr=BASE_ADDR;
								no_of_temp_vals=0;
							}
							if	(min<0)
								Buff_Out1[0]=(unsigned char) '-';
							else
								Buff_Out1[0]=(unsigned char) '+';
					
							/*Store the decimal equivalent of 3digit temparature in Buff_Out1*/
							min_copy=min;
							for(ctr=(SIZE_OF_BUFFER-1);ctr>=1;--ctr)
							{
								Buff_Out1[ctr]=(unsigned char) (min_copy % 10) +'0';
								min_copy/=10;			
							}
							
							
							/*Write temparature value to EEPROM*/
							I2C_EEPROM_WRITE(eeprom_addr,buffer,SIZE_OF_BUFFER);
							Delay_1();
					      Delay_1();
							eeprom_addr+=(unsigned char)SIZE_OF_BUFFER;/*increment memory address variable*/
							++no_of_temp_vals;
							
							/*If number of temparature values stored in EEPROM exceeds the maximum limit,
							reset eeprom_addr to 0x00*/	
							if (no_of_temp_vals==MAX_NO_OF_TEMP_VALS)
							{
								eeprom_addr=BASE_ADDR;
								no_of_temp_vals=0;
							}
							
							if	(max<0)
								Buff_Out1[0]=(unsigned char) '-';
							else
								Buff_Out1[0]=(unsigned char) '+';
					
							/*Store the decimal equivalent of 3digit temparature in Buff_Out1*/
							max_copy=max;
							for(ctr=(SIZE_OF_BUFFER-1);ctr>=1;--ctr)
							{
								Buff_Out1[ctr]=(unsigned char) (max_copy % 10) +'0';
								max_copy/=10;			
							}
			
							/*Write temparature value to EEPROM*/
							I2C_EEPROM_WRITE(eeprom_addr,buffer,SIZE_OF_BUFFER);
							Delay_1();
					      Delay_1();
							eeprom_addr+=(unsigned char)SIZE_OF_BUFFER;/*increment memory address variable*/
							++no_of_temp_vals;
							
							min=999;/*initialize min, max values for next hour*/
							max=0;
							
						}
						TIMERB_Init(TIMER_FCPU_8);	   /* Set the Timer Frequency = Fcpu/8 */

						/* Enable the Output Compare interrupt */	
						TIMERB_IT_Enable(TIMER_OCMP_IT_ENABLE); 
  
						/* This enables output compare 1 function */
						TIMERB_OCMP_Mode(TIMER_OCMP_1,TIMER_CMP_VAL,TIMER_OUTPUT_F); //Interrupt occurs after 50ms
						
					break;
		} //end of switch case
		
		IO_Input(IO_PULL_UP, IO_PORT_C,0x20); //Check whether Button 5 is pressed or not
		IO_Input(IO_PULL_UP, IO_PORT_C,0x80); //Check whether Button 6 is pressed or not
		if(!(IO_Read(IO_PORT_C) & 0x20))
			code=1;
		else if(!(IO_Read(IO_PORT_C) & 0x80))
			code=2;

	}//end of while loop
}//end of main


void PeriphInit ( void ) 
{
	/* I/O Port initialization */
	IO_Init();
	IO_Output(IO_PUSH_PULL, IO_PORT_F, IO_PIN_1);
	IO_Input(IO_PULL_UP, IO_PORT_C,0x20);
	IO_Input(IO_PULL_UP, IO_PORT_C,0x80);
	SCI_Init(SCI_DEFAULT_PARAM1, SCI_DEFAULT_PARAM2);
	
	/* Baud Rate= fcpu / (16 * ETPR * PR * TR)
	ETPR =0x27, PR=TR=0.
	Here fcpu=6 MHz as RLink's 12 MHz oscillator is used. 
	Option byte setting used is Byte0: FF, Byte1: F7. */
	SCI_Extend_Baudrate(BAUD_PRE,Ext_TPR,Ext_RPR);//Set RX Baudrate (real= 9615)
												  //Set TX Baudrate (real= 9615)
	
	SCI_Mode(SCI_TX_ENABLE|SCI_RX_ENABLE);
	
	
}

void Delay(void)
{ 
	int i;
	for(i=0;i<20000;++i);
}

void Delay_1(void)
{   
	unsigned char i; 
	int j;
	for (i=0;i<10;i++)
	{
		for (j=0;j<20000;j++); 
	} 
}

void Led_Toggle(void)
{
	int i=0;
	for(i=0;i<30;++i)
	{
		IO_Write(IO_PORT_F,IO_PIN_1,IO_DATA_HIGH); //LED connected to Pin1 of PortF will toggle
		Delay();
		IO_Write(IO_PORT_F,IO_PIN_1,IO_DATA_LOW);
		Delay();
	}
}


void SCI_Read_Data(void)
{
	SCI_RxError_t Err = 0;
   
	SCI_Mode(SCI_RX_ENABLE);
	Err = SCI_GetBuffer(Buff_Out1,(unsigned char) SIZE_OF_BUFFER);    
	if(Err == SCI_RECEIVE_OK)                       /*Checks the error status*/
	{
		Nop                                                  /* Reception OK*/
	}                                                         
	else                                     /*Error Ocurred during reception*/
	{
		if(Err && SCI_NOISE_ERR)
		{
			SCI_Forced_Clear_Flag();
		}
		if(Err && SCI_OVERRUN_ERR)
		{
			SCI_Forced_Clear_Flag();
		}
		if(Err && SCI_FRAMING_ERR)
		{
			SCI_Forced_Clear_Flag();
		}
		if(Err && SCI_PARITY_ERR)
		{
			SCI_Forced_Clear_Flag();
		}
	}
    
	SCI_Mode(SCI_TX_ENABLE);
	SCI_PutBuffer(Buff_Out1,(unsigned char)SIZE_OF_BUFFER);
	while(!(SCI_IsTransmitCompleted()));
}


void I2C_EEPROM_WRITE(unsigned char sub_add, unsigned char *buffer, int size)
{

	I2C_Init(I2C_ENABLE_ACK);       /* For interrupt driven mode */
	I2C_MultiMaster_Config(); 
	I2C_Select_Speed(I2C_DEFAULT_PARAM2,50);/* Check for standard speed Mode */
	Delay_1();
	Delay_1();

	I2C_Generate_Start();                       /* Check if START bit is set */
	while(!((I2C_IsTransmitCompleted())== I2C_START_OK));
	I2C_Load_Address(0xA0,I2C_TX_MODE);

	while(!(I2C_IsTransmitCompleted()== I2C_ADD_TX_OK)); 
 
	I2C_Load_Address(sub_add,I2C_SUB_ADD);               /* Send EEPROM sub Address */

	while(!(  I2C_IsTransmitCompleted()== I2C_DATA_TX_OK));
       
	switch (I2C_PutBuffer (buffer,size)) // Check data transmission status 
	{
		case I2C_TX_AF:
							TX_Byte_Ret = 0x01;
							I2C_Error_Clear () ;
							break;
		case I2C_TX_ARLO:                          // Disconnect data line 
							TX_Byte_Ret = 0x02;
							I2C_Error_Clear () ;
							break;
		case I2C_TX_BERR:
							TX_Byte_Ret = 0x03;
							I2C_Error_Clear () ;
							break;
		case I2C_DATA_TX_OK:
							Nop
							TX_Byte_Ret = 0x04;
							break;
		default:
							break;
	}
         
	I2C_Generate_Stop();
}

void I2C_EEPROM_READ(unsigned char sub_add, int size)
{
	/*Data reading from EEPROM below:*/
	I2C_Init(I2C_ENABLE_ACK);       /* For interrupt driven mode */
	I2C_MultiMaster_Config(); 
	I2C_Select_Speed(I2C_DEFAULT_PARAM2,50);/* Check for standard speed Mode */
	Delay_1();
	Delay_1();
      
	I2C_Generate_Start();
	while(!(I2C_IsTransmitCompleted()== I2C_START_OK));
	I2C_Load_Address(0xA0,I2C_TX_MODE);             /* Send EEPROM Address */
	
	while(!( I2C_IsTransmitCompleted()== I2C_ADD_TX_OK));

	I2C_Load_Address(sub_add,I2C_SUB_ADD);         /* Send EEPROM sub Address */
	while(!( I2C_IsTransmitCompleted()== I2C_DATA_TX_OK));
	I2C_Generate_Stop();                                  /* Generate Stop */

	I2C_Generate_Start();                            /* Generate START bit */   
	while(!(I2C_IsTransmitCompleted()== I2C_START_OK));
	I2C_Load_Address(0xA0,I2C_RX_MODE);             /* Send EEPROM Address */
    
	while(!( I2C_IsTransmitCompleted()== I2C_ADD_TX_OK));
	I2C_GetBuffer (Buff_In1,size);

	I2C_Peripheral_Disable();
	Delay_1();
	Delay_1();
	SCI_PutBuffer(Buff_In1,(unsigned char)size);		
	while(!(SCI_IsTransmitCompleted()));

	SCI_PutByte('\n');
	while(!(SCI_IsTransmitCompleted()));
	SCI_PutByte('\r');
	while(!(SCI_IsTransmitCompleted()));
}

void TRtc_CntUpdate(void)                /* Function for updating the Counters */
{
	t_50ms++;      		                  /* 50ms is completed*/
	if(t_50ms == 20)	        		 /* 1 sec is completed */
	{                                               
		no_of_sample_vals=0;
		code=3;
		t_50ms = 0;                            /* Clear 50ms counter */
		t_sec++;		           /* Increment second counter */
		if(t_sec == 60)             		  /* 1 min is completed*/
		{
			hour_flag='t';
			code=3;	
			t_sec = 0;                     /* Clear second counter */
			t_min++;                   /* Increment minute counter */
			if(t_min == 60)     		/* 1 hour is completed */
			{
				hour_flag='t';
				code=3;
				t_min = 0;             /* Clear minute counter */
				t_hour++;            /* Increment hour counter */
				if(t_hour == 24)    	 /* 1 day is completed */
				{
					t_hour = 0;      /* Clear hour counter */
				}
			}
		}
	}		             
}

/********************************************************************************
Interrupt Subroutine for TIMERB
********************************************************************************/
/*-------------------------------------------------------------------------------
 ROUTINE NAME : TIMERB_IT_Routine
 INPUT        : None
 OUTPUT       : None 
 DESCRIPTION  : Interrupt service routine 
 COMMENTS     : This gets automatically executed when any of the timer 
                interrupt is enabled. 
-------------------------------------------------------------------------------*/
#ifdef USE_TIMERB 
#ifdef _HIWARE_                                    /* Test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS              /* Additional registers will be saved */
#else
#ifdef _COSMIC_                                    /* Test for Cosmic Compiler */
@interrupt				           
#else
#error "Unsupported Compiler!"                  /* Compiler Defines not found! */ 
#endif
#endif
void TIMERB_IT_Routine(void)
{
/*This interrupt routine is executed after every 50ms approx*/
	
	
	
	
	/* Interrupt generated by OCF1 */
	if (no_of_sample_vals < MAX_NO_SAMPLE_VAL)	//If MAX NO OF SAMPLES are taken then temperature
	{                                            //values will not be recorded in array temp_arr
		ADC_Enable ();				
		while (!(ADC_Test_Conversn_Complete ())); //check for the EOC
		temp_arr[no_of_sample_vals++]= ADC_Conversn_Read ();
   	ADC_Disable ();
   }

	if(TIMERB_Status_Flag(TIMER_FLAG_OCF1)==TRUE)  
	{ 
		TIMERB_Init(TIMER_FCPU_8);
		TIMERB_OCMP_Mode(TIMER_OCMP_1,TIMER_CMP_VAL,TIMER_OUTPUT_F); //Re-initialize the timer, so that
																				//interrupt occurs after next 50ms
		TIMERB_IT_Enable(TIMER_OCMP_IT_ENABLE);
		TIMERB_Clear_Flag(TIMER_FLAG_OCF1);         /* Clear OCF1 flag */
		TRtc_CntUpdate();        /* Function for updating the Counters */		
		TIMERB_Clear_Flag(TIMER_FLAG_OCF2);  /* Clear OCF2 flag, if set*/
	}              
	else
	{
        	TIMERB_Clear_Flag(TIMER_FLAG_OCF2);    	     /* Clear OCF2 flag*/
	}
//	TBCLR=0x00;
}
#endif
