/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : adc.h
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : ADC module header file
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------*/	

#ifndef ADC_H
#define ADC_H     

/* Includes ------------------------------------------------------------------*/

#include "pmac_param.h"
#include "ST7lib_config.h"     	          /*Selection of device and compiler */

/* Exported types ------------------------------------------------------------*/

typedef enum {
							ADC_DEFAULT      = (unsigned char) 0x00,
							ADC_SPEED        = (unsigned char) 0x40,
							ADC_SLOW         = (unsigned char) 0x08,
							ADC_AMPLIFIER_ON = (unsigned char) 0x04,
							ADC_AMPLIFIER_CAL= (unsigned char) 0x10
						 } Typ_ADC_InitParameter;

/* Exported constants --------------------------------------------------------*/

#define ADC_SPEED_SET         0x40
#define ADC_ON                0x20
#define ADC_OFF               0xDF
#define ADC_EOC               0x80
#define ADC_SEL_CHNL1         0xF0
#define ADC_SEL_CHNL2         0xF8

/* Exported macro ------------------------------------------------------------*/

#define ADC_Enable() (ADCCSR |= 0x20)          /* macro for Enabling the adc */

#define ADC_Disable() (ADCCSR &= 0xDF)        /* macro for disabling the adc */

/* Exported functions ------------------------------------------------------- */

unsigned int ADC_Conversn_Read (void);                 /* Read the conversion*/

void ADC_Init(Typ_ADC_InitParameter InitValue);             /* Initialize ADC*/
BOOL ADC_Test_Conversn_Complete (void);   /* Wait till conversion is complete*/
void ADC_Select_Channel (unsigned char ADC_AIN);/* Select the desired channel*/

unsigned char Get_Pot1(void);
#ifdef PHASE_READING_FROM_POT2 
unsigned char Get_Pot2(void);
#endif
#endif

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/



