/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : adc.c
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : ADC module
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "lib.h"
#include "adc.h"           /* Declaration of functions used in top level file*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/


/*-----------------------------------------------------------------------------
ROUTINE NAME : 	ADC_Init
INPUT        : 	ADC_SPEED (Sets the Clock of ADC)
								ADC_ONESHOT (Configures the ADC in oneshot mode)
								ADC_IT_ENABLE (Enables the Interrupt)
								ADC_AMPLIFIER_ON (Enables the Amplifier)
								ADC_AMPLIFIER_CAL (Calibrates the Amplifier)
								ADC_SLOW (Sets the Clock of ADC)
								ADC_DEFAULT (Configures the ADC in Default mode)
OUTPUT       : 	None.
DESCRIPTION  : 	ADC peripheral initialisation routine.
COMMENTS     : 	User has to pass the InitValue from INPUT.More than one 
								INPUT parameters can be passed by Logically ORing the INPUTs
-----------------------------------------------------------------------------*/

void ADC_Init (Typ_ADC_InitParameter InitValue) 
{ 
    unsigned char Temp;                    /* Only for reading the registers */
   
	ADCCSR  = ADC_DEFAULT;              /* Clear ADC control status register */
	ADCDRL  = ADC_DEFAULT;                     /* Clear the ADC data register*/
	ADCDRL  = (unsigned char)InitValue;  /* Initialise ADC Data Low Register */
	if(InitValue & ADC_SPEED_SET)
	{
	    ADCCSR  = ADC_SPEED_SET;                            /* Set SPEED bit */
	}
	Temp    = ADCDRH;                                       /* Clear EOC flag*/
	
} 
/* ---------------------------------------------------------------------------
 ROUTINE NAME : ADC_Test_Conversn_Complete
 INPUT        : None
 OUTPUT       : TRUE or FALSE
 DESCRIPTION  : Check if the A/D Conversion is complete.
 COMMENTS     : This function can be looped till the convertion is complete.
 ----------------------------------------------------------------------------*/
 
BOOL ADC_Test_Conversn_Complete (void)
{           
     if(ADCCSR & ADC_EOC)                               /* Check the EOC bit */
     {
         return(TRUE);                  /* Return the status of the EOC flag */
     }
     else
     {
         return(FALSE);
     }
}

/* ----------------------------------------------------------------------------
 ROUTINE NAME : ADC_Select_Channel
 INPUT        : ADC_AIN (Channel no.)
 OUTPUT       : None
 DESCRIPTION  : Selects Analog input channel 0,1,2,3........15
 COMMENTS     : ADC_AIN depends upon the device used
 ----------------------------------------------------------------------------*/
 
void ADC_Select_Channel (unsigned char ADC_AIN)
{
     						 /* Select the analog channel for the conversion */
    ADCCSR &= ADC_SEL_CHNL1;    
    ADCCSR |= ADC_AIN;                       /* Pass the value of the channel*/
	
}            

/* ----------------------------------------------------------------------------
 ROUTINE NAME : Get_Pot1
 INPUT        : None
 OUTPUT       : Channel 5 converted value
 DESCRIPTION  : Wait until the end of the conversion and then 
								return the converted value
 COMMENTS     : 
 ----------------------------------------------------------------------------*/

u8 Get_Pot1(void)
{
 u8 Ch5_Voltage;
   ADC_Select_Channel(5);
   while (!ADC_Test_Conversn_Complete());
   Ch5_Voltage=ADCDRH;

   return (u8)(Ch5_Voltage);
}

/* ----------------------------------------------------------------------------
 ROUTINE NAME : Get_Pot2
 INPUT        : None
 OUTPUT       : Channel 6 converted value
 DESCRIPTION  : Wait until the end of the conversion and then 
								return the converted value
 COMMENTS     : 
 ----------------------------------------------------------------------------*/

u8 Get_Pot2(void)
{
   u8 Ch6_Voltage;   
   
   ADC_Select_Channel(6);
   while (!ADC_Test_Conversn_Complete());
   Ch6_Voltage=ADCDRH;
   return (u8)(Ch6_Voltage);

}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/