/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : My_functions.h
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : Customozed functions header file
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------*/	 
#ifndef MY_FUNCTIONS_H
#define MY_FUNCTIONS_H 

/* Includes ------------------------------------------------------------------*/

 #include "lib.h"
 #include "ST7lib_config.h"  

/* Private typedef -----------------------------------------------------------*/

typedef enum {CW,CCW} direction;

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

void Set_Spinning_Direction(direction dir);   

u16 Freq_computing(u16 divisor);    

#ifdef PHASE_READING_FROM_POT2
u16 Get_Phase_angle(void);   
#else
u16 Get_Phase_angle(u16 frequency);
#endif


#ifdef V_by_f_limitation
u8 Get_Max_volt(u16 frequency);
#endif  

#ifdef ROTOR_ALIGNMENT
 void DoRotorAlignment(void);    
#else
 void EnableTimersInterrupts(void);  
#endif

#if DRIVING_MODE==OPEN_LOOP 
u8 Get_Target_Voltage(void);
#endif

#if DRIVING_MODE==OPEN_LOOP 
u16 Get_Target_Speed();
void DoMotorControl(u16 target_freq);
#endif
 
u16 Get_Rotor_Freq(void);

void Soft_start(void);  

#endif                                      
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/