/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : PMAC_Param.h
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : PMAC motor control parameters
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/************************  MOTOR CHARACTERIZATION ****************************/
#define POLES_PAIRS_NUMBER 2


/************************  DRIVING MODE SELECTION ****************************/
#define OPEN_LOOP 0
#define CLOSED_LOOP 1
 
#define DRIVING_MODE OPEN_LOOP

/************************ START-UP PHASE ********************************/

#define START_SPEED (u16) 250         // in rpm

//comment to eliminate rotor alignment phase
//#define ROTOR_ALIGNMENT

#define START_UP_DURATION (u16) 750  // in msec
#define START_VOLT (u8) 110    // in 1/255 unit
#define FIN_VOLT (u8)250            //  in 1/255 unit

#ifdef ROTOR_ALIGNMENT
#define ALIGNMENT_DURATION  (u16) 750  //Alignment duration in msec
#define FINAL_DUTY  (u8) 70        //Final duty cycle in 1/255 unit  (85 <=> 33%)
// Initilization of sine wave phase after alignment,
// expressed in 1/65535 unit (i.e. 32768 = 180)
#define START_PHASE  (u16) 0 
#endif


/******************************* Phase shift definition **********************/

//comment to enable Phase-Frequency linear relationship
#define PHASE_READING_FROM_POT2    


#ifdef PHASE_READING_FROM_POT2 

#define MIN_PHASE  (u16) 0 //in 1/65535 unit  180 <=> 32768   
#define MAX_PHASE  (u16) 65535//in 1/65535 unit  180 <=> 32768

#else

#define PH_AT_LOWSPEED  (u16) 61000  //in 1/65535 unit  180 <=> 32768 
#define PH_AT_HIGHSPEED  (u16) 65000 //in 1/65535 unit  180 <=> 32768 
#define PH_LOWSPEED  (u16) 1000    //in rpm
#define PH_HIGHSPEED  (u16) 5000		//in rpm
#endif
 

/****************************  OPEN_LOOP  *******************************/

#if DRIVING_MODE==OPEN_LOOP 

#define MAX_VOLTAGE (u8) 255  // Expressed in 0.866*Vbus/255 unit  
#define MIN_VOLTAGE (u8) 0   // Expressed in 0.866*Vbus/255 unit 

#endif

/****************************  CLOSED_LOOP  *******************************/
#if DRIVING_MODE==CLOSED_LOOP 

	#define SAMPLING_TIME (u8) 80  //msec
	#define kp (u8) 12
	#define	ki (u8) 10    
  
    /*******  SPEED  PARAMETERS  *******/
  #define MIN_SPEED (u16) 2000    //in rpm    
  #define MAX_SPEED (u16) 5000   // in rpm     
  #define CL_SPEED_VALIDATION (u16) 1000  // in rpm Minimum speed to validate closed loop
 
#endif

/************************   V/f limitation curve   *********************************/ 
// Comment to disable V/f limitation

//#define V_by_f_limitation

#ifdef V_by_f_limitation

#define V_AT_LOWSPEED 	(u8) 200  //in 1/255 unit   
#define V_AT_HIGHSPEED  (u8) 255 //in 1/255 unit   
#define V_LOWSPEED   (u16) 1500    //in rpm
#define V_HIGHSPEED  (u16) 4000   //in rpm

#endif




/************************ Do not modify***********************************************/

#define START_FREQ ((u32)((u16)(START_SPEED)*POLES_PAIRS_NUMBER)/(60*0.1192))
#define SLEW_RATE (u16)(((u16)(FIN_VOLT-START_VOLT)*256)/(u16)(START_UP_DURATION))
#define DELTA_ALIGN (u16)(((u16)(FINAL_DUTY)*256)/((u16)(ALIGNMENT_DURATION)))

#ifdef PHASE_READING_FROM_POT2 
#define DELTA_PHASE (u16) (MAX_PHASE-MIN_PHASE)
#else     

#define PH_LOWFREQ (u16)(((u32)((u32)(PH_LOWSPEED)*POLES_PAIRS_NUMBER))/(60*0.1192))  
#define PH_HIGHFREQ (u16)(((u32)((u32)(PH_HIGHSPEED)*POLES_PAIRS_NUMBER))/(60*0.1192))  
#define COEFF_PHASE (s32)(32 * ((s32)(PH_AT_HIGHSPEED)-(s32)(PH_AT_LOWSPEED))/((s32)PH_HIGHFREQ-(s32)PH_LOWFREQ))

#endif

#if DRIVING_MODE==CLOSED_LOOP
#define MIN_FREQ (u16)(((u32)(MIN_SPEED)*POLES_PAIRS_NUMBER)/(60*0.1192))
#define MAX_FREQ (u16)(((u32)(MAX_SPEED)*POLES_PAIRS_NUMBER)/(60*0.1192))
#define CL_FREQ_VALIDATION (u16)((u16)(CL_SPEED_VALIDATION*POLES_PAIRS_NUMBER)/(60*0.1192))
#define DELTA_FREQ (u16)(MAX_FREQ-MIN_FREQ)
#endif

#if DRIVING_MODE==OPEN_LOOP
#define DELTA_VOLT (u8) (MAX_VOLTAGE-MIN_VOLTAGE)
#endif

#ifdef V_by_f_limitation

#define V_LOWFREQ (u16)((u16)(V_LOWSPEED*POLES_PAIRS_NUMBER)/(60*0.1192))  
#define V_HIGHFREQ (u16)((u16)(V_HIGHSPEED*POLES_PAIRS_NUMBER)/(60*0.1192)) 
#define COEFF_V (u8)(((u16)(V_AT_HIGHSPEED-V_AT_LOWSPEED)*256)/(u16)(V_HIGHFREQ-V_LOWFREQ))

#endif
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/