/******************************************************************************
COPYRIGHT 2003 STMicroelectronics
Source File Name : st7lib_config.h  
Group            : IPSW,CMG - IPDF
Author           : MCD Application Team
Date First Issued: 04/08/20032
********************************Documentation**********************************
General Purpose - This file is used to select the device and the communication 
				  mode.
********************************Revision History*******************************
_______________________________________________________________________________
Date :07/03/2002                  Release:1.0 
Date :23/09/2002                  Release:2.0 		       		 
******************************************************************************/

#ifndef	ST7LIB_CONFIG_H
#define	ST7LIB_CONFIG_H

#include "st7flite3_periph.h"

#endif /* ST7LIB_CONFIG_H */

/*---------------------------------Define Fcpu-------------------------------*/
#define Fcpu ((unsigned long) 8000000)   
#define Fosc2 ((unsigned long) 8000000)   


/*---------------Selection of SPI mode of communication ---------------------*/

#define SPI_POLLING_TX                          /* Polling mode transmission */
#define SPI_POLLING_RX         					   /* Polling mode reception */
/* #define SPI_ITDRV_WITHOUTBUF_TX */
						/* Interrupt driven without buffer transmission mode */
/* #define SPI_ITDRV_WITHOUTBUF_RX   */
                           /* Interrupt driven without buffer reception mode */ 

/*---------------Selection of Slave mode transmission configuration ---------*/
/* #define SPI_SLAVE_CONFIG                                                  */
                           
/*---------------Selection of I2C mode of communication --------------------*/
#define I2C_POLLING_TX                          /* Polling mode transmission */
#define I2C_POLLING_RX                             /* Polling mode reception */                    
/* #define I2C_ITDRV_WITHOUTBUF_TX */
						/* Interrupt driven without buffer transmission mode */
/* #define I2C_ITDRV_WITHOUTBUF_RX */
                           /* Interrupt driven without buffer reception mode */ 

                                                                                  
                                                                                
/******************************** End of User Part ***************************/


/*****************************Non User Part***********************************/
/*-----------------------------Compiler Selection----------------------------*/     
#ifdef __CSMC__
#define _COSMIC_
#else
#error "Unsupported Compiler!"                 /* Compiler defines not found */
#endif /* __CSMC__ */

 
#include"st7flite3_reg.h"
         	     
/*----------------------------Enumerated data type---------------------------*/
#ifndef enum_type
#define enum_type
typedef enum {
	FALSE	=(unsigned char) 0x00,			
	TRUE   = !(FALSE)                
        }BOOL; 
#endif /* enum_type */

/*---------------------Macros for Assembly instructions----------------------*/   

#ifdef _COSMIC_
#define EnableInterrupts {_asm ("RIM");}  
#define DisableInterrupts {_asm ("SIM");} 
#define Nop {_asm ("nop");} 
#define WaitforInterrupt {_asm ("wfi");} 
#endif /* _COSMIC_ */
     
/******************************** End of Non-user Part ***********************/
	
/**** (c) 2003   STMicroelectronics *************************** END OF FILE **/