/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : lart.c
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : Auto Reload Timer module
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "lart.h"                    /* Declaration of the all the functions */
#include "lib.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
const u8 SINE3RDHARM[256] = {
0,11,22,33,43,54,64,75,85,95,105,114,124,133,142,150,158,166,174,181,    
188,195,201,207,212,217,222,226,230,234,237,240,243,245,247,249,251,252, 
253,254,254,255,255,255,255,254,254,254,253,252,252,251,250,250,249,     
248,248,247,247,246,246,246,245,245,245,245,245,246,246,246,247,247,     
248,249,249,250,251,251,252,253,253,254,254,255,255,255,255,254,254,     
253,253,251,250,248,246,244,242,239,236,232,228,224,220,215,209,204,       
198,191,185,178,170,162,154,146,137,128,119,110,100,90,80,70,59,49,38,     
27,16,5,5,16,27,38,49,59,70,80,90,100,110,119,128,137,146,154,162,170,  
178,185,191,198,204,209,215,220,224,228,232,236,239,242,244,246,248,  
250,251,253,253,254,254,255,255,255,255,254,254,253,253,252,251,251,   
250,249,249,248,247,247,246,246,246,245,245,245,245,245,246,246,246,   
247,247,248,248,249,250,250,251,252,252,253,254,254,254,255,255,255,   
255,254,254,253,252,251,249,247,245,243,240,237,234,230,226,222,217,   
212,207,201,195,188,181,174,166,158,150,142,133,124,114,105,95,85,75,  
64,54,43,33,22,11,0};
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
 u8 volatile SinAmp = START_VOLT;
#ifdef ROTOR_ALIGNMENT
 u16 volatile Phase=START_PHASE;
#else 
 u16 volatile Phase;
#endif
 u16 volatile Freq=START_FREQ;
 volatile u8 SineUpdate;   
 volatile u8 indice;   
 volatile u8 PhaseShift;
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*-----------------------------------------------------------------------------
ROUTINE NAME : AT_TIMER_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the 12-bit Autoreload Timer

COMMENTS     :
-----------------------------------------------------------------------------*/

void ART_Init(void)
{
ATCSR= 0x10; //It sets the counter frequency to 8MHz and enables the Overflow Interrupt 

ATR1H=0x0E;  //It fixes to 15.625KHz the PWM frequency
ATR1L=0x00;  //

DCR0H=0x0E;
DCR1H=0x0E;
DCR2H=0x0E;
 
Enable_Transfer();

PWMCR=0x15;// It enables PWM outputs
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : LART_OVF1_IT_Routine
INPUT/OUTPUT : None

DESCRIPTION  : 12-bit Autoreload Timer Overflow Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt 
void LART_OVF1_IT_Routine(void)
{
#asm 

INC _SineUpdate   ;Update done every 2/15625 sec

BTJF _SineUpdate,#0,NoSineUpdate 

LD A, _Phase+1
ADD A, _Freq+1
LD _Phase+1, A
LD A, _Phase
ADC A, _Freq
LD _Phase,A
LD X,A 

LD A,#0x0f
LD _DCR0H, A
LD _DCR1H, A
LD _DCR2H, A
   
 /*********************   PHASE A  Update  ***********************************/

LD _indice,X
LD A,_SinAmp
LD X, (_SINE3RDHARM,X)
MUL X,A
CP X,#0

JRNE NotZero0       ;if X=0
CLR _DCR0L          ; DCR0L=0
JRT Phase_B_Update  ; Goto Phase_B_Update
                    ;
NotZero0:           ;else

BTJF _indice, #7,PosHalfWave0 ;if indice>128
LD A,#0x0E                    ;{
LD _DCR0H, A                  ;DCR0H=0x0E
NEG X                         ;NegX
                              ;}
PosHalfWave0:

LD A, X                       
LD _DCR0L, A                  

/************************  PHASE B UPDATE  ********************************/
   
Phase_B_Update:
   
LD A,_indice;
ADD A,_PhaseShift
LD _indice,A

LD X, A
LD A,_SinAmp
LD X, (_SINE3RDHARM,X)
MUL X,A
CP X,#0

JRNE NotZero1        ;if X=0
CLR _DCR1L          ; DCR1L=0
JRT Phase_C_Update  ; Goto Phase_C_Update
                    ;
NotZero1:            ;else

BTJF _indice, #7,PosHalfWave1  ;if indice>128
LD A,#0x0E                    ;{
LD _DCR1H, A                  ;DCR1H=0x0E
NEG X                         ;NegX
                              ;}
PosHalfWave1:
LD A, X                       
LD _DCR1L, A               

/********************************* PHASE C UPDATE ******************************/
Phase_C_Update:
   
LD A,_indice;
ADD A,_PhaseShift
LD _indice,A

LD X, A
LD A,_SinAmp
LD X, (_SINE3RDHARM,X)
MUL X,A
CP X,#0

JRNE NotZero2        ;if X=0
CLR _DCR2L          ; DCR2L=0
JRT End_Update      ; Goto Phase_B_Update
                    ;
NotZero2:            ;else

BTJF _indice, #7,PosHalfWave2  ;if indice>128
LD A,#0x0E                    ;{
LD _DCR2H, A                  ;DCR2H=0x0E
NEG X                         ;NegX
                              ;}
PosHalfWave2:

LD A, X                       
LD _DCR2L, A  

End_Update:

BSET _ATCSR2,#0


NoSineUpdate:

LD A, _ATCSR ;reset interrupt flag

#endasm
}  /* End of void AR_TIMER_OF_Interrupt(void) */

/* ---------------------------------------------------------------------------
 ROUTINE NAME : Enable_Transfer
 INPUT        : None
 OUTPUT       : None
 DESCRIPTION  : It enables the value of the DCRx registers to be transferred
								to the DCRx shadow registers after the next overflow event.
 ----------------------------------------------------------------------------*/
void Enable_Transfer(void)
{
   ATCSR2=0x01;
  
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/