/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : lib.h
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : Library with standard definitions and macros
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------*/	

#ifndef LIB_H
#define LIB_H
/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/

typedef unsigned char u8;  				/* unsigned 8 bit type definition */
typedef signed char	  s8;  				/* signed 8 bit type definition */
typedef unsigned int  u16; 				/* unsigned 16 bit type definition */
typedef signed int	  s16; 				/* signed 16 bit type definition */
typedef unsigned long u32; 				/* unsigned 32 bit type definition */
typedef signed long	  s32; 				/* signed 32 bit type definition */
                                       
typedef union {							/* unsigned 16 bit type for 8 & 16 */
          u16 w_form;					/* bit accesses: 16> var.w_form    */
          struct {						/* 8> var.b_form.high/low          */
                  u8 high, low;
          } b_form;
  } TwoBytes;

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
#define SetBit(VAR,Place)         ( VAR |= (1<<Place) )
#define ClrBit(VAR,Place)         ( VAR &= ((1<<Place)^255) )
#define AffBit(VAR,Place,Value)   ((Value) ? \
                                   (VAR |= (1<<Place)) : \
                                   (VAR &= ((1<<Place)^255)))
#define MskBit(Dest,Msk,Src)      ( Dest = (Msk & Src) | ((~Msk) & Dest) )

#define ValBit(VAR,Place)         (VAR & (1<<Place))
/* Exported functions ------------------------------------------------------- */
#endif
/*** (c) 2006 STMicroelectronics ****************** END OF FILE ***/
