/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : lt.c
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : Lite Timer module
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/

#include "lt.h"                      /* Declaration of the all the functions */
#include "lib.h"
#include "My_functions.h"
                    
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

extern u16 timebase_1ms,Phase_angle; 
extern u8 counter;
_Bool count_carry,Is_first_measurement;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*-----------------------------------------------------------------------------
ROUTINE NAME : Timer_Lite_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the Timer Lite

COMMENTS     :
-----------------------------------------------------------------------------*/
void Timer_Lite_Init(void)
{
 LTCSR1   = 0x10;
 LTICR;
}

				/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
/*-----------------------------------------------------------------------------
ROUTINE NAME : Lite Timer 1msec Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer Lite Real Time Clock Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void LT_TB1_IT_Routine(void)
{
 counter++;
 timebase_1ms++; 
 LTCSR1; 
 }

@interrupt						/* Cosmic interrupt handling */

/*-----------------------------------------------------------------------------
ROUTINE NAME : LT_ICAP Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer Lite Input Capture Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 


void LT_ICAP_IT_Routine(void)
{ 
	extern u16 Phase,measure[4];
	extern u8 updated_semiperiod;
	static u8 old_capture, new_capture,m_index;
	u16 period_aux;
 
	old_capture = new_capture;
	new_capture = LTICR;    
	
	if (count_carry==1)
	{	
		counter++;
		count_carry=0;		
	}
	if (ValBit(LTCSR1,3)) // A further LT OVF interrupt	must be considered
	{	
		if (new_capture<120) //LT OVF interrupt to be added now
			counter++;  			
		else   							//LT OVF interrupt to be added in the next period	
			count_carry=1;
	}
	if (counter!=0)
		 period_aux=counter*250-old_capture+new_capture;
	else
		period_aux=new_capture-old_capture; 

	if(ValBit(PADR,0))
	 Phase = Phase_angle; 
	else Phase = (u16)(Phase_angle+32768);

	if(!Is_first_measurement)
	{
		measure[m_index]=period_aux;
		updated_semiperiod = m_index;
		
		m_index++;
		m_index &= 0x03;
	}
	else
		Is_first_measurement=0;	
	counter=0;
   WDGCR=0xFF;
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/