/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* Project					   : PMAC Motor control firmware lybrary for ST72FLITE35  
* File Name          : main.c
* Author             : MPA Systems Lab
* Date First Issued  : 01/02/2005
* Description        : Auto Reload Timer module
* Comment            : Sinus Frequency=0.1192*Freq;
											 Target freq (Hz) =0.1192 * target_freq
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "lib.h" 
#include "pmac_param.h" 
#include "ST7lib_config.h"    
#include "My_functions.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

 #if DRIVING_MODE==CLOSED_LOOP
 s16 old_error, error, delta_error,prop_term,integral_term;  
 #endif 
 
 u8 clock_calibration_H @0xDEE0;
 u8 clock_calibration_L @0xDEE1;
 u8 i=0,updated_semiperiod=4;
 u8 counter;
 u16 Phase_angle,measure[4], timebase_1ms=0,Freq_buf;   
 _Bool start_up_on_going;

 extern u8 SinAmp;  
 extern u16 Phase,Freq;
 
/* Private function prototypes -----------------------------------------------*/

 #if DRIVING_MODE==CLOSED_LOOP
 u16 Get_Target_Speed(void);
 void DoMotorControl(u16 target_freq);
 #endif
 #if DRIVING_MODE==OPEN_LOOP 
  u8 Get_Target_Voltage(void); 
 #endif 
 
/* Private functions ---------------------------------------------------------*/
  
/******************************************************************************
                          MAIN APPLICATION BEGINS
******************************************************************************/
void main (void)                    
{     
   RCCR = clock_calibration_H; //It calibrates RC oscillator
	 
	 SICSR = clock_calibration_L & 0x60;	//It calibrates RC oscillator
	 
   ART_Init();  //Auto Reload Timer Initialization

   PORTS_Init();//Ports Initilization
                              
   Timer_Lite_Init(); //Lite Timer Initialization
   
   ADC_Init(ADC_SLOW);    //
       			 //A/D Converter Initialization
   ADC_Enable();        //

#ifdef ROTOR_ALIGNMENT
   DoRotorAlignment();
#else
   EnableTimersInterrupts();

   EnableInterrupts;     
#endif
    
    Set_Spinning_Direction(CW);
    
while (1)
    { 
#ifdef PHASE_READING_FROM_POT2
      Phase_angle = Get_Phase_angle();
#else
      Phase_angle = Get_Phase_angle(Freq_buf);
#endif       
      
     Freq = Get_Rotor_Freq();

	 if (start_up_on_going == 1)
      Soft_start();
#if DRIVING_MODE == OPEN_LOOP    
      else
       SinAmp = Get_Target_Voltage();
  
#else   // DRIVING_MODE=CLOSED_LOOP
      else
/*It calls PI regulation routine, acting on the average frequency
  on two succesive electrical periods                          */
                      
       if (timebase_1ms > SAMPLING_TIME)   
       {                                 
       DoMotorControl(Get_Target_Speed());   
       timebase_1ms = 0;        
       }            
#endif    
  
    }
}                   
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/