/*******************************************************************************
COPYRIGHT 2003 STMicroelectronics
Source File Name : st72FLITE3_reg.h
Group            : IPSW,CMG - IPDF
Author           : MCD Application Team
Date First Issued: 23/09/2003
********************************Documentation***********************************
General Purpose - This file contains all the hardware c files for peripherals of
 st72FLITE3.

********************************Revision History********************************
_______________________________________________________________________________
Date :23/09/2003                  Release:2.0
____________________________________________________________________________  */

#ifndef ST72fLITE3_REG_H
#define ST72fLITE3_REG_H

#include "ST7lib_config.h"

#ifdef _HIWARE_

/* IO Ports Hardware Registers */
/* Port A Registers */

#pragma DATA_SEG SHORT PORTA
    extern volatile unsigned char PADR;               /* PORT A data register */          
    extern volatile unsigned char PADDR;    /* PORT A data direction register */
    extern volatile unsigned char PAOR;             /* PORT A option register */
/* Port B Registers */
                                                     
#pragma DATA_SEG SHORT PORTB
    extern volatile unsigned char PBDR;               /* PORT B data register */          
    extern volatile unsigned char PBDDR;    /* PORT B data direction register */
    extern volatile unsigned char PBOR;             /* PORT B option register */

/* LITE TIMER 2 HARDWARE REGISTERS */
#pragma DATA_SEG SHORT LT
    extern volatile	unsigned char LTCSR2;      /* Control and stats register 2*/
    extern volatile unsigned char LTARR;              /* Auto-Reload Register */
    extern volatile unsigned char LTCNTR;                 /* Counter Register */
    extern volatile unsigned char LTCSR1;      /* Control and stats register 1*/
    extern volatile	unsigned char LTICR;            /* Input capture register */
    
/* LART HARDWARE REGISTERS */
#pragma DATA_SEG SHORT LART
    extern volatile	unsigned char ATCSR;         /* Control/Status Register   */
    extern volatile	unsigned char CNTR1H;       /* Counter Register 1 High    */
    extern volatile	unsigned char CNTR1L;        /* Counter Register 1 Low    */
    extern volatile	unsigned char ATR1H;         /* Autoreload Register 1 High*/
    extern volatile	unsigned char ATR1L;         /* Autoreload Register 1 Low */
    extern volatile	unsigned char PWMCR;         /* PWM Output control Reg    */
    extern volatile	unsigned char PWM0CSR;     /* PWM 0 Output control/Status */ 
    extern volatile	unsigned char PWM1CSR;     /* PWM 1 Output control/Status */
    extern volatile	unsigned char PWM2CSR;     /* PWM 2 Output control/Status */
    extern volatile	unsigned char PWM3CSR;     /* PWM 3 Output control/Status */
    extern volatile	unsigned char DCR0H;       /* PWM 0 Duty Cycle HRegister  */
    extern volatile	unsigned char DCR0L;         /* PWM Duty Cycle LRegister  */
    extern volatile	unsigned char DCR1H;       /* PWM 1 Duty Cycle HRegister  */
    extern volatile	unsigned char DCR1L;       /* PWM 1 Duty Cycle LRegister  */
    extern volatile	unsigned char DCR2H;       /* PWM 2 Duty Cycle HRegister  */ 
    extern volatile	unsigned char DCR2L;       /* PWM 2 Duty Cycle LRegister  */
    extern volatile	unsigned char DCR3H;       /* PWM 3 Duty Cycle HRegister  */ 
    extern volatile	unsigned char DCR3L;       /* PWM 3 Duty Cycle LRegister  */ 
    extern volatile	unsigned char ATICRH;       /* Input Capture Register High*/
    extern volatile	unsigned char ATICRL;        /* Input Capture Register Low*/
    extern volatile	unsigned char ATCSR2;            /*Timer Control Register */
    extern volatile	unsigned char BREAKCR;          /* Break Control Register */
    extern volatile	unsigned char ATR2H;        /* Auto-Reload Register 2 High*/    
    extern volatile	unsigned char ATR2L;        /* Auto-Reload Register 2 Low */
    extern volatile	unsigned char DTGR;        /* Dead Time Generator Register*/
    
/* 12 bit Registers for LART */
    volatile unsigned int CNTR  @0x000E;   /* Counter Register                */
    volatile unsigned int ATR1  @0x0010;   /* Autoreload Register             */
    volatile unsigned int DCR0  @0x0017;   /* Duty Cycle Register 0           */
    volatile unsigned int DCR1  @0x0019;   /* Duty Cycle Register 1           */
    volatile unsigned int DCR2  @0x001B;   /* Duty Cycle register 2           */
    volatile unsigned int DCR3  @0x001D;   /* Duty Cycle Register 3           */
    volatile unsigned int ATICR @0x001F;   /* Input Capture Register          */
    volatile unsigned int ATR2  @0x0023;   /* Autoreload Register             */


/* Watchdog Hardware registers */
#pragma DATA_SEG SHORT WDG
    extern volatile unsigned char WDGCR;         /* Watchdog Control Register */

/* FLASH Hardware Registers */
#pragma DATA_SEG SHORT FLASH
    extern volatile unsigned char FCSR;       /* Flash Control/Status Register*/
    
/* EEPROM Hardware Registers */  
#pragma DATA_SEG SHORT EEPROM
    extern volatile unsigned char EECSR;/* Data EEPROM Control/Status Register*/


/* SPI Hardware Registers */  
#pragma DATA_SEG SHORT SPI
    extern volatile unsigned char SPIDR;                /* SPI Data register  */
    extern volatile unsigned char SPICR;             /* SPI Control register  */
    extern volatile unsigned char SPICSR;             /* SPI Status register  */
     
/* ADC HARDWARE REGISTERS */
#pragma DATA_SEG SHORT ADC
    extern volatile unsigned char ADCCSR;    /* ADC control & status register */
    extern volatile unsigned char ADCDRH;
    extern volatile unsigned char ADCDRL;
    
/* ITC HARDWARE RREGISTERS */
#pragma DATA_SEG SHORT ITC1
    extern volatile unsigned char EICR;         /*External Interrupt Register */ 

/* MCC HARDWARE REGISTERS */
#pragma DATA_SEG SHORT MCC
    extern volatile unsigned char MCCSR;        /* MCC Control/Status Register*/
    
/* CLK HARDWARE REGISTERS */
#pragma DATA_SEG SHORT CLKR
    extern volatile unsigned char RCCR;      /* RC Oscillator Control Register*/
    extern volatile unsigned char SICSR;
                                    /*System Integrity Control/Status register*/
    
/* ITC HARDWARE REGISTERS */
#pragma DATA_SEG SHORT ITC2 
    extern volatile unsigned char EISR;/*External Interrupt Selection Register*/
        
/* SCI Hardware Registers */
#pragma DATA_SEG SHORT SCI
    extern volatile unsigned char SCISR;    /* Status Register */
    extern volatile unsigned char SCIDR;    /* Data Register */
    extern volatile unsigned char SCIBRR;    /* Baud Rate Register */
    extern volatile unsigned char SCICR1;    /* Control Register 1 */
    extern volatile unsigned char SCICR2;    /* Control Register 2 */
    extern volatile unsigned char SCICR3;    /* Control Register 3 */
    extern volatile unsigned char SCIERPR; /* Extended Receive Prescaler Register */
    extern volatile unsigned char SCIETPR; /* Extended Transmit Prescaler Register */
        
/* AWU HARDWARE REGISTERS */
#pragma DATA_SEG SHORT AWU
    extern volatile unsigned char AWUPR;             /* AWU Prscaler Register */
    extern volatile unsigned char AWUCSR;      /* AWU Control/Status Register */

/* DM HARDWARE REGISTERS */
#pragma DATA_SEG SHORT DM
    extern volatile unsigned char DMCR;                /* DM Control Register */
    extern volatile unsigned char DMSR;                 /* DM Status Register */
    extern volatile unsigned char DMBK1H;    /* DM Breakpoint register 1 High */
    extern volatile unsigned char DMBK1L;     /* DM Breakpoint register 1 Low */
    extern volatile unsigned char DMBK2H;    /* DM Breakpoint register 2 High */          
    extern volatile unsigned char DMBK2L;     /* DM Breakpoint register 2 Low */          

#pragma DATA_SEG DEFAULT
#endif /* _HIWARE_ */

/******************************************************************************/
/******************************************************************************/

#ifdef _COSMIC_

/* IO Ports Hardware Registers */
/* Port A Registers */

    @tiny volatile unsigned char PADR @0x0000;        /* PORT A data register */ 
    @tiny volatile unsigned char PADDR @0x0001;      /*Data direction register*/
    @tiny volatile unsigned char PAOR @0x0002;      /* PORT A option register */
/* Port B Registers */
                                                     

    @tiny volatile unsigned char PBDR @0x0003;        /* PORT B data register */          
    @tiny volatile unsigned char PBDDR @0x0004;     /*Data direction register */
    @tiny volatile unsigned char PBOR @0x0005;      /* PORT B option register */

/* LITE TIMER 2 HARDWARE REGISTERS */
    @tiny volatile	unsigned char LTCSR2 @0x0008;/*Control and stats register2*/
    @tiny volatile unsigned char LTARR @0x0009;       /* Auto-Reload Register */
    @tiny volatile unsigned char LTCNTR @0x000A;          /* Counter Register */
    @tiny volatile unsigned char LTCSR1 @0x000B;/*Control and stats register 1*/
    @tiny volatile	unsigned char LTICR @0x000C;    /* Input capture register */
    
    
/* LART HARDWARE REGISTERS */

    @tiny volatile	unsigned char ATCSR @0x000D; /* Control/Status Register   */
    @tiny volatile	unsigned int CNTR   @0x000E; /* Counter Register 1        */
    @tiny volatile	unsigned char CNTR1H @0x000E; /* Counter Register 1 High  */
    @tiny volatile	unsigned char CNTR1L @0x000F; /* Counter Register 1 Low   */
    @tiny volatile	unsigned int ATR1    @0x0010; /* Autoreload Register 1    */
    @tiny volatile	unsigned char ATR1H @0x0010; /* Autoreload Register 1 High*/
    @tiny volatile	unsigned char ATR1L @0x0011;  /* Autoreload Register1 Low */
    @tiny volatile	unsigned char PWMCR @0x0012; /* PWM Output control Reg    */
    @tiny volatile	unsigned char PWM0CSR @0x0013;/*PWM0 Output control/Status*/ 
    @tiny volatile	unsigned char PWM1CSR @0x0014;/*PWM1 Output control/Status*/
    @tiny volatile	unsigned char PWM2CSR @0x0015;/*PWM2 Output control/Status*/
    @tiny volatile	unsigned char PWM3CSR @0x0016;/*PWM3 Output control/Status*/
    @tiny volatile	unsigned int DCR0   @0x0017; /*PWM0 Duty Cycle Register   */
    @tiny volatile	unsigned char DCR0H @0x0017; /*PWM0 Duty Cycle HRegister  */
    @tiny volatile	unsigned char DCR0L @0x0018; /* PWM Duty Cycle LRegister  */
    @tiny volatile	unsigned int DCR1   @0x0019; /*PWM1 Duty Cycle Register   */    
    @tiny volatile	unsigned char DCR1H @0x0019;/*PWM 1 Duty Cycle HRegister  */
    @tiny volatile	unsigned char DCR1L @0x001A;/*PWM 1 Duty Cycle LRegister  */
    @tiny volatile	unsigned int DCR2   @0x001B; /*PWM2 Duty Cycle Register   */
    @tiny volatile	unsigned char DCR2H @0x001B;/*PWM 2 Duty Cycle HRegister  */ 
    @tiny volatile	unsigned char DCR2L @0x001C;/*PWM 2 Duty Cycle LRegister  */
    @tiny volatile	unsigned int DCR3   @0x001D; /*PWM3 Duty Cycle Register   */
    @tiny volatile	unsigned char DCR3H @0x001D;/*PWM 3 Duty Cycle HRegister  */ 
    @tiny volatile	unsigned char DCR3L @0x001E;/*PWM 3 Duty Cycle LRegister  */ 
    @tiny volatile	unsigned int ATICR @0x001F; /*Input Capture Register     */
    @tiny volatile	unsigned char ATICRH @0x001F;/*Input Capture Register High*/
    @tiny volatile	unsigned char ATICRL @0x0020; /*Input Capture Register Low*/
    @tiny volatile	unsigned char ATCSR2 @0x0021;/* Timer Control Register 2  */
    @tiny volatile	unsigned char BREAKCR @0x0022;  /* Break Control Register */
    @tiny volatile	unsigned int ATR2   @0x0023; /*Autoreload Register        */
    @tiny volatile  unsigned char ATR2H @0x0023;/* Auto-Reload Register 2 High*/
    @tiny volatile  unsigned char ATR2L @0x0024;/* Auto-Reload Register 2 Low */
    @tiny volatile  unsigned char DTGR @0x0025; /*Dead Time Generator Register*/
          
/* Watchdog Hardware registers */
    @tiny volatile unsigned char WDGCR @0x002E;  /* Watchdog Control Register */

/* FLASH Hardware Register */
    @tiny volatile unsigned char FCSR @0x002F; /* Flash Control/Status Register*/
    
/* EEPROM Hardware Registers */  
    @tiny volatile unsigned char EECSR @0x0030;/*EEPROM Control/Stats Register*/

/* SPI HARDWARE REGISTERS */

    @tiny volatile unsigned char SPIDR @0x0031;         /* SPI Data register  */
    @tiny volatile unsigned char SPICR @0x0032;      /* SPI Control register  */
    @tiny volatile unsigned char SPICSR @0x0033;      /* SPI Status register  */
     
/* ADC HARDWARE REGISTERS */
    @tiny volatile unsigned char ADCCSR @0x0034;/*ADC control & stats register*/
    @tiny volatile unsigned char ADCDRH @0x0035; /* Data Register High        */
    @tiny volatile unsigned char ADCDRL @0x0036; /* Data Register Low         */
    
/* ITC HARDWARE RREGISTERS */
    @tiny volatile unsigned char EICR @0x0037;  /*External Interrupt Register */ 

/* MCC HARDWARE REGISTERS */
    @tiny volatile unsigned char MCCSR @0x0038;/* MCC Control/Status Register */
    
/* CLK HARDWARE REGISTERS */
    @tiny volatile unsigned char RCCR @0x0039;/*RC Oscillator Control Register*/
    @tiny volatile unsigned char SICSR @0x003A;
                                    /*System Integrity Control/Status register*/
    
/* ITC HARDWARE REGISTERS */
    @tiny volatile unsigned char EISR @0x003C;
                                      /*External Interrupt Selection Register */

/* SCI Hardware Registers */
    @tiny volatile unsigned char SCISR @0x0040;    /* Status Register */
    @tiny volatile unsigned char SCIDR @0x0041;    /* Data Register */
    @tiny volatile unsigned char SCIBRR @0x0042;    /* Baud Rate Register */
    @tiny volatile unsigned char SCICR1 @0x0043;    /* Control Register 1 */
    @tiny volatile unsigned char SCICR2 @0x0044;    /* Control Register 2 */
    @tiny volatile unsigned char SCICR3 @0x0045;    /* Control Register 3 */
    @tiny volatile unsigned char SCIERPR @0x0046;/*Extended Receive Prescaler Register*/
    @tiny volatile unsigned char SCIETPR @0x0047;/*Extended TransmitPrescaler Register*/
           
/* AWU HARDWARE REGISTERS */    
    @tiny volatile unsigned char AWUPR @0x0049;      /* AWU Prscaler Register */
    @tiny volatile unsigned char AWUCSR @0x004A;/*AWU Control/Status Register */

/* DM HARDWARE REGISTERS */
    @tiny volatile unsigned char DMCR @0x004B;         /* DM Control Register */
    @tiny volatile unsigned char DMSR @0x004C;          /* DM Status Register */
    @tiny volatile unsigned char DMBK1H @0x004D;/*DM Breakpoint register1 High*/
    @tiny volatile unsigned char DMBK1L @0x004E; /*DM Breakpoint register1 Low*/
    @tiny volatile unsigned char DMBK2H @0x004F;/*DM Breakpoint register2 High*/          
    @tiny volatile unsigned char DMBK2L @0x0050;/*DM Breakpoint register 2 Low*/
    
#endif /* _COSMIC_ */    
#endif /* ST72fLITE3 */
       
            
    

 

