/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : Lib_bits.h
* Author             : MPA Systems Lab
* Date First Issued  : 14/03/2005
* Description        : Bit handling macro command.
*                      
********************************************************************************
* History:
* 14/03/2005
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/


#ifndef LIB_BITS_H
#define LIB_BITS_H


#define SetBit(VAR,Place)         ( VAR |= (1<<Place) )
#define ClrBit(VAR,Place)         ( VAR &= ((1<<Place)^255) )
#define ChgBit(VAR,Place)         ( VAR ^= (1<<Place) )
#define AffBit(VAR,Place,Value)   ((Value) ? \
                                   (VAR |= (1<<Place)) : \
                                   (VAR &= ((1<<Place)^255)))
#define MskBit(Dest,Msk,Src)      ( Dest = (Msk & Src) | ((~Msk) & Dest) )

#define ValBit(VAR,Place)         (VAR & (1<<Place))


#define AREA 0x00     /* The area of bits begins at address 0x10. */                   

#define BitClr(BIT)  ( *((unsigned char *) (AREA+BIT/8)) &= (~(1<<(7-BIT%8))) )
#define BitSet(BIT)  ( *((unsigned char *) (AREA+BIT/8)) |=   (1<<(7-BIT%8))  )
#define BitVal(BIT)  ( *((unsigned char *) (AREA+BIT/8)) & (1<<(7-BIT%8)) ) 

#endif
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
