/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : bsp.h
* Author             : MPA Systems Lab
* Date First Issued  : 06/06/2005
* Description        : Defining characteristics of a ethernet support.
*                      
********************************************************************************
* History:
* 06/06/2005
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#ifndef _BSP_H
#define _BSP_H

#ifndef YES
#define YES 1
#endif
#ifndef NO
#define NO 0
#endif

#define SMC8013 1
#define SMC8216 2
#define CS8900  3

/***********************************************************************/
/*                                                                     */
/*                                                                     */
/*      B O A R D - S U P P O R T   P A C K A G E   P R O F I L E      */
/*                                                                     */
/*                                                                     */
/***********************************************************************/

#include "Interface.h"


#define BSP_LITTLE_ENDIAN      YES



/*=====================================================================*/
/*                                                                     */
/*                   T I C K   T I M E R                               */
/*                                                                     */
/*   * BSP_TIMER           - YES if a periodic timer is present        */
/*   * BSP_TIMER_RATE      - Timer  tick rate in ticks per second.     */
/*=====================================================================*/
#define BSP_TIMER              NO //YES
#define BSP_TIMER_RATE         60


/*=====================================================================*/
/*                                                                     */
/*                R E A L - T I M E   C L O C K                        */
/*                                                                     */
/*   * BSP_CLOCK           - YES if real-time clock is present         */
/*                                                                     */
/*=====================================================================*/
#define BSP_CLOCK              NO //YES


/*=====================================================================*/
/*                                                                     */
/*                    L A N   I N T E R F A C E S                      */
/*                                                                     */
/*   * BSP_LANx            - YES if LANx is present                    */
/*   * BSP_LANx_MTU        - Maximum transmission unit (bytes)         */
/*   * BSP_LANx_HWALEN     - Length of hardware address in bytes       */
/*   * BSP_LANx_FLAGS      - Interface flags (per pNA manual)          */
/*     IFF_BROADCAST       0x1     broadcast                           */
/*     IFF_NOARP           0x2     no address resolution protocol      */
/*     IFF_POINTTOPOINT    0x10    interface is point-to-point link    */
/*     IFF_UP              0x80    interface is up                     */
/*     IFF_RAWMEM          0x2000  uses 0 copy buffering scheme        */
/*     IFF_EXTLOOPBACK     0x4000  loopback externally                 */
/*     IFF_POLL            0x8000  interface uses polling              */
/*   * BSP_LANx_MINBUFS    - Minimum # of buffers that can be          */
/*                           configured at system startup time         */
/*   * BSP_LANx_MAXBUFS    - Maximum # of buffers that can be          */
/*                           configured at system startup time         */
/*   If BSP_LANx_MINBUFS and BSP_LANx_MAXBUFS are 0, startup buffer    */
/*   configuration is unavailable.                                     */
/*                                                                     */
/*=====================================================================*/
#define BSP_LAN1               YES
#define BSP_LAN1_MTU           1500
#define BSP_LAN1_HWALEN        6
#define BSP_LAN1_FLAGS         0x2000+0x1
#define BSP_LAN1_BUFFS_MIN     10
#define BSP_LAN1_BUFFS_MAX     200



/*=====================================================================*/
/*                                                                     */
/*                         LAN ETHERCARD                               */
/*                                                                     */
/*=====================================================================*/
#define BSP_LANCARD_MODEL     CS8900    /* lan card model      */
#define BSP_LANCARD_INTLEV    5         /* interrupt level     */
#define BSP_LANCARD_IOADDR    0x320     /* IO address          */
#define BSP_LANCARD_RBASE     0xD0000   /* dual memory address */
#define BSP_LANCARD_16BIT     YES       /* 16 bit/8 bit card   */
#define BSP_LANCARD_SFTCFG    YES       /* soft configurable   */

/*=====================================================================*/
/*                                                                     */
/*         Crystal Semiconductor CS8900 Ethernet Chip                  */
/*                                                                     */
/*=====================================================================*/

/* The following 5 definitions must not be changed */
#define TEN_BASE_T              1       /* Media is 10BaseT twisted pair */
#define AUI                     2       /* Media is AUI */
#define TEN_BASE_2              3       /* Media is 10Base2 (BNC) */
#define LOW                     0       /* DC/DC converter has low enable */
#define HIGH                    1       /* DC/DC converter has high enable */

/* Required definitions */
#define BSP_CS8900_IO_BASE      0x300   /* Base address of IO ports */
#define BSP_CS8900_EEPROM       NO //YES     /* Get config from EEPROM? */


/* The following definitions will only be used if BSP_CS8900_EEPROM is NO */
#define BSP_CS8900_IRQ          10 //5       /* Interrupt request level */

#if (USE_GPIO == YES) //Look Interface.h
#define BSP_CS8900_MEM_MODE     NO     /* MANDATORY */
#else
#define BSP_CS8900_MEM_MODE     NO  /* Use memory mode? */
#endif

#define BSP_CS8900_MEM_BASE     0x01000 //0xCD000 /* Base address of PacketPage */
#define BSP_CS8900_USE_SA       NO //YES     /* Use SA to qualify MEMCS16? */
#define BSP_CS8900_IOCHRDY      NO //YES     /* Use IOCHRDY to slow access? */
#define BSP_CS8900_MEDIA_TYPE   TEN_BASE_T /* Media type */
#define BSP_CS8900_DCDC_POL     LOW     /* DC/DC converter "enable" polarity */
#define BSP_CS8900_FDX          NO      /* Is 10BaseT full duplex? */
#define BSP_CS8900_IND_ADDR     "00:24:20:10:FF:41" /* Individual address */

#endif
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/