/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : Configuration.c
* Author             : MPA Systems Lab
* Date First Issued  : 21/03/2005
* Description        : Configuration Functions
*                      
********************************************************************************
* History:
* 21/03/2005
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"
#include "Interface.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/

//******************************************************************
//*	EMI CS8900A interface
//******************************************************************

#define		ETHER_INT_NUM	11
#define		ETHER_INT	1 << ETHER_INT_NUM
#define		ETHER_RST_NUM	7
#define		ETHER_RST	1 << ETHER_RST_NUM
#define		ETHER_BASE	0x64800000 //CS2
#define		ETHER_PORT	GPIO1

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/



/*******************************************************************************
* Function Name  : Eth_Config
* Description    : Interface configuration for CS8900A
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void Eth_Config(void){

#if (USE_GPIO == YES)
	GPIO_Config (CONTROL, (1<<CONTROL_CS | 1<<CONTROL_RD | 1<<CONTROL_W0 | 1<<CONTROL_W1 | 1<<CONTROL_A23), GPIO_OUT_PP);
    GPIO_WordWrite(CONTROL, (1<<CONTROL_CS | 1<<CONTROL_RD | 1<<CONTROL_W0 | 1<<CONTROL_W1 | 1<<CONTROL_A23) | GPIO_WordRead(CONTROL));
	GPIO_Config (DATA, 0xFFFF, GPIO_IN_TRI_TTL);
	GPIO_Config (ADDRESS, 0x1FF8, GPIO_OUT_PP);
#else
//Assign an External memory bank to CS8900A and configure timing
//NOTE: Configuration shared with LCD driver
	GPIO_Config (GPIO2, 0xFF, GPIO_AF_PP);
	EMI_Config(2, EMI_ENABLE | EMI_WAITSTATE(15) | EMI_SIZE_16);
#endif	
//Ethernet Interrupt pin configuration... P0.13
	XTI_Init();
	XTI_LineModeConfig(XTI_Line6, XTI_RisingEdge);
	XTI_LineConfig(XTI_Line6, ENABLE);
	XTI_ModeConfig(XTI_Interrupt, ENABLE);
	GPIO_Config (ETHER_PORT, ETHER_INT, GPIO_INOUT_WP);

	EIC_IRQChannelConfig(XTI_IRQChannel, ENABLE);
	EIC_IRQChannelPriorityConfig(XTI_IRQChannel, 4);
	EIC_IRQConfig(ENABLE);
	
//Ethernet Reset pin configuration... P0.12
	GPIO_Config (ETHER_PORT, ETHER_RST, GPIO_OUT_PP);

	GPIO_Config (ETHER_PORT, 1<<12, GPIO_OUT_PP); //debug
	
}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/