/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : EtherDrv.c
* Author             : MPA Systems Lab
* Date First Issued  : 21/03/2005
* Description        : I/O hardware interface, CS8900A driver -> uIP Bridge Function
*                      
********************************************************************************
* History:
* 25/03/2005: Added STR7 driver for EMI
* 27/05/2005: Eliminated Reference to RTL8019AS, Added interface function with CS8900A driver
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"
#include "Lib_bits.h"
#include "lan8900.h"
#include "uip.h"
#include "var.h"
#include <stdio.h>
#include "Interface.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
volatile char temp;

/* Private function prototypes -----------------------------------------------*/
void reset_NIC(void);
void delay_ms(void);
void write_data(char *data,char longueur);
void write_char(char data);
void putch_buff(char b);
void check(char b);

/* Private functions ---------------------------------------------------------*/


/*******************************************************************************
* Function Name  : reset_NIC
* Description    : Performs reset of NIC
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void reset_NIC(void)
{
// Generate Reset pulse with width > 800 nSec.

	GPIO_BitWrite(ETHER_PORT, ETHER_RST_NUM, RESET);
	//delay_ms();
	GPIO_BitWrite(ETHER_PORT, ETHER_RST_NUM, SET);
	//delay_ms();
	GPIO_BitWrite(ETHER_PORT, ETHER_RST_NUM, RESET);


}//end reset_NIC()



/*******************************************************************************
* Function Name  : outw
* Description    : Writes a halfword of data to the given address in the NIC
* Input1          : Address where to write.
* Input2         : Data to write.
* Output		 : None.
* Return         : None.
*******************************************************************************/
void outw(int address, short data)
{
#if (USE_GPIO == YES)
 u16 control = GPIO_WordRead(CONTROL) & (~(1<<CONTROL_CS | 1<<CONTROL_W0 | 1<<CONTROL_W1));
 GPIO_WordWrite(ADDRESS, ~(0x01FFF<<3)); //Address
 GPIO_WordWrite(ADDRESS, ((address<<3) & 0x1FFF<<3) | GPIO_WordRead(ADDRESS)); //Address
 GPIO_WordWrite(CONTROL, control); //Control
 GPIO_Config (DATA, 0xFFFF, GPIO_OUT_PP); //output direction...
 GPIO_WordWrite(DATA, data); //data

 delay_ms(); //wait...

 control = GPIO_WordRead(CONTROL) | (1<<CONTROL_CS | 1<<CONTROL_W0 | 1<<CONTROL_W1);
 GPIO_WordWrite(CONTROL, control); //Control
 GPIO_Config (DATA, 0xFFFF, GPIO_IN_TRI_TTL); //input direction...
#else
 short* a;
 a = (short*)(int)(ETHER_BASE + address);
 *a = data;
#endif
}


/*******************************************************************************
* Function Name  : inb
* Description    : Read a byte of data from the NIC located in the given address
* Input          : Address to read from.
* Output         : Read data.
* Return         : Read data.
*******************************************************************************/
char inb(int address)
{
#if (USE_GPIO == YES)
 u8 data;
 u16 control = GPIO_WordRead(CONTROL) & (~(1<<CONTROL_CS | 1<<CONTROL_RD));
 GPIO_Config (DATA, 0xFFFF, GPIO_IN_TRI_TTL); //input direction...
 GPIO_WordWrite(ADDRESS, ~(0x01FFF<<3)); //Address
 GPIO_WordWrite(ADDRESS, ((address<<3) & 0x1FFF<<3) | GPIO_WordRead(ADDRESS)); //Address
 GPIO_WordWrite(CONTROL, control); //Control
 
 delay_ms(); //wait...

 if ( address & 1 )
 	data = GPIO_ByteRead(DATA, GPIO_MSB);
 else
	data = GPIO_ByteRead(DATA, GPIO_LSB);
 control = GPIO_WordRead(CONTROL) | (1<<CONTROL_CS | 1<<CONTROL_RD);
 GPIO_WordWrite(CONTROL, control); //Control 
 return data;
#else
 char* a;
 a = (char*)(int)(ETHER_BASE + address);
 return(*a);
#endif
 
}


/*******************************************************************************
* Function Name  : inw
* Description    : Read a halfword of data from the NIC located in the given address
* Input          : Address to read from.
* Output         : Read data.
* Return         : Read data.
*******************************************************************************/
short inw(int address)
{
#if (USE_GPIO == YES)
 u16 data;
 u16 control = GPIO_WordRead(CONTROL) & (~(1<<CONTROL_CS | 1<<CONTROL_RD));
 GPIO_Config (DATA, 0xFFFF, GPIO_IN_TRI_TTL); //input direction...
 GPIO_WordWrite(ADDRESS, ~(0x01FFF<<3)); //Address 
 GPIO_WordWrite(ADDRESS, ((address<<3) & 0x01FFF<<3) | GPIO_WordRead(ADDRESS)); //Address
 GPIO_WordWrite(CONTROL, control); //Control
 
 delay_ms(); //wait...

 data = GPIO_WordRead(DATA);
 control = GPIO_WordRead(CONTROL) | (1<<CONTROL_CS | 1<<CONTROL_RD);
 GPIO_WordWrite(CONTROL, control); //Control
 return data;
#else
 volatile short* a;
 
 a = (volatile short*)(int)(ETHER_BASE + address);
 return(*a);
#endif
}


/*******************************************************************************
* Function Name  : delay_ms
* Description    : Temporisation
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void delay_ms(void)
{
char j,k;
for(j=0;j<49;j++)
  for(k=0;k<0xff;k++)
  {__asm
  	{nop
     nop
     nop
     nop 
     nop
    }
   }  
}//end delay_ms()


/*******************************************************************************
* Function Name  : check
* Description    : Add a byte to the Checksum
* Input          : Data byte to add. 
* Output         : None.
* Return         : None.
*******************************************************************************/
void check(char b)
{
   if (checkflag)
    {if ((check_L = b+check_L) < b)
        {if (++check_H == 0)
          check_L++;
        }
    }
    else
    {if ((check_H = b+check_H) < b)
        {if (++check_L == 0)
          check_H++;}
    }
    checkflag = !checkflag;
}//end check_char(char b) 
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/