/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : slipdrv.c
* Author             : MPA Systems Lab
* Date First Issued  : 12/07/2005
* Description        : SLIP driver.
*                      
********************************************************************************
* History:
* 12/07/2005
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include <stdio.h>
#include "71x_lib.h"
#include "uip.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
// UART pin numbers depending on the chip package
#define UART0_Rx_Pin (1<<8)   // TQFP 64: pin N 63 , TQFP 144 pin N 143
#define UART0_Tx_Pin (1<<9)   // TQFP 64: pin N 64 , TQFP 144 pin N 144

#define UART1_Rx_Pin (1<<10)  // TQFP 64: pin N 1  , TQFP 144 pin N 1
#define UART1_Tx_Pin (1<<11)  // TQFP 64: pin N 2  , TQFP 144 pin N 3

#define UART2_Rx_Pin (1<<13)  // TQFP 64: pin N 5  , TQFP 144 pin N 9
#define UART2_Tx_Pin (1<<14)  // TQFP 64: pin N 6  , TQFP 144 pin N 10

#define UART3_Rx_Pin (1<<1)   // TQFP 64: pin N 52 , TQFP 144 pin N 123
#define UART3_Tx_Pin (1<<0)   // TQFP 64: pin N 53 , TQFP 144 pin N 124

/* Private macro -------------------------------------------------------------*/
// select which UART to use
#ifdef USE_UART0
  #define UARTx         UART0
  #define UARTx_Rx_Pin  UART0_Rx_Pin
  #define UARTx_Tx_Pin  UART0_Tx_Pin
#endif

#ifdef USE_UART1
  #define UARTx         UART1
  #define UARTx_Rx_Pin  UART1_Rx_Pin
  #define UARTx_Tx_Pin  UART1_Tx_Pin
#endif

#ifdef USE_UART2
  #define UARTx         UART2
  #define UARTx_Rx_Pin  UART2_Rx_Pin
  #define UARTx_Tx_Pin  UART2_Tx_Pin
#endif

#ifdef USE_UART3
  #define UARTx         UART3
  #define UARTx_Rx_Pin  UART3_Rx_Pin
  #define UARTx_Tx_Pin  UART3_Tx_Pin
#endif

#ifndef UARTx
  #error You must define USE_UART{0..3} in 71x_conf.h
#endif

/* Private variables ---------------------------------------------------------*/
unsigned char buf[1500];
unsigned short index = 0;
unsigned short lenght = 0;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/



/*******************************************************************************
* Function Name  : Comm_Conf
* Description    : UART configuration function.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void Comm_Conf(void){

  // UART configuration
  // Configure the GPIO pins as alternate function push-pull
  GPIO_Config(GPIO0, UARTx_Rx_Pin | UARTx_Tx_Pin, GPIO_AF_PP);
  UART_FifoConfig (UARTx, DISABLE);  // Disable FIFOs
  UART_FifoReset  (UARTx, UART_RxFIFO);   // Reset the RxFIFO
  UART_FifoReset  (UARTx, UART_TxFIFO);   // Reset the TxFIFO
  UART_LoopBackConfig(UARTx, DISABLE);  // Disable Loop Back
  UART_RxConfig(UARTx, ENABLE);   // Enable Rx
  UART_RxConfig(UARTx, DISABLE);  // Disable Rx
  /* Configure the UART as following:
     - Baudrate = 9600 bps
     - No parity
     - 8 data bits
     - 1 stop bit */
  UART_Config(UARTx, 57600, UART_NO_PARITY, UART_1_StopBits, UARTM_8D);
  UART_OnOffConfig(UARTx, ENABLE);

  //EIC_Init();
  EIC_IRQConfig(ENABLE);
  EIC_IRQChannelPriorityConfig(UART0_IRQChannel, 0x05);
  EIC_IRQChannelConfig(UART0_IRQChannel, ENABLE);
  UART_ItConfig(UART0, UART_RxBufFull, ENABLE);
  
  UART_FifoConfig (UARTx, ENABLE); //Enable FIFOs
  UART_RxConfig(UARTx, ENABLE);   // Enable Rx
}

/*******************************************************************************
* Function Name  : slipdev_char_put
* Description    : Sends a byte to the serial communication port.
* Input          : Data byte to send.
* Output         : None.
* Return         : None.
*******************************************************************************/
void slipdev_char_put(u8_t c){

	UART_ByteSend(UARTx,(u8 *)&c);
}

/*******************************************************************************
* Function Name  : slipdev_char_poll
* Description    : Reads a byte from the serial communication buffer.
* Input          : None.
* Output         : Read data byte.
* Return         : 1 if the byte is read successful. 0 if the serial communication buffer is empty.
*******************************************************************************/
u8_t slipdev_char_poll(u8_t *c){

	if ( lenght > 0 ){
		*c = buf[index++];
		lenght--;
		return 1;
	}
	else{
		UART_RxConfig(UARTx, ENABLE);   // Enable Rx
		return 0;
	}

}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/