/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : ethdev.c
* Author             : MPA Systems Lab
* Date First Issued  : 06/04/2005
* Description        : Ethernet Device Driver, uIP <-> CS8900A Bridge Module.
*                      
********************************************************************************
* History:
* 06/04/2005
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "uip_arp.h"
#include "uip.h"
#include "lan8900.h"
#include "Configuration.h"
#include "EtherDrv.h"
#include "71x_type.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
#define BUF ((struct uip_eth_hdr *)&uip_buf[0])
/* Private variables ---------------------------------------------------------*/
bool NewMsg;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/


extern unsigned long csInitialize( void (*ap_addr)(mblk_t *) );
extern void csProcessISQ(void);
extern unsigned long csSend( PIA, mblk_t * );
extern IA csHardwareAddr;
extern mblk_t TxMsg, RxMsg;


/*******************************************************************************
* Function Name  : ethdev_init
* Description    : Ethernet Device Initialization
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
int
ethdev_init(void)
{
 volatile char a;
 volatile short b;
	Eth_Config();
	reset_NIC();
	delay_ms();
//debug
	inb( PORT_PKTPG_PTR   );
	inb( PORT_PKTPG_PTR+1 );
	inb( PORT_PKTPG_PTR   );
	delay_ms();         
	
	if ( csInitialize(ProcessMsg) != FAILURE ){
	#ifdef MY_DEBUG	
		printf("Device initialization... Done.\n");
		printf("MAC Address: %X-%X-%X-%X-%X-%X\n", csHardwareAddr.word[0]&0xFF, csHardwareAddr.word[0]>>8,
												   csHardwareAddr.word[1]&0xFF, csHardwareAddr.word[1]>>8,
												   csHardwareAddr.word[2]&0xFF, csHardwareAddr.word[2]>>8);
	#endif
	return 1;	
	}
	else{
	#ifdef MY_DEBUG	
		printf("Device initialization... Failed!\n");
	#endif
	}
	return 0;	
}

/*******************************************************************************
* Function Name  : ethdev_read
* Description    : Transfers received Ethernet packet to uIP buffer 
* Input          : None.
* Output         : None.
* Return         : Packet lenght.
*******************************************************************************/
unsigned int
ethdev_read(void)
{
  int i;
  
  mblk_t *pMsg = &RxMsg;
  if ( NewMsg )
	if (uip_len == 0){ //not transmission in progress
		for( i=0; i < pMsg->dim; i++)
			uip_buf[i] = (pMsg->buff)[i];

		uip_len = pMsg->dim;
		NewMsg = FALSE;
	}
	
  return uip_len; //return lenght
}

/*******************************************************************************
* Function Name  : ethdev_send
* Description    : Transfers Ethernet packet to send from uIP buffer to NIC driver buffer and starts a send request.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void
ethdev_send(void)
{
  char tmpbuf[UIP_BUFSIZE];
  int i;
  IA DestAddr;

    for(i = 0; i < 40 + UIP_LLH_LEN; i++) {
      tmpbuf[i] = uip_buf[i];
    }
    
    for(; i < uip_len; i++) {
      tmpbuf[i] = uip_appdata[i - 40 - UIP_LLH_LEN];
    }
	DestAddr.word[0] = ((unsigned short*)(BUF->dest.addr))[0];
	DestAddr.word[1] = ((unsigned short*)(BUF->dest.addr))[1];
    	DestAddr.word[2] = ((unsigned short*)(BUF->dest.addr))[2];

	TxMsg.dim = uip_len - UIP_LLH_LEN; //+ 14; //TO VERIFY!!!
	TxMsg.type = BUF->type;
	for(i=0; i < uip_len; i++)
		TxMsg.buff[i] = tmpbuf[i + UIP_LLH_LEN];

    csSend( &DestAddr, &TxMsg );
    //ret = write(fd, tmpbuf, uip_len);

} 


/*******************************************************************************
* Function Name  : ProcessMsg
* Description    : Frame reception Notification Function
* Input          : Pointer message (not used, present for compatibility).
* Output         : None.
* Return         : None.
*******************************************************************************/
void ProcessMsg( mblk_t *pMsg ){
	NewMsg = TRUE;
}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/